/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projectconfig.beans;

import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.projectconfig.beans.SimpleIssueType;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class SimpleIssueTypeImpl
implements SimpleIssueType {
    private final String iconUrl;
    private final String name;
    private final String description;
    private final String id;
    private final boolean subTask;
    private final boolean defaultIssueType;
    private final IssueType issueType;

    public SimpleIssueTypeImpl(IssueType issueType, boolean defaultIssueType) {
        this.issueType = issueType;
        this.id = issueType.getId();
        this.name = issueType.getNameTranslation();
        this.description = issueType.getDescTranslation();
        this.iconUrl = issueType.getIconUrl();
        this.subTask = issueType.isSubTask();
        this.defaultIssueType = defaultIssueType;
    }

    public SimpleIssueTypeImpl(String id, String name, String description, String iconUrl, boolean subTask, boolean defaultIssueType) {
        this.id = id;
        this.name = name;
        this.iconUrl = iconUrl;
        this.subTask = subTask;
        this.defaultIssueType = defaultIssueType;
        this.issueType = null;
        this.description = description;
    }

    @Override
    public String getIconUrl() {
        return this.iconUrl;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isDefault() {
        return this.isDefaultIssueType();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isSubTask() {
        return this.subTask;
    }

    @Override
    public boolean isDefaultIssueType() {
        return this.defaultIssueType;
    }

    @Override
    public IssueType getConstant() {
        return this.issueType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleIssueTypeImpl that = (SimpleIssueTypeImpl)o;
        if (this.defaultIssueType != that.defaultIssueType) {
            return false;
        }
        if (this.subTask != that.subTask) {
            return false;
        }
        if (this.iconUrl != null ? !this.iconUrl.equals(that.iconUrl) : that.iconUrl != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.iconUrl != null ? this.iconUrl.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.subTask ? 1 : 0);
        result = 31 * result + (this.defaultIssueType ? 1 : 0);
        return result;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

