/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.webwork;

import com.atlassian.jira.plugins.dvcs.webwork.IssueLinker;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import com.google.common.base.Preconditions;
import com.opensymphony.util.TextUtils;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IssueLinkerImpl
implements IssueLinker {
    private static final String PRE_LINK_PATTERN_STRING = "(?<![&=\\?>^!~/\\.\\[])\\b";
    private static final String POST_LINK_PATTERN_STRING = "\\b";
    private static final String LINK_JIRA_PATTERN_STRING = "(?<![&=\\?>^!~/\\.\\[])\\b(\\p{Lu}{2,}-\\p{Digit}+)\\b";
    private static final Pattern LINK_JIRA_PATTERN = Pattern.compile("(?<![&=\\?>^!~/\\.\\[])\\b(\\p{Lu}{2,}-\\p{Digit}+)\\b");
    private static final String ISSUE_URL_PATTERN = "{0}/browse/{1}";
    private static final String ISSUE_LINK_PATTERN = "<a href=\"{0}\">{1}</a>";
    private final ApplicationProperties applicationProperties;

    @Autowired
    public IssueLinkerImpl(@ComponentImport ApplicationProperties applicationProperties) {
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties);
    }

    @Override
    @HtmlSafe
    public String createLinks(String unlinkedText) {
        Matcher matcher;
        if (StringUtils.isBlank((CharSequence)unlinkedText)) {
            return "";
        }
        String baseUrl = this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE);
        StringBuilder linkedText = new StringBuilder();
        String text = TextUtils.htmlEncode((String)unlinkedText);
        while ((matcher = LINK_JIRA_PATTERN.matcher(text)).find()) {
            linkedText.append(text.substring(0, matcher.start(1)));
            String key = matcher.group(1);
            String url = MessageFormat.format(ISSUE_URL_PATTERN, baseUrl, key);
            String aLink = MessageFormat.format(ISSUE_LINK_PATTERN, url, key);
            linkedText.append(aLink);
            text = text.substring(matcher.end(1));
        }
        linkedText.append(text);
        return linkedText.toString();
    }
}

