/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.webwork;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.plugins.dvcs.util.SystemUtils;
import com.atlassian.jira.plugins.dvcs.webwork.IssueAndProjectKeyManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IssueAndProjectKeyManagerImpl
implements IssueAndProjectKeyManager {
    private final ChangeHistoryManager changeHistoryManager;
    private final IssueManager issueManager;
    private final JiraAuthenticationContext authenticationContext;
    private final PermissionManager permissionManager;
    private final ProjectManager projectManager;

    @Autowired
    public IssueAndProjectKeyManagerImpl(@ComponentImport IssueManager issueManager, @ComponentImport ChangeHistoryManager changeHistoryManager, @ComponentImport ProjectManager projectManager, @ComponentImport PermissionManager permissionManager, @ComponentImport JiraAuthenticationContext authenticationContext) {
        this.authenticationContext = (JiraAuthenticationContext)Preconditions.checkNotNull((Object)authenticationContext);
        this.changeHistoryManager = (ChangeHistoryManager)Preconditions.checkNotNull((Object)changeHistoryManager);
        this.issueManager = (IssueManager)Preconditions.checkNotNull((Object)issueManager);
        this.permissionManager = (PermissionManager)Preconditions.checkNotNull((Object)permissionManager);
        this.projectManager = (ProjectManager)Preconditions.checkNotNull((Object)projectManager);
    }

    @Override
    public Set<String> getAllIssueKeys(Issue issue) {
        if (issue == null) {
            return Collections.emptySet();
        }
        return SystemUtils.getAllIssueKeys((IssueManager)this.issueManager, (ChangeHistoryManager)this.changeHistoryManager, (Issue)issue);
    }

    @Override
    public Issue getIssue(String issueKey) {
        return this.issueManager.getIssueObject(issueKey);
    }

    @Override
    public Project getProject(String projectKey) {
        return this.projectManager.getProjectObjByKey(projectKey);
    }

    @Override
    public Set<String> getAllIssueKeys(String issueKey) {
        MutableIssue issue = this.issueManager.getIssueObject(issueKey);
        return this.getAllIssueKeys((Issue)issue);
    }

    @Override
    public Set<String> getAllProjectKeys(Project project) {
        return SystemUtils.getAllProjectKeys((ProjectManager)this.projectManager, (Project)project);
    }

    @Override
    public Set<String> getAllProjectKeys(String projectKey) {
        return SystemUtils.getAllProjectKeys((ProjectManager)this.projectManager, (Project)this.projectManager.getProjectObjByKey(projectKey));
    }

    @Override
    public boolean hasIssuePermission(ProjectPermissionKey permissionKey, Issue issue) {
        if (issue == null) {
            throw new IllegalArgumentException("The issue cannot be null");
        }
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        return this.permissionManager.hasPermission(permissionKey, issue, user);
    }

    @Override
    public boolean hasProjectPermission(ProjectPermissionKey permissionKey, Project project) {
        if (project == null) {
            throw new IllegalArgumentException("The project cannot be null");
        }
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        return this.permissionManager.hasPermission(permissionKey, project, user);
    }
}

