/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.webwork;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.plugins.dvcs.ProjectTypeKeys;
import com.atlassian.jira.plugins.dvcs.analytics.event.DvcsConfigPageShownAnalyticsEvent;
import com.atlassian.jira.plugins.dvcs.analytics.event.Source;
import com.atlassian.jira.plugins.dvcs.bbrebrand.BitbucketRebrandDarkFeature;
import com.atlassian.jira.plugins.dvcs.featurediscovery.FeatureDiscoveryService;
import com.atlassian.jira.plugins.dvcs.listener.PluginFeatureDetector;
import com.atlassian.jira.plugins.dvcs.model.Organization;
import com.atlassian.jira.plugins.dvcs.service.InvalidOrganizationManager;
import com.atlassian.jira.plugins.dvcs.service.InvalidOrganizationsManagerImpl;
import com.atlassian.jira.plugins.dvcs.service.OrganizationService;
import com.atlassian.jira.plugins.dvcs.service.remote.SyncDisabledHelper;
import com.atlassian.jira.plugins.dvcs.spi.bitbucket.clientlibrary.BitbucketDetails;
import com.atlassian.jira.projects.unlicensed.UnlicensedProjectPageRenderer;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.software.api.conditions.SoftwareGlobalAdminCondition;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.action.ActionViewDataMappings;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atlassian.webresource.api.assembler.RequiredResources;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ConfigureDvcsOrganizations
extends JiraWebActionSupport {
    @VisibleForTesting
    public static final String GIT_HUB_ENTERPRISE_NAME = "GitHub Enterprise";
    @VisibleForTesting
    static final String BITBUCKET_CLOUD_NAME = "Bitbucket Cloud";
    @VisibleForTesting
    static final String BITBUCKET_CLOUD_NAME_NO_REBRAND = "Bitbucket";
    @VisibleForTesting
    static final String GIT_HUB_NAME = "GitHub";
    @VisibleForTesting
    static final String SYNCHRONIZATION_DISABLED_TITLE_KEY = "com.atlassian.jira.plugins.dvcs.configure-dvcs-organizations.synchronization-disabled-title";
    @VisibleForTesting
    static final String SYNCHRONIZATION_ALL_DISABLED_TITLE_KEY = "com.atlassian.jira.plugins.dvcs.configure-dvcs-organizations.synchronization-all-disabled-title";
    @VisibleForTesting
    static final String SYNCHRONIZATION_DISABLED_MESSAGE_KEY = "com.atlassian.jira.plugins.dvcs.configure-dvcs-organizations.synchronization-disabled-message";
    @VisibleForTesting
    static final String SYNCHRONIZATION_ALL_DISABLED_MESSAGE_KEY = "com.atlassian.jira.plugins.dvcs.configure-dvcs-organizations.synchronization-all-disabled-message";
    @VisibleForTesting
    static final String UNLICENSED = "unlicensed";
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigureDvcsOrganizations.class);
    private static final String CONTENT_DATA_MAP_KEY = "content";
    private static final String DEFAULT_SOURCE = "unknown";
    private static final String UNLICENSED_PAGE_WEB_RESOURCE = "com.atlassian.jira.plugins.jira-bitbucket-connector-plugin:unlicensed-page-resources";
    private final BitbucketRebrandDarkFeature bitbucketRebrandDarkFeature;
    private final EventPublisher eventPublisher;
    private final FeatureManager featureManager;
    private final I18nHelper i18nHelper;
    private final InvalidOrganizationManager invalidOrganizationsManager;
    private final OrganizationService organizationService;
    private final PageBuilderService pageBuilderService;
    private final PluginFeatureDetector pluginFeatureDetector;
    private final SoftwareGlobalAdminCondition softwareGlobalAdminCondition;
    private final SyncDisabledHelper syncDisabledHelper;
    private final UnlicensedProjectPageRenderer unlicensedProjectPageRenderer;
    private final ApplicationProperties applicationProperties;
    private final FeatureDiscoveryService featureDiscoveryService;
    private String postCommitRepositoryType;
    private String source = "unknown";

    @Autowired
    public ConfigureDvcsOrganizations(@ComponentImport EventPublisher eventPublisher, @ComponentImport FeatureManager featureManager, @ComponentImport I18nHelper i18nhelper, @ComponentImport PageBuilderService pageBuilderService, @ComponentImport PluginSettingsFactory pluginSettingsFactory, @ComponentImport UnlicensedProjectPageRenderer unlicensedProjectPageRenderer, @ComponentImport ApplicationProperties applicationProperties, BitbucketRebrandDarkFeature bitbucketRebrandDarkFeature, FeatureDiscoveryService featureDiscoveryService, OrganizationService organizationService, PluginFeatureDetector featuresDetector, SoftwareGlobalAdminCondition softwareGlobalAdminCondition, SyncDisabledHelper syncDisabledHelper) {
        this.bitbucketRebrandDarkFeature = (BitbucketRebrandDarkFeature)Preconditions.checkNotNull((Object)bitbucketRebrandDarkFeature);
        this.eventPublisher = (EventPublisher)Preconditions.checkNotNull((Object)eventPublisher);
        this.featureManager = (FeatureManager)Preconditions.checkNotNull((Object)featureManager);
        this.i18nHelper = (I18nHelper)Preconditions.checkNotNull((Object)i18nhelper);
        this.invalidOrganizationsManager = new InvalidOrganizationsManagerImpl(pluginSettingsFactory);
        this.organizationService = (OrganizationService)Preconditions.checkNotNull((Object)organizationService);
        this.pageBuilderService = (PageBuilderService)Preconditions.checkNotNull((Object)pageBuilderService);
        this.pluginFeatureDetector = (PluginFeatureDetector)Preconditions.checkNotNull((Object)featuresDetector);
        this.softwareGlobalAdminCondition = (SoftwareGlobalAdminCondition)Preconditions.checkNotNull((Object)softwareGlobalAdminCondition);
        this.syncDisabledHelper = (SyncDisabledHelper)Preconditions.checkNotNull((Object)syncDisabledHelper);
        this.unlicensedProjectPageRenderer = (UnlicensedProjectPageRenderer)Preconditions.checkNotNull((Object)unlicensedProjectPageRenderer);
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties);
        this.featureDiscoveryService = (FeatureDiscoveryService)Preconditions.checkNotNull((Object)featureDiscoveryService);
    }

    protected void doValidation() {
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        LOGGER.debug("Configure organization default action.");
        this.eventPublisher.publish((Object)new DvcsConfigPageShownAnalyticsEvent(this.getSourceOrDefault()));
        return "input";
    }

    public String doDefault() throws Exception {
        if (this.softwareGlobalAdminCondition.shouldDisplay(Collections.emptyMap())) {
            return this.doExecute();
        }
        return UNLICENSED;
    }

    @ActionViewDataMappings(value={"unlicensed"})
    public Map<String, Object> getUnlicensedViewData() {
        RequiredResources requiredResources = this.pageBuilderService.assembler().resources().requireWebResource(UNLICENSED_PAGE_WEB_RESOURCE);
        return ImmutableMap.of((Object)CONTENT_DATA_MAP_KEY, (Object)this.unlicensedProjectPageRenderer.render(requiredResources, ProjectTypeKeys.SOFTWARE));
    }

    public List<Organization> loadOrganizations() {
        List allOrganizations = this.organizationService.getAll(true);
        this.sort(allOrganizations);
        return allOrganizations;
    }

    public boolean isInvalidOrganization(Organization organization) {
        return !this.invalidOrganizationsManager.isOrganizationValid(organization.getId());
    }

    private void sort(List<Organization> allOrganizations) {
        Collections.sort(allOrganizations, (org1, org2) -> org1.getName().compareToIgnoreCase(org2.getName()));
    }

    public String getPostCommitRepositoryType() {
        return this.postCommitRepositoryType;
    }

    public void setPostCommitRepositoryType(String postCommitRepositoryType) {
        this.postCommitRepositoryType = postCommitRepositoryType;
    }

    public boolean isUserInvitationsEnabled() {
        return this.pluginFeatureDetector.isUserInvitationsEnabled();
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public Source getSourceOrDefault() {
        return StringUtils.isNotBlank((CharSequence)this.source) ? Source.valueOf((String)this.source.toUpperCase()) : Source.UNKNOWN;
    }

    public boolean isGitHubSyncDisabled() {
        return this.syncDisabledHelper.isGithubSyncDisabled();
    }

    public boolean isBitbucketSyncDisabled() {
        return this.syncDisabledHelper.isBitbucketSyncDisabled();
    }

    public boolean isGitHubEnterpriseSyncDisabled() {
        return this.syncDisabledHelper.isGithubEnterpriseSyncDisabled();
    }

    public boolean isAnySyncDisabled() {
        return this.syncDisabledHelper.isBitbucketSyncDisabled() || this.syncDisabledHelper.isGithubSyncDisabled() || this.syncDisabledHelper.isGithubEnterpriseSyncDisabled();
    }

    public boolean isAllSyncDisabled() {
        return this.syncDisabledHelper.isBitbucketSyncDisabled() && this.syncDisabledHelper.isGithubSyncDisabled() && this.syncDisabledHelper.isGithubEnterpriseSyncDisabled();
    }

    public String getSyncDisabledWarningTitle() {
        if (!this.isAnySyncDisabled()) {
            return null;
        }
        if (this.syncDisabledHelper.isSyncDisabled()) {
            return this.i18nHelper.getText(SYNCHRONIZATION_ALL_DISABLED_TITLE_KEY);
        }
        return this.i18nHelper.getText(SYNCHRONIZATION_DISABLED_TITLE_KEY, this.getDisabledSystemsList());
    }

    public String getSyncDisabledWarningMessage() {
        if (!this.isAnySyncDisabled()) {
            return null;
        }
        if (this.syncDisabledHelper.isSyncDisabled()) {
            return this.i18nHelper.getText(SYNCHRONIZATION_ALL_DISABLED_MESSAGE_KEY);
        }
        return this.i18nHelper.getText(SYNCHRONIZATION_DISABLED_MESSAGE_KEY, this.getDisabledSystemsList());
    }

    private String getDisabledSystemsList() {
        String bitbucketCloudProductName = BITBUCKET_CLOUD_NAME;
        if (!this.bitbucketRebrandDarkFeature.isBitbucketRebrandEnabled()) {
            bitbucketCloudProductName = BITBUCKET_CLOUD_NAME_NO_REBRAND;
        }
        return Joiner.on((String)"/").skipNulls().join((Object)(this.syncDisabledHelper.isBitbucketSyncDisabled() ? bitbucketCloudProductName : null), (Object)(this.syncDisabledHelper.isGithubSyncDisabled() ? GIT_HUB_NAME : null), new Object[]{this.syncDisabledHelper.isGithubEnterpriseSyncDisabled() ? GIT_HUB_ENTERPRISE_NAME : null});
    }

    public boolean isSyncDisabled(String dvcsType) {
        if ("bitbucket".equals(dvcsType)) {
            return this.isBitbucketSyncDisabled();
        }
        if ("github".equals(dvcsType)) {
            return this.isGitHubSyncDisabled();
        }
        if ("githube".equals(dvcsType)) {
            return this.isGitHubEnterpriseSyncDisabled();
        }
        return false;
    }

    public boolean isBitbucketRebrandEnabled() {
        return this.bitbucketRebrandDarkFeature.isBitbucketRebrandEnabled();
    }

    public boolean isAciEnabled() {
        return this.featureManager.isEnabled("atlassian.plugin.aci.enabled");
    }

    public String getBitbucketOverrideUrl() {
        return BitbucketDetails.getHostUrl();
    }

    public String getJiraInstanceTitle() {
        return this.applicationProperties.getString("jira.title");
    }

    public boolean shouldShowFeatureDiscoveryForUser() {
        return !this.featureDiscoveryService.hasUserSeenFeatureDiscovery();
    }
}

