/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.webwork;

import com.atlassian.fusion.aci.api.model.Installation;
import com.atlassian.jira.plugins.dvcs.model.Organization;
import com.atlassian.jira.plugins.dvcs.spi.bitbucket.clientlibrary.BitbucketDetails;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;

@Named
public class BitbucketPostInstallApprovalActionUrlProvider {
    @VisibleForTesting
    static final String BITBUCKET_BASE_URL = BitbucketDetails.getHostUrl();
    @VisibleForTesting
    static final String CONNECTION_SUCCESS_COMMAND = "connectionSuccessful";
    private static final String DVCS_ADMIN_RELATIVE_URL = "/secure/admin/ConfigureDvcsOrganizations!default.jspa";
    private static final String LOGOUT_RELATIVE_URL = "/secure/Logout.jspa";
    private final ApplicationProperties applicationProperties;

    @Inject
    public BitbucketPostInstallApprovalActionUrlProvider(@ComponentImport ApplicationProperties salApplicationProperties) {
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)salApplicationProperties);
    }

    public String grantAccessButtonRedirectUrl(@Nonnull Organization org) {
        Preconditions.checkNotNull((Object)org);
        return this.dvcsConnectorAdminPageUrl() + this.connectionSuccessfulFragment(org);
    }

    public String cancelButtonUrlForApprovalView(boolean isJiraInitiated, String accountName, Installation installation) {
        if (isJiraInitiated) {
            return this.dvcsConnectorAdminPageUrl();
        }
        return this.bitbucketAddonManagementUrl(accountName, installation);
    }

    public String startAgainButtonUrlForErrorView(boolean isJiraInitiated, String accountName, Installation installation) {
        return this.cancelButtonUrlForErrorView(isJiraInitiated, accountName, installation);
    }

    public String cancelButtonUrlForErrorView(boolean isJiraInitiated, String accountName, Installation installation) {
        if (isJiraInitiated) {
            return this.dvcsConnectorAdminPageUrl();
        }
        return this.bitbucketAddonDirectoryUrl(accountName, installation);
    }

    public String okButtonForNonAdminView(boolean isJiraInitiated, String accountName, Installation installation) {
        if (isJiraInitiated) {
            return this.jiraDashboardUrl();
        }
        return this.bitbucketAddonDirectoryUrl(accountName, installation);
    }

    private String bitbucketAddonDirectoryUrl(String accountName, Installation installation) {
        if (StringUtils.isNotBlank((CharSequence)accountName)) {
            UrlBuilder b = new UrlBuilder(false).addPathUnsafe(this.bitbucketBaseUrl(Optional.ofNullable(installation))).addPath("account").addPath("user").addPath(accountName).addPath("addon-directory");
            return b.toString();
        }
        return this.bitbucketBaseUrl(Optional.ofNullable(installation));
    }

    private String bitbucketAddonManagementUrl(String accountName, Installation installation) {
        if (StringUtils.isNotBlank((CharSequence)accountName)) {
            UrlBuilder b = new UrlBuilder(false).addPathUnsafe(this.bitbucketBaseUrl(Optional.ofNullable(installation))).addPath("account").addPath("user").addPath(accountName).addPath("addon-management");
            return b.toString();
        }
        return this.bitbucketBaseUrl(Optional.ofNullable(installation));
    }

    public String logoutButtonUrl() {
        return this.applicationProperties.getBaseUrl(UrlMode.AUTO) + LOGOUT_RELATIVE_URL;
    }

    @VisibleForTesting
    protected String bitbucketBaseUrl(Optional<Installation> installationOptional) {
        if (installationOptional.isPresent()) {
            return installationOptional.get().getBaseUrl();
        }
        return BITBUCKET_BASE_URL;
    }

    public String dvcsConnectorAdminPageUrl() {
        return this.applicationProperties.getBaseUrl(UrlMode.AUTO) + DVCS_ADMIN_RELATIVE_URL;
    }

    public String jiraDashboardUrl() {
        return this.applicationProperties.getBaseUrl(UrlMode.AUTO);
    }

    private String connectionSuccessfulFragment(Organization org) {
        return "#connectionSuccessful?orgId=" + org.getId();
    }
}

