/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.webwork;

import com.atlassian.fusion.aci.api.model.Installation;
import com.atlassian.fusion.aci.api.service.ACIInstallationService;
import com.atlassian.fusion.aci.api.service.exception.ConnectApplicationNotFoundException;
import com.atlassian.fusion.aci.api.service.exception.InstallationNotFoundException;
import com.atlassian.jira.exception.NotFoundException;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.plugins.dvcs.model.Organization;
import com.atlassian.jira.plugins.dvcs.service.OrganizationService;
import com.atlassian.jira.plugins.dvcs.service.optional.aci.AciInstallationServiceAccessor;
import com.atlassian.jira.plugins.dvcs.webwork.BitbucketPostInstallApprovalActionUrlProvider;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class BitbucketPostInstallApprovalAction
extends JiraWebActionSupport {
    private static final Logger log = LoggerFactory.getLogger(BitbucketPostInstallApprovalAction.class);
    private static final String REQUIRE_RESOURCE_KEY = "com.atlassian.jira.plugins.jira-bitbucket-connector-plugin:bitbucket-post-install-approval-resources";
    private static final String APPROVAL_VIEW_NAME = "approval";
    private static final String APPROVAL_ERROR_VIEW_NAME = "approvalError";
    private static final String NON_ADMIN_VIEW_NAME = "nonAdmin";
    private static final String REDIRECT_TO_ADMIN_VIEW_NAME = "redirectToAdminView";
    private static final String UNKNOWN_ERROR_VIEW_NAME = "unknownError";
    private static final String BITBUCKET_ERROR_ACCESS_DENIED = "access_denied";
    private final AciInstallationServiceAccessor aciInstallationServiceAccessor;
    private final ApplicationProperties salApplicationProperties;
    private final com.atlassian.jira.config.properties.ApplicationProperties jiraApplicationProperties;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final GlobalPermissionManager globalPermissionManager;
    private final BitbucketPostInstallApprovalActionUrlProvider urlProvider;
    private final PageBuilderService pageBuilderService;
    private final OrganizationService organizationService;
    private boolean isJiraInitiated;
    private String principalUuid = "";
    private String accountName = "";
    private String clientKey = "";
    private boolean isApprovalError;
    private boolean isUnknownError;
    private String unknownErrorMessage = "";
    private String bitbucketError = "";
    private String bitbucketErrorDescription = "";
    private Installation installation;
    private Organization organization;

    public BitbucketPostInstallApprovalAction(@ComponentImport ApplicationProperties salApplicationProperties, @ComponentImport com.atlassian.jira.config.properties.ApplicationProperties jiraApplicationProperties, @ComponentImport GlobalPermissionManager globalPermissionManager, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport PageBuilderService pageBuilderService, AciInstallationServiceAccessor aciInstallationServiceAccessor, BitbucketPostInstallApprovalActionUrlProvider urlProvider, OrganizationService organizationService) {
        this.salApplicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)salApplicationProperties);
        this.jiraApplicationProperties = (com.atlassian.jira.config.properties.ApplicationProperties)Preconditions.checkNotNull((Object)jiraApplicationProperties);
        this.jiraAuthenticationContext = (JiraAuthenticationContext)Preconditions.checkNotNull((Object)jiraAuthenticationContext);
        this.globalPermissionManager = (GlobalPermissionManager)Preconditions.checkNotNull((Object)globalPermissionManager);
        this.pageBuilderService = (PageBuilderService)Preconditions.checkNotNull((Object)pageBuilderService);
        this.aciInstallationServiceAccessor = (AciInstallationServiceAccessor)((Object)Preconditions.checkNotNull((Object)((Object)aciInstallationServiceAccessor)));
        this.urlProvider = (BitbucketPostInstallApprovalActionUrlProvider)Preconditions.checkNotNull((Object)urlProvider);
        this.organizationService = (OrganizationService)Preconditions.checkNotNull((Object)organizationService);
    }

    public void setPrincipalUuid(String principalUuid) {
        this.principalUuid = principalUuid;
    }

    public void setClientKey(String clientKey) {
        this.clientKey = clientKey;
    }

    public void setJiraInitiated(String value) {
        this.isJiraInitiated = true;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public void setApprovalError(String error) {
        this.isApprovalError = true;
    }

    public void setUnknownError(String error) {
        this.isUnknownError = true;
    }

    public void setUnknownErrorMessage(String message) {
        this.unknownErrorMessage = message;
    }

    public void setError(String error) {
        this.bitbucketError = error;
    }

    public void setError_description(String errorDescription) {
        this.bitbucketErrorDescription = errorDescription;
    }

    protected String doExecute() {
        this.pageBuilderService.assembler().resources().requireWebResource(REQUIRE_RESOURCE_KEY);
        if (!this.isCurrentUserAdmin()) {
            return NON_ADMIN_VIEW_NAME;
        }
        if (StringUtils.isNotBlank((CharSequence)this.bitbucketError) || StringUtils.isNotBlank((CharSequence)this.bitbucketErrorDescription)) {
            if (BITBUCKET_ERROR_ACCESS_DENIED.equals(this.bitbucketError)) {
                return REDIRECT_TO_ADMIN_VIEW_NAME;
            }
            this.logBitbucketError();
            return UNKNOWN_ERROR_VIEW_NAME;
        }
        this.checkRequiredQueryParams();
        if (this.isApprovalError) {
            return APPROVAL_ERROR_VIEW_NAME;
        }
        if (this.isUnknownError) {
            this.logUnknownError();
            return UNKNOWN_ERROR_VIEW_NAME;
        }
        try {
            this.installation = this.getAciInstallation();
        }
        catch (NotFoundException e) {
            return APPROVAL_ERROR_VIEW_NAME;
        }
        this.organization = this.organizationService.getByHostAndName(this.installation.getBaseUrl(), this.installation.getPrincipalUsername());
        if (this.organization == null) {
            log.debug("Organization does not yet exist, however Aci Installation is present. Triggering Org creation based on the Aci Installation found. Principal id: {}", (Object)this.installation.getPrincipalUuid());
            this.organizationService.createNewOrgBasedOnAciInstallation(this.installation);
            this.organization = this.organizationService.getByHostAndName(this.installation.getBaseUrl(), this.installation.getPrincipalUsername());
            if (this.organization == null) {
                return APPROVAL_ERROR_VIEW_NAME;
            }
        }
        if (this.organization.getApprovalState() == Organization.ApprovalState.APPROVED) {
            return REDIRECT_TO_ADMIN_VIEW_NAME;
        }
        return APPROVAL_VIEW_NAME;
    }

    private boolean isCurrentUserAdmin() {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user);
    }

    private void logUnknownError() {
        log.error("An error occured while a user was trying to approve an Organization. Error message: {}", (Object)this.unknownErrorMessage);
    }

    private void logBitbucketError() {
        log.error("Failed to display BB Connection approval screen due to Bitbucket indicating an error in Jira redirect. Error: {}. Error description: {}", (Object)this.bitbucketError, (Object)this.bitbucketErrorDescription);
    }

    private void checkRequiredQueryParams() {
        if (StringUtils.isBlank((CharSequence)this.principalUuid) && StringUtils.isBlank((CharSequence)this.clientKey)) {
            log.error("We received none of the following query params: principalUuid, clientKey. At least one of them is required for this action.");
            this.isUnknownError = true;
        }
    }

    private Installation getAciInstallation() {
        if (StringUtils.isNotBlank((CharSequence)this.principalUuid)) {
            return this.getAciInstallationByPrincipalUuid(this.principalUuid);
        }
        return this.getAciInstallationByClientKey(this.clientKey);
    }

    private Installation getAciInstallationByPrincipalUuid(String principalUuid) {
        log.debug("Retrieving ACI Installation based on principalUuid: {}", (Object)principalUuid);
        try {
            ACIInstallationService aciInstallationService = this.getAciInstallationService();
            return aciInstallationService.get("jira-bitbucket-connector-plugin", principalUuid);
        }
        catch (ConnectApplicationNotFoundException | InstallationNotFoundException e) {
            String msg = String.format("Cannot retrieve ACI Installation with principalUuid '%s': %s", principalUuid, e.getMessage());
            throw new NotFoundException(msg, e);
        }
    }

    private Installation getAciInstallationByClientKey(String clientKey) {
        log.debug("Retrieving ACI Installation based on clientKey: {}", (Object)clientKey);
        try {
            ACIInstallationService aciInstallationService = this.getAciInstallationService();
            return aciInstallationService.getByClientKey(clientKey);
        }
        catch (ConnectApplicationNotFoundException | InstallationNotFoundException e) {
            String msg = String.format("Cannot retrieve ACI Installation with clientKey '%s': %s", clientKey, e.getMessage());
            throw new NotFoundException(msg, e);
        }
    }

    private ACIInstallationService getAciInstallationService() {
        return this.aciInstallationServiceAccessor.get().orElseThrow(() -> new IllegalStateException("Unable to get an instance of ACIInstallationService from ACIInstallationServiceAccessor"));
    }

    @ActionViewData(value="approval")
    public Map<String, Object> getApprovalViewData() {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        mapBuilder.put((Object)"baseUrl", (Object)this.salApplicationProperties.getBaseUrl(UrlMode.AUTO));
        mapBuilder.put((Object)"orgId", (Object)this.organization.getId());
        mapBuilder.put((Object)"grantAccessButtonRedirectUrl", (Object)this.urlProvider.grantAccessButtonRedirectUrl(this.organization));
        mapBuilder.put((Object)"cancelButtonUrl", (Object)this.urlProvider.cancelButtonUrlForApprovalView(this.isJiraInitiated, this.accountName, this.installation));
        mapBuilder.put((Object)"accountName", (Object)this.installation.getPrincipalUsername());
        mapBuilder.put((Object)"jiraInstanceTitle", (Object)this.jiraApplicationProperties.getString("jira.title"));
        mapBuilder.put((Object)"atlToken", (Object)this.getXsrfToken());
        return mapBuilder.build();
    }

    @ActionViewData(value="nonAdmin")
    public Map<String, Object> getNonAdminViewData() {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        mapBuilder.put((Object)"baseUrl", (Object)this.salApplicationProperties.getBaseUrl(UrlMode.AUTO));
        mapBuilder.put((Object)"okButtonUrl", (Object)this.urlProvider.okButtonForNonAdminView(this.isJiraInitiated, this.accountName, this.installation));
        mapBuilder.put((Object)"logoutButtonUrl", (Object)this.urlProvider.logoutButtonUrl());
        mapBuilder.put((Object)"accountName", (Object)this.accountName);
        mapBuilder.put((Object)"jiraInstanceTitle", (Object)this.jiraApplicationProperties.getString("jira.title"));
        mapBuilder.put((Object)"atlToken", (Object)this.getXsrfToken());
        return mapBuilder.build();
    }

    @ActionViewData(value="approvalError")
    public Map<String, Object> getApprovalErrorViewData() {
        return this.createErrorViewDataCommon();
    }

    @ActionViewData(value="unknownError")
    public Map<String, Object> getUnknownErrorViewData() {
        return this.createErrorViewDataCommon();
    }

    @ActionViewData(value="redirectToAdminView")
    public Map<String, Object> getRedirectToAdminViewData() {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        mapBuilder.put((Object)"redirectUrl", (Object)this.urlProvider.dvcsConnectorAdminPageUrl());
        return mapBuilder.build();
    }

    private Map<String, Object> createErrorViewDataCommon() {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        mapBuilder.put((Object)"accountName", (Object)this.accountName);
        mapBuilder.put((Object)"startAgainButtonUrl", (Object)this.urlProvider.startAgainButtonUrlForErrorView(this.isJiraInitiated, this.accountName, this.installation));
        mapBuilder.put((Object)"cancelButtonUrl", (Object)this.urlProvider.cancelButtonUrlForErrorView(this.isJiraInitiated, this.accountName, this.installation));
        mapBuilder.put((Object)"jiraInstanceTitle", (Object)this.jiraApplicationProperties.getString("jira.title"));
        return mapBuilder.build();
    }
}

