/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.sync.impl;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class IssueKeyExtractor {
    private static final String SEPARATOR = "[\\s\\p{Punct}]";
    private static final String KEY_PREFIX_REGEX = "(?:(?<=[\\s\\p{Punct}])|^)";
    private static final String KEY_BODY_REGEX = "(\\p{Lu}[\\p{Lu}\\p{Digit}_]+-\\p{Digit}+)";
    private static final String KEY_POSTFIX_REGEX = "(?:(?=[\\s\\p{Punct}])|$)";
    private static final String ISSUE_KEY_REGEX = "(?:(?<=[\\s\\p{Punct}])|^)(\\p{Lu}[\\p{Lu}\\p{Digit}_]+-\\p{Digit}+)(?:(?=[\\s\\p{Punct}])|$)";

    private IssueKeyExtractor() {
    }

    public static Set<String> extractIssueKeys(String ... messages) {
        HashSet<String> matches = new HashSet<String>();
        Pattern projectKeyPattern = Pattern.compile(ISSUE_KEY_REGEX, 2);
        for (String message : messages) {
            if (StringUtils.isBlank((CharSequence)message)) continue;
            Matcher match = projectKeyPattern.matcher(message);
            while (match.find()) {
                for (int i = 1; i <= match.groupCount(); ++i) {
                    String issueKey = match.group(i);
                    matches.add(issueKey.toUpperCase());
                }
            }
        }
        return matches;
    }
}

