/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.sync.impl;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.jira.plugins.dvcs.ProgressUtil;
import com.atlassian.jira.plugins.dvcs.activity.RepositoryPullRequestDao;
import com.atlassian.jira.plugins.dvcs.analytics.AnalyticsService;
import com.atlassian.jira.plugins.dvcs.dao.RepositoryDao;
import com.atlassian.jira.plugins.dvcs.dao.SyncAuditLogDao;
import com.atlassian.jira.plugins.dvcs.event.RepositorySync;
import com.atlassian.jira.plugins.dvcs.event.RepositorySyncFactory;
import com.atlassian.jira.plugins.dvcs.exception.SourceControlException;
import com.atlassian.jira.plugins.dvcs.model.DefaultProgress;
import com.atlassian.jira.plugins.dvcs.model.Progress;
import com.atlassian.jira.plugins.dvcs.model.Repository;
import com.atlassian.jira.plugins.dvcs.service.BranchService;
import com.atlassian.jira.plugins.dvcs.service.ChangesetService;
import com.atlassian.jira.plugins.dvcs.service.message.MessagingService;
import com.atlassian.jira.plugins.dvcs.service.remote.DvcsCommunicator;
import com.atlassian.jira.plugins.dvcs.service.remote.DvcsCommunicatorProvider;
import com.atlassian.jira.plugins.dvcs.service.remote.SyncDisabledHelper;
import com.atlassian.jira.plugins.dvcs.spi.github.GithubRateLimitExceededException;
import com.atlassian.jira.plugins.dvcs.spi.github.service.GitHubEventService;
import com.atlassian.jira.plugins.dvcs.sync.SynchronizationFlag;
import com.atlassian.jira.plugins.dvcs.sync.Synchronizer;
import com.atlassian.jira.plugins.dvcs.util.HelpLinkRenderer;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class DefaultSynchronizer
implements Synchronizer {
    @VisibleForTesting
    static final String SYNC_LOCK = DefaultSynchronizer.class.getName() + ".doSync";
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSynchronizer.class);
    private final AnalyticsService analyticsService;
    private final ClusterLockService clusterLockService;
    private final HelpLinkRenderer helpLinkRenderer;
    private final I18nHelper i18nHelper;
    private final RepositoryPullRequestDao repositoryPullRequestDao;
    private final RepositorySyncFactory repoSyncFactory;
    private final SyncAuditLogDao syncAudit;
    private final SyncDisabledHelper syncDisabledHelper;
    private final Cache<Integer, Progress> progressMap;
    @Resource
    private BranchService branchService;
    @Resource
    private ChangesetService changesetService;
    @Resource
    private DvcsCommunicatorProvider dvcsCommunicatorProvider;
    @Resource
    private GitHubEventService gitHubEventService;
    @Resource
    private MessagingService messagingService;
    @Resource
    private RepositoryDao repositoryDao;

    @Inject
    @ParametersAreNonnullByDefault
    public DefaultSynchronizer(@ComponentImport CacheManager cacheManager, @ComponentImport ClusterLockService clusterLockService, @ComponentImport I18nHelper i18nHelper, AnalyticsService analyticsService, HelpLinkRenderer helpLinkRenderer, RepositoryPullRequestDao repositoryPullRequestDao, RepositorySyncFactory repoSyncFactory, SyncAuditLogDao syncAudit, SyncDisabledHelper syncDisabledHelper) {
        Collection keys;
        this.analyticsService = (AnalyticsService)Preconditions.checkNotNull((Object)analyticsService);
        this.clusterLockService = (ClusterLockService)Preconditions.checkNotNull((Object)clusterLockService);
        this.helpLinkRenderer = (HelpLinkRenderer)Preconditions.checkNotNull((Object)helpLinkRenderer);
        this.i18nHelper = (I18nHelper)Preconditions.checkNotNull((Object)i18nHelper);
        this.repositoryPullRequestDao = (RepositoryPullRequestDao)Preconditions.checkNotNull((Object)repositoryPullRequestDao);
        this.repoSyncFactory = (RepositorySyncFactory)Preconditions.checkNotNull((Object)repoSyncFactory);
        this.syncAudit = (SyncAuditLogDao)Preconditions.checkNotNull((Object)syncAudit);
        this.syncDisabledHelper = (SyncDisabledHelper)Preconditions.checkNotNull((Object)syncDisabledHelper);
        this.progressMap = cacheManager.getCache(this.getClass().getName() + ".progressMap");
        if (LOG.isDebugEnabled() && !(keys = this.progressMap.getKeys()).isEmpty()) {
            LOG.debug("clearing progressMap of size {} ", (Object)keys.size());
        }
        this.progressMap.removeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSync(@Nonnull Repository repo, @Nonnull Collection<SynchronizationFlag> flagsOrig) {
        EnumSet<SynchronizationFlag> flags;
        DvcsCommunicator communicator = this.dvcsCommunicatorProvider.getCommunicator(repo.getDvcsType());
        if (communicator.isSyncDisabled(repo, flags = EnumSet.copyOf(flagsOrig))) {
            LOG.info("Synchronization is disabled for repository {} ({})", (Object)repo.getName(), (Object)repo.getId());
            throw new SourceControlException.SynchronizationDisabled("Synchronization is disabled for repository " + repo.getName() + " (" + repo.getId() + ")");
        }
        if (repo.isLinked() && !repo.isDeleted()) {
            Progress progress;
            if (this.branchService.getListOfBranchHeads(repo).isEmpty()) {
                flags.remove(SynchronizationFlag.SOFT_SYNC);
            }
            if ((progress = this.startProgressSafely(repo, flags)) == null) {
                return;
            }
            RepositorySync repoSync = this.repoSyncFactory.getInstance(repo, flags);
            int auditLogId = 0;
            try {
                auditLogId = this.createSyncAuditLog(repo, flags, progress.getStartTime());
                this.analyticsService.publishRepositorySyncStart(auditLogId, repo, flags);
                progress.setAuditLogId(auditLogId);
                if (!flags.contains(SynchronizationFlag.SOFT_SYNC)) {
                    if (!this.syncDisabledHelper.isFullSychronizationDisabled()) {
                        this.removeRepoDataForFullSync(repo, flags);
                    } else {
                        LOG.info("Full synchronization is disabled. Doing a soft sync for repository {} ({}) instead.", (Object)repo.getName(), (Object)repo.getId());
                    }
                }
                this.retryFailedMessages(repo, auditLogId);
                if (this.syncDisabledHelper.isPullRequestSynchronizationDisabled()) {
                    flags.remove(SynchronizationFlag.SYNC_PULL_REQUESTS);
                }
                communicator.startSynchronisation(repo, flags, auditLogId);
            }
            catch (GithubRateLimitExceededException e) {
                ProgressUtil.setErrorMessage(progress, this.i18nHelper.getText("com.atlassian.jira.plugins.dvcs.sync.paused"), this.i18nHelper.getText("com.atlassian.jira.plugins.dvcs.github.rate.limit.reached"), true);
                LOG.error(e.getMessage());
            }
            catch (SourceControlException.BitbucketInvalidResponseException knownProblem) {
                progress.setError(this.helpLinkRenderer.render("link.dvcs.generic.sync.error"));
                this.syncAudit.setException(auditLogId, knownProblem, false);
            }
            catch (Throwable t) {
                LOG.error(t.getMessage(), t);
                progress.setError(this.helpLinkRenderer.render("link.dvcs.generic.sync.error"));
                this.syncAudit.setException(auditLogId, t, false);
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
            }
            finally {
                repoSync.finish();
                this.messagingService.tryEndProgress(repo, progress, null, auditLogId);
            }
        }
    }

    private int createSyncAuditLog(Repository repo, EnumSet<SynchronizationFlag> flags, long startTime) {
        return this.syncAudit.newSyncAuditLog(repo.getId(), flags, new Date(startTime)).getID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Progress startProgressSafely(@Nonnull Repository repo, @Nonnull EnumSet<SynchronizationFlag> flags) {
        ClusterLock lock = this.clusterLockService.getLockForName(SYNC_LOCK);
        lock.lock();
        try {
            Progress progress = this.getProgress(repo.getId());
            if (DefaultSynchronizer.isInFlight(progress)) {
                this.postponeAnyWebhookSync(flags, progress);
                Progress progress2 = null;
                return progress2;
            }
            Progress progress3 = this.startProgress(repo, flags);
            return progress3;
        }
        finally {
            lock.unlock();
        }
    }

    private static boolean isInFlight(@Nullable Progress progress) {
        return progress != null && !progress.isFinished();
    }

    private void removeRepoDataForFullSync(Repository repo, EnumSet<SynchronizationFlag> flags) {
        this.stopSynchronization(repo);
        if (flags.contains(SynchronizationFlag.SYNC_CHANGESETS)) {
            this.changesetService.removeAllInRepository(repo.getId());
            this.branchService.removeAllBranchHeadsInRepository(repo.getId());
            this.branchService.removeAllBranchesInRepository(repo.getId());
            repo.setLastCommitDate(null);
        }
        if (flags.contains(SynchronizationFlag.SYNC_PULL_REQUESTS)) {
            this.gitHubEventService.removeAll(repo);
            this.repositoryPullRequestDao.removeAll(repo);
            repo.setActivityLastSync(null);
        }
        this.repositoryDao.save(repo);
    }

    private void retryFailedMessages(Repository repo, int auditLogId) {
        try {
            this.messagingService.retry(this.messagingService.getTagForSynchronization(repo), auditLogId);
        }
        catch (Exception e) {
            LOG.warn("Could not resume failed messages.", (Throwable)e);
        }
    }

    private Progress startProgress(Repository repository, EnumSet<SynchronizationFlag> flags) {
        DefaultProgress progress = new DefaultProgress();
        progress.setSoftsync(flags.contains(SynchronizationFlag.SOFT_SYNC));
        progress.setWebHookSync(flags.contains(SynchronizationFlag.WEBHOOK_SYNC));
        progress.start();
        this.putProgress(repository, (Progress)progress);
        return progress;
    }

    private void postponeAnyWebhookSync(EnumSet<SynchronizationFlag> flags, Progress progress) {
        if (flags.contains(SynchronizationFlag.WEBHOOK_SYNC)) {
            LOG.debug("Postponing post-webhook synchronization until after the running synchronization.");
            EnumSet currentFlags = progress.getRunAgainFlags();
            if (currentFlags == null) {
                progress.setRunAgainFlags(flags);
            } else {
                currentFlags.addAll(flags);
            }
        }
    }

    public void stopSynchronization(Repository repository) {
        this.messagingService.cancel(repository);
    }

    public void pauseSynchronization(Repository repository, boolean pause) {
        if (pause) {
            this.messagingService.pause(repository);
        } else {
            this.messagingService.resume(repository);
        }
    }

    public Progress getProgress(int repositoryId) {
        return (Progress)this.progressMap.get((Object)repositoryId);
    }

    public void putProgress(Repository repository, Progress progress) {
        this.progressMap.put((Object)repository.getId(), (Object)progress);
    }

    public void removeProgress(Repository repository) {
        this.progressMap.remove((Object)repository.getId());
    }
}

