/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.sync;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.plugins.dvcs.event.EventLimit;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SyncConfig {
    @VisibleForTesting
    static final String PROPERTY_KEY = "dvcs.connector.scheduler.interval";
    private static final Logger logger = LoggerFactory.getLogger(SyncConfig.class);
    private static final Duration DEFAULT_INTERVAL = Duration.standardHours((long)1L);
    private final ApplicationProperties applicationProperties;
    private final LazyReference<Long> scheduledSyncInterval = new LazyReference<Long>(){

        protected Long create() throws Exception {
            return Long.getLong(SyncConfig.PROPERTY_KEY, DEFAULT_INTERVAL.getMillis());
        }
    };

    @Autowired
    public SyncConfig(@ComponentImport(value="jiraAP") ApplicationProperties applicationProperties) {
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties);
    }

    private static Optional<Integer> optInteger(EventLimit eventLimit, @Nullable String override) {
        if (override != null) {
            try {
                return Optional.of((Object)Integer.parseInt(override));
            }
            catch (NumberFormatException e) {
                logger.warn("Ignoring invalid limit override for {}: {}", (Object)eventLimit, (Object)override);
            }
        }
        return Optional.absent();
    }

    public long scheduledSyncIntervalMillis() {
        return (Long)this.scheduledSyncInterval.get();
    }

    public int getEffectiveLimit(@Nonnull EventLimit eventLimit) {
        Preconditions.checkNotNull((Object)eventLimit, (Object)"eventLimit");
        Optional<Integer> appProperty = SyncConfig.optInteger(eventLimit, this.applicationProperties.getString(eventLimit.getOverrideLimitProperty()));
        if (appProperty.isPresent()) {
            return (Integer)appProperty.get();
        }
        Optional<Integer> sysProperty = SyncConfig.optInteger(eventLimit, System.getProperty(eventLimit.getOverrideLimitProperty()));
        if (sysProperty.isPresent()) {
            return (Integer)sysProperty.get();
        }
        return eventLimit.getDefaultLimit();
    }

    public void setEffectiveLimit(@Nonnull EventLimit eventLimit, @Nullable Integer newLimit) {
        Preconditions.checkNotNull((Object)eventLimit, (Object)"eventLimit");
        this.applicationProperties.setString(eventLimit.getOverrideLimitProperty(), newLimit != null ? newLimit.toString() : null);
    }
}

