/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.streams;

import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.plugins.dvcs.model.Changeset;
import com.atlassian.jira.plugins.dvcs.model.DvcsUser;
import com.atlassian.jira.plugins.dvcs.model.GlobalFilter;
import com.atlassian.jira.plugins.dvcs.model.Repository;
import com.atlassian.jira.plugins.dvcs.service.ChangesetService;
import com.atlassian.jira.plugins.dvcs.service.RepositoryService;
import com.atlassian.jira.plugins.dvcs.webwork.IssueAndProjectKeyManager;
import com.atlassian.jira.plugins.dvcs.webwork.IssueLinker;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.streams.api.ActivityObjectTypes;
import com.atlassian.streams.api.ActivityRequest;
import com.atlassian.streams.api.ActivityVerbs;
import com.atlassian.streams.api.Html;
import com.atlassian.streams.api.StreamsEntry;
import com.atlassian.streams.api.StreamsException;
import com.atlassian.streams.api.StreamsFeed;
import com.atlassian.streams.api.UserProfile;
import com.atlassian.streams.api.common.ImmutableNonEmptyList;
import com.atlassian.streams.api.common.NonEmptyIterable;
import com.atlassian.streams.api.common.Option;
import com.atlassian.streams.spi.CancellableTask;
import com.atlassian.streams.spi.CancelledException;
import com.atlassian.streams.spi.Filters;
import com.atlassian.streams.spi.StandardStreamsFilterOption;
import com.atlassian.streams.spi.StreamsActivityProvider;
import com.atlassian.streams.spi.UserProfileAccessor;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DvcsStreamsActivityProvider
implements StreamsActivityProvider {
    @VisibleForTesting
    static final String STREAMS_EXTERNAL_FEED_TITLE_KEY = "streams.external.feed.title";
    @VisibleForTesting
    static final String SUMMARY_TEMPLATE_NAME = "/templates/activityentry-summary.vm";
    @VisibleForTesting
    static final String TITLE_TEMPLATE_NAME = "/templates/activityentry-title.vm";
    private static final Logger log = LoggerFactory.getLogger(DvcsStreamsActivityProvider.class);
    private static final String STATUS = "status";
    private final ApplicationProperties applicationProperties;
    private final ChangesetService changesetService;
    private final I18nResolver i18nResolver;
    private final IssueAndProjectKeyManager issueAndProjectKeyManager;
    private final IssueLinker issueLinker;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final PermissionManager permissionManager;
    private final ProjectManager projectManager;
    private final RepositoryService repositoryService;
    private final TemplateRenderer templateRenderer;
    private final UserProfileAccessor userProfileAccessor;

    public DvcsStreamsActivityProvider(@ComponentImport ApplicationProperties applicationProperties, @ComponentImport I18nResolver i18nResolver, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport PermissionManager permissionManager, @ComponentImport ProjectManager projectManager, @ComponentImport TemplateRenderer templateRenderer, @ComponentImport UserProfileAccessor userProfileAccessor, ChangesetService changesetService, IssueAndProjectKeyManager issueAndProjectKeyManager, IssueLinker issueLinker, RepositoryService repositoryService) {
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties);
        this.changesetService = (ChangesetService)Preconditions.checkNotNull((Object)changesetService);
        this.i18nResolver = (I18nResolver)Preconditions.checkNotNull((Object)i18nResolver);
        this.issueAndProjectKeyManager = (IssueAndProjectKeyManager)Preconditions.checkNotNull((Object)issueAndProjectKeyManager);
        this.issueLinker = (IssueLinker)Preconditions.checkNotNull((Object)issueLinker);
        this.jiraAuthenticationContext = (JiraAuthenticationContext)Preconditions.checkNotNull((Object)jiraAuthenticationContext);
        this.permissionManager = (PermissionManager)Preconditions.checkNotNull((Object)permissionManager);
        this.projectManager = (ProjectManager)Preconditions.checkNotNull((Object)projectManager);
        this.repositoryService = (RepositoryService)Preconditions.checkNotNull((Object)repositoryService);
        this.templateRenderer = (TemplateRenderer)Preconditions.checkNotNull((Object)templateRenderer);
        this.userProfileAccessor = (UserProfileAccessor)Preconditions.checkNotNull((Object)userProfileAccessor);
    }

    private Iterable<StreamsEntry> transformEntries(ActivityRequest activityRequest, Iterable<Changeset> changesetEntries, AtomicBoolean cancelled) throws StreamsException {
        ArrayList<StreamsEntry> entries = new ArrayList<StreamsEntry>();
        HashSet<String> alreadyAddedChangesetRawNodes = new HashSet<String>(entries.size(), 1.0f);
        for (Changeset changeset : changesetEntries) {
            StreamsEntry streamsEntry;
            if (cancelled.get()) {
                throw new CancelledException();
            }
            if (alreadyAddedChangesetRawNodes.contains(this.getNode(changeset)) || (streamsEntry = this.toStreamsEntry(activityRequest, changeset)) == null) continue;
            entries.add(streamsEntry);
            alreadyAddedChangesetRawNodes.add(this.getNode(changeset));
        }
        return entries;
    }

    private String getNode(Changeset changeset) {
        String node = changeset.getRawNode();
        if (StringUtils.isEmpty((CharSequence)node)) {
            node = changeset.getNode();
        }
        return node;
    }

    private String renderTemplate(String template, Map<String, Object> model) {
        StringWriter sw = new StringWriter();
        try {
            this.templateRenderer.render(template, model, (Writer)sw);
        }
        catch (IOException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        return sw.toString();
    }

    private StreamsEntry toStreamsEntry(ActivityRequest activityRequest, final Changeset changeset) {
        final Repository repository = this.repositoryService.get(changeset.getRepositoryId());
        if (repository == null) {
            return null;
        }
        StreamsEntry.ActivityObject activityObject = new StreamsEntry.ActivityObject(StreamsEntry.ActivityObject.params().id(changeset.getNode()).alternateLinkUri(URI.create("")).activityObjectType(ActivityObjectTypes.newTypeFactory((String)"http://activitystrea.ms/schema/1.0/").newType(STATUS)));
        final String commitUrl = this.changesetService.getCommitUrl(repository, changeset);
        final DvcsUser user = this.repositoryService.getUser(repository, changeset.getAuthor(), changeset.getRawAuthor());
        StreamsEntry.Renderer renderer = new StreamsEntry.Renderer(){

            public Html renderTitleAsHtml(StreamsEntry entry) {
                HashMap<String, Object> model = new HashMap<String, Object>();
                model.put("changeset", changeset);
                model.put("user_name", user.getFullName());
                model.put("login", user.getUsername());
                model.put("user_url", user.getUrl());
                model.put("commit_url", commitUrl);
                return new Html(DvcsStreamsActivityProvider.this.renderTemplate(DvcsStreamsActivityProvider.TITLE_TEMPLATE_NAME, model));
            }

            public Option<Html> renderSummaryAsHtml(StreamsEntry entry) {
                return Option.none();
            }

            public Option<Html> renderContentAsHtml(StreamsEntry entry) {
                HashMap<String, Object> model = new HashMap<String, Object>();
                Map fileCommitUrls = DvcsStreamsActivityProvider.this.changesetService.getFileCommitUrls(repository, changeset);
                model.put("file_commit_urls", fileCommitUrls);
                model.put("issue_linker", DvcsStreamsActivityProvider.this.issueLinker);
                model.put("changeset", changeset);
                model.put("commit_url", commitUrl);
                model.put("max_visible_files", 5);
                return Option.some((Object)new Html(DvcsStreamsActivityProvider.this.renderTemplate(DvcsStreamsActivityProvider.SUMMARY_TEMPLATE_NAME, model)));
            }
        };
        UserProfile userProfile = this.getUserProfile(activityRequest, user);
        return new StreamsEntry(StreamsEntry.params().id(URI.create("")).postedDate(new DateTime((Object)changeset.getDate())).authors((NonEmptyIterable)ImmutableNonEmptyList.of((Object)userProfile)).addActivityObject(activityObject).verb(ActivityVerbs.update()).alternateLinkUri(URI.create("")).renderer(renderer).applicationType(this.applicationProperties.getDisplayName()), this.i18nResolver);
    }

    private UserProfile getUserProfile(ActivityRequest activityRequest, DvcsUser user) {
        if (user != null && user.getAvatar() != null && user.getAvatar().startsWith("https")) {
            try {
                URI uri = new URI(user.getAvatar());
                return new UserProfile.Builder("").profilePictureUri(Option.option((Object)uri)).build();
            }
            catch (URISyntaxException e) {
                return this.userProfileAccessor.getAnonymousUserProfile(activityRequest.getContextUri());
            }
        }
        return this.userProfileAccessor.getAnonymousUserProfile(activityRequest.getContextUri());
    }

    public CancellableTask<StreamsFeed> getActivityFeed(final ActivityRequest activityRequest) throws StreamsException {
        final GlobalFilter gf = new GlobalFilter();
        gf.setInProjects(this.includeHistoricalProjectKeys(this.getInProjectsByPermission(Filters.getIsValues((Iterable)activityRequest.getStandardFilters().get((Object)"key")))));
        gf.setNotInProjects(this.includeHistoricalProjectKeys(Filters.getNotValues((Iterable)activityRequest.getStandardFilters().get((Object)"key"))));
        gf.setInUsers((Iterable)Filters.getIsValues((Iterable)activityRequest.getStandardFilters().get((Object)StandardStreamsFilterOption.USER.getKey())));
        gf.setNotInUsers((Iterable)Filters.getNotValues((Iterable)activityRequest.getStandardFilters().get((Object)StandardStreamsFilterOption.USER.getKey())));
        gf.setInIssues(this.includeHistoricalIssueKeys(Filters.getIsValues((Iterable)activityRequest.getStandardFilters().get((Object)StandardStreamsFilterOption.ISSUE_KEY.getKey()))));
        gf.setNotInIssues(this.includeHistoricalIssueKeys(Filters.getNotValues((Iterable)activityRequest.getStandardFilters().get((Object)StandardStreamsFilterOption.ISSUE_KEY.getKey()))));
        log.debug("GlobalFilter: " + gf);
        return new CancellableTask<StreamsFeed>(){
            private final AtomicBoolean cancelled = new AtomicBoolean(false);

            public StreamsFeed call() throws Exception {
                Iterable streamEntries = new ArrayList();
                if (gf.getInProjects() != null && gf.getInProjects().iterator().hasNext()) {
                    Iterable latestChangesets = DvcsStreamsActivityProvider.this.changesetService.getLatestChangesets(activityRequest.getMaxResults(), gf);
                    if (this.cancelled.get()) {
                        throw new CancelledException();
                    }
                    log.debug("Found changeset entries: {}", (Object)latestChangesets);
                    List changesetDetails = DvcsStreamsActivityProvider.this.changesetService.getChangesetsWithFileDetails((List)Lists.newArrayList((Iterable)latestChangesets));
                    log.debug("Loaded details for changeset entries: {}", (Object)changesetDetails);
                    streamEntries = DvcsStreamsActivityProvider.this.transformEntries(activityRequest, changesetDetails, this.cancelled);
                }
                return new StreamsFeed(DvcsStreamsActivityProvider.this.i18nResolver.getText(DvcsStreamsActivityProvider.STREAMS_EXTERNAL_FEED_TITLE_KEY), streamEntries, Option.none());
            }

            public CancellableTask.Result cancel() {
                this.cancelled.set(true);
                return CancellableTask.Result.CANCELLED;
            }
        };
    }

    private Set<String> includeHistoricalProjectKeys(Iterable<String> projectKeys) {
        HashSet<String> result = new HashSet<String>();
        for (String projectKey : projectKeys) {
            result.addAll(this.issueAndProjectKeyManager.getAllProjectKeys(projectKey));
        }
        return result;
    }

    private Set<String> includeHistoricalIssueKeys(Iterable<String> issueKeys) {
        HashSet<String> result = new HashSet<String>();
        for (String issueKey : issueKeys) {
            result.addAll(this.issueAndProjectKeyManager.getAllIssueKeys(issueKey));
        }
        return result;
    }

    private List<String> getInProjectsByPermission(Collection<String> inProjectsList) {
        Collection projectsToCheckPermission = CollectionUtils.isEmpty(inProjectsList) ? this.projectManager.getProjectObjects() : (Collection)inProjectsList.stream().map(arg_0 -> ((ProjectManager)this.projectManager).getProjectObjByKey(arg_0)).collect(Collectors.toList());
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        return projectsToCheckPermission.stream().filter(Objects::nonNull).filter(project -> this.permissionManager.hasPermission(ProjectPermissions.VIEW_DEV_TOOLS, project, user)).map(Project::getKey).collect(Collectors.toList());
    }
}

