/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.soy.impl.functions;

import com.atlassian.jira.help.HelpUrl;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.soy.renderer.JsExpression;
import com.atlassian.soy.renderer.SoyClientFunction;
import com.atlassian.soy.renderer.SoyServerFunction;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelpUrlSoyFunction
implements SoyServerFunction,
SoyClientFunction {
    private static final Logger LOG = LoggerFactory.getLogger(HelpUrlSoyFunction.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Pattern SOY_STRING_PATTERN = Pattern.compile("^'(.*)'$");
    private static final Set<Integer> ARGS_SIZES = ImmutableSet.of((Object)1);
    private final HelpUrls helpUrls;

    @Inject
    public HelpUrlSoyFunction(@ComponentImport HelpUrls helpUrls) {
        this.helpUrls = (HelpUrls)Preconditions.checkNotNull((Object)helpUrls);
    }

    public String getName() {
        return "dvcs_getHelpUrl";
    }

    public Set<Integer> validArgSizes() {
        return ARGS_SIZES;
    }

    public JsExpression generate(JsExpression ... args) {
        if (args.length == 0) {
            throw new IllegalArgumentException("Help url requires at least one argument and it should be a string as the key to the help urls mapping.");
        }
        Matcher match = SOY_STRING_PATTERN.matcher(args[0].getText());
        if (!match.matches()) {
            throw new IllegalArgumentException("Help url requires the argument to be a string as the key to the help urls mapping.");
        }
        String helpUrlKey = match.group(1);
        HelpUrl helpUrl = this.helpUrls.getUrl(helpUrlKey);
        String jsonExpr = null;
        ImmutableMap helpUrlMap = ImmutableMap.of((Object)"alt", (Object)StringUtils.defaultString((String)helpUrl.getAlt()), (Object)"title", (Object)StringUtils.defaultString((String)helpUrl.getTitle()), (Object)"url", (Object)StringUtils.defaultString((String)helpUrl.getUrl()));
        try {
            jsonExpr = OBJECT_MAPPER.writeValueAsString((Object)helpUrlMap);
        }
        catch (IOException e) {
            LOG.error("Error serialising to JSON: " + helpUrlMap, (Throwable)e);
        }
        return new JsExpression("(" + jsonExpr + ")");
    }

    public Object apply(Object ... args) {
        if (args.length == 0) {
            throw new IllegalArgumentException("Help url requires at least one argument and it should be a string as the key to the help urls mapping.");
        }
        if (!(args[0] instanceof String)) {
            throw new IllegalArgumentException("Help url requires the argument to be a string as the key to the help urls mapping.");
        }
        return this.helpUrls.getUrl((String)args[0]);
    }
}

