/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.service.remote;

import com.atlassian.jira.plugins.dvcs.model.AccountInfo;
import com.atlassian.jira.plugins.dvcs.service.remote.CachingDvcsCommunicator;
import com.atlassian.jira.plugins.dvcs.service.remote.DvcsCommunicator;
import com.atlassian.jira.plugins.dvcs.service.remote.DvcsCommunicatorProvider;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class DvcsCommunicatorProviderImpl
implements DvcsCommunicatorProvider {
    @Resource
    private CachingDvcsCommunicator[] dvcsCommunicators;

    public DvcsCommunicator getCommunicator(String dvcsType) {
        for (CachingDvcsCommunicator dvcsCommunicator : this.dvcsCommunicators) {
            if (!dvcsCommunicator.getDvcsType().equals(dvcsType)) continue;
            return dvcsCommunicator;
        }
        throw new IllegalArgumentException("Unsupported DVCS Type: " + dvcsType);
    }

    public AccountInfo getAccountInfo(String hostUrl, String accountName) {
        return this.getAccountInfo(hostUrl, accountName, null);
    }

    public AccountInfo getAccountInfo(String hostUrl, String accountName, String dvcsType) {
        if (dvcsType != null) {
            for (CachingDvcsCommunicator dvcsCommunicator : this.dvcsCommunicators) {
                if (!dvcsType.equalsIgnoreCase(dvcsCommunicator.getDvcsType())) continue;
                return dvcsCommunicator.getAccountInfo(hostUrl, accountName);
            }
        } else {
            for (CachingDvcsCommunicator dvcsCommunicator : this.dvcsCommunicators) {
                AccountInfo accountInfo = dvcsCommunicator.getAccountInfo(hostUrl, accountName);
                if (accountInfo == null) continue;
                return accountInfo;
            }
        }
        return null;
    }
}

