/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.service.remote;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheException;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.jira.plugins.dvcs.exception.SourceControlException;
import com.atlassian.jira.plugins.dvcs.model.AccountInfo;
import com.atlassian.jira.plugins.dvcs.model.Branch;
import com.atlassian.jira.plugins.dvcs.model.Changeset;
import com.atlassian.jira.plugins.dvcs.model.ChangesetFileDetailsEnvelope;
import com.atlassian.jira.plugins.dvcs.model.DvcsUser;
import com.atlassian.jira.plugins.dvcs.model.Group;
import com.atlassian.jira.plugins.dvcs.model.Organization;
import com.atlassian.jira.plugins.dvcs.model.Repository;
import com.atlassian.jira.plugins.dvcs.service.remote.CachingDvcsCommunicator;
import com.atlassian.jira.plugins.dvcs.service.remote.DvcsCommunicator;
import com.atlassian.jira.plugins.dvcs.sync.SynchronizationFlag;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class CachingCommunicator
implements CachingDvcsCommunicator {
    private static final CacheSettings CACHE_SETTINGS = new CacheSettingsBuilder().expireAfterWrite(30L, TimeUnit.MINUTES).build();
    private final Cache<UserKey, DvcsUser> usersCache;
    private final Cache<OrganisationKey, List<Group>> groupsCache;
    private DvcsCommunicator delegate;

    public CachingCommunicator(@ComponentImport CacheManager cacheManager) {
        this.usersCache = cacheManager.getCache(this.getClass().getName() + ".usersCache", (CacheLoader)new UserLoader(), CACHE_SETTINGS);
        this.groupsCache = cacheManager.getCache(this.getClass().getName() + ".groupsCache", (CacheLoader)new GroupLoader(), CACHE_SETTINGS);
    }

    public DvcsUser getUser(Repository repository, String username) {
        try {
            return (DvcsUser)this.usersCache.get((Object)new UserKey(repository, username));
        }
        catch (CacheException e) {
            throw this.unrollException(e);
        }
    }

    private SourceControlException unrollException(Throwable e) {
        return e.getCause() instanceof SourceControlException ? (SourceControlException)e.getCause() : new SourceControlException(e.getCause());
    }

    public List<Group> getGroupsForOrganization(Organization organization) {
        try {
            return (List)this.groupsCache.get((Object)new OrganisationKey(organization));
        }
        catch (CacheException e) {
            throw this.unrollException(e);
        }
    }

    public boolean supportsInvitation(Organization organization) {
        return this.delegate.supportsInvitation(organization);
    }

    public void inviteUser(Organization organization, Collection<String> groupSlugs, String userEmail) {
        this.delegate.inviteUser(organization, groupSlugs, userEmail);
    }

    public String getBranchUrl(Repository repository, Branch branch) {
        return this.delegate.getBranchUrl(repository, branch);
    }

    public String getCreatePullRequestUrl(Repository repository, String sourceSlug, String sourceBranch, String destinationSlug, String destinationBranch, String eventSource) {
        return this.delegate.getCreatePullRequestUrl(repository, sourceSlug, sourceBranch, destinationSlug, destinationBranch, eventSource);
    }

    public String getCreatePullRequestUrl(@Nonnull Repository repository, @Nonnull String sourceBranch) {
        return this.delegate.getCreatePullRequestUrl(repository, sourceBranch);
    }

    public void startSynchronisation(Repository repo, Collection<SynchronizationFlag> flags, int auditId) {
        this.delegate.startSynchronisation(repo, flags, auditId);
    }

    public boolean isSyncDisabled(Repository repo, EnumSet<SynchronizationFlag> flags) {
        return this.delegate.isSyncDisabled(repo, flags);
    }

    public void removeLinkersForRepo(Repository repository) {
        this.delegate.removeLinkersForRepo(repository);
    }

    public String getDvcsType() {
        return this.delegate.getDvcsType();
    }

    public AccountInfo getAccountInfo(String hostUrl, String accountName) {
        return this.delegate.getAccountInfo(hostUrl, accountName);
    }

    public List<Repository> getRepositories(Organization organization, List<Repository> storedRepositories) {
        return this.delegate.getRepositories(organization, storedRepositories);
    }

    public List<Repository> getRepositoriesWithUpdates(Organization organization) {
        return this.delegate.getRepositoriesWithUpdates(organization);
    }

    public List<Branch> getBranches(Repository repository) {
        return this.delegate.getBranches(repository);
    }

    public Changeset getChangeset(Repository repository, String node) {
        return this.delegate.getChangeset(repository, node);
    }

    public ChangesetFileDetailsEnvelope getFileDetails(Repository repository, Changeset changeset) {
        return this.delegate.getFileDetails(repository, changeset);
    }

    public void ensureHookPresent(Repository repository, String postCommitUrl) {
        this.delegate.ensureHookPresent(repository, postCommitUrl);
    }

    public void removePostcommitHook(Repository repository, String postCommitUrl) {
        this.delegate.removePostcommitHook(repository, postCommitUrl);
    }

    public String getCommitUrl(Repository repository, Changeset changeset) {
        return this.delegate.getCommitUrl(repository, changeset);
    }

    public String getFileCommitUrl(Repository repository, Changeset changeset, String file, int index) {
        return this.delegate.getFileCommitUrl(repository, changeset, file, index);
    }

    public void linkRepository(Repository repository, Set<String> withProjectkeys) {
        this.delegate.linkRepository(repository, withProjectkeys);
    }

    public void setConnectLinkerValuesForOrganization(Organization organization, Iterable<String> projectKeys) {
        this.delegate.setConnectLinkerValuesForOrganization(organization, projectKeys);
    }

    public DvcsUser getTokenOwner(Organization organization) {
        return this.delegate.getTokenOwner(organization);
    }

    public DvcsCommunicator getDelegate() {
        return this.delegate;
    }

    public void setDelegate(DvcsCommunicator delegate) {
        this.delegate = delegate;
    }

    private class GroupLoader
    implements CacheLoader<OrganisationKey, List<Group>> {
        private GroupLoader() {
        }

        @Nonnull
        public List<Group> load(@Nonnull OrganisationKey key) {
            return CachingCommunicator.this.delegate.getGroupsForOrganization(key.organization);
        }
    }

    private class UserLoader
    implements CacheLoader<UserKey, DvcsUser> {
        private UserLoader() {
        }

        @Nonnull
        public DvcsUser load(@Nonnull UserKey key) {
            return CachingCommunicator.this.delegate.getUser(key.repository, key.username);
        }
    }

    @VisibleForTesting
    static class OrganisationKey
    implements Serializable {
        private final Organization organization;

        public OrganisationKey(Organization organization) {
            this.organization = organization;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OrganisationKey that = (OrganisationKey)obj;
            return new EqualsBuilder().append((Object)this.organization.getHostUrl(), (Object)that.organization.getHostUrl()).append((Object)this.organization.getName(), (Object)that.organization.getName()).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.organization.getHostUrl()).append((Object)this.organization.getName()).toHashCode();
        }
    }

    @VisibleForTesting
    static class UserKey
    implements Serializable {
        private final Repository repository;
        private final String username;

        public UserKey(Repository repository, String username) {
            this.repository = repository;
            this.username = username;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UserKey)) {
                return false;
            }
            UserKey otherKey = (UserKey)other;
            return new EqualsBuilder().append((Object)this.repository.getOrgHostUrl(), (Object)otherKey.repository.getOrgHostUrl()).append((Object)this.username, (Object)otherKey.username).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.repository.getOrgHostUrl()).append((Object)this.username).toHashCode();
        }
    }
}

