/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.service.api;

import com.atlassian.jira.plugins.dvcs.model.PullRequest;
import com.atlassian.jira.plugins.dvcs.model.Repository;
import com.atlassian.jira.plugins.dvcs.service.PullRequestService;
import com.atlassian.jira.plugins.dvcs.service.api.DvcsPullRequestService;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService(value={DvcsPullRequestService.class})
@Component
public class DvcsPullRequestServiceImpl
implements DvcsPullRequestService {
    private PullRequestService pullRequestService;

    @Autowired
    public DvcsPullRequestServiceImpl(PullRequestService pullRequestService) {
        this.pullRequestService = pullRequestService;
    }

    @Override
    @Nonnull
    public Set<String> getIssueKeys(int repositoryId, int pullRequestId) {
        return this.pullRequestService.getIssueKeys(repositoryId, pullRequestId);
    }

    @Override
    @Nonnull
    public List<PullRequest> getPullRequests(Iterable<String> issueKeys) {
        return ImmutableList.copyOf((Collection)this.pullRequestService.getByIssueKeys(issueKeys));
    }

    @Override
    public List<PullRequest> getPullRequests(Iterable<String> issueKeys, String dvcsType) {
        return ImmutableList.copyOf((Collection)this.pullRequestService.getByIssueKeys(issueKeys, dvcsType));
    }

    @Override
    public String getCreatePullRequestUrl(Repository repository, String sourceSlug, String sourceBranch, String destinationSlug, String destinationBranch, String eventSource) {
        return this.pullRequestService.getCreatePullRequestUrl(repository, sourceSlug, sourceBranch, destinationSlug, destinationBranch, eventSource);
    }

    @Override
    public String getCreatePullRequestUrl(@Nonnull Repository repository, @Nonnull String sourceBranch) {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)sourceBranch);
        return this.pullRequestService.getCreatePullRequestUrl(repository, sourceBranch);
    }
}

