/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.service.api;

import com.atlassian.jira.plugins.dvcs.model.Organization;
import com.atlassian.jira.plugins.dvcs.service.OrganizationService;
import com.atlassian.jira.plugins.dvcs.service.api.DvcsLinkService;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService(value={DvcsLinkService.class})
@Component
public class DvcsLinkServiceImpl
implements DvcsLinkService {
    private final OrganizationService organizationService;

    @Autowired
    public DvcsLinkServiceImpl(OrganizationService organizationService) {
        this.organizationService = organizationService;
    }

    @Override
    public Organization getDvcsLink(boolean loadRepositories, int organizationId) {
        return this.organizationService.get(organizationId, loadRepositories);
    }

    @Override
    public List<Organization> getDvcsLinks(boolean loadRepositories) {
        return Collections.unmodifiableList(this.organizationService.getAll(loadRepositories));
    }

    @Override
    public List<Organization> getDvcsLinks(boolean loadRepositories, @Nonnull String applicationType) {
        if (StringUtils.isEmpty((CharSequence)applicationType)) {
            throw new IllegalArgumentException("'applicationType' is null or empty");
        }
        return Collections.unmodifiableList(this.organizationService.getAll(loadRepositories, applicationType));
    }
}

