/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.service.api;

import com.atlassian.jira.plugins.dvcs.model.Changeset;
import com.atlassian.jira.plugins.dvcs.model.ChangesetFile;
import com.atlassian.jira.plugins.dvcs.model.GlobalFilter;
import com.atlassian.jira.plugins.dvcs.model.Repository;
import com.atlassian.jira.plugins.dvcs.service.ChangesetService;
import com.atlassian.jira.plugins.dvcs.service.api.DvcsChangesetService;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService(value={DvcsChangesetService.class})
@Component
public class DvcsChangesetServiceImpl
implements DvcsChangesetService {
    private ChangesetService changesetService;

    @Autowired
    public DvcsChangesetServiceImpl(ChangesetService changesetService) {
        this.changesetService = changesetService;
    }

    @Override
    public List<Changeset> getChangesets(Repository repository) {
        return ImmutableList.copyOf((Collection)this.changesetService.getChangesets(repository));
    }

    @Override
    public List<Changeset> getChangesets(Iterable<String> issueKeys) {
        return ImmutableList.copyOf((Collection)this.changesetService.getByIssueKey(issueKeys, false));
    }

    @Override
    public List<Changeset> getChangesets(Iterable<String> issueKeys, String dvcsType) {
        return ImmutableList.copyOf((Collection)this.changesetService.getByIssueKey(issueKeys, dvcsType, false));
    }

    @Override
    public List<Changeset> getChangesets(Iterable<String> issueKeys, String dvcsType, boolean newestFirst) {
        return ImmutableList.copyOf((Collection)this.changesetService.getByIssueKey(issueKeys, dvcsType, newestFirst));
    }

    @Override
    public List<Changeset> getChangesets(int maxResults, GlobalFilter globalFilter) {
        return ImmutableList.copyOf((Iterable)this.changesetService.getLatestChangesets(maxResults, globalFilter));
    }

    @Override
    public String getChangesetURL(Repository repository, Changeset changeset) {
        return this.changesetService.getCommitUrl(repository, changeset);
    }

    @Override
    public Map<ChangesetFile, String> getFileChangesets(Repository repository, Changeset changeset) {
        return this.changesetService.getFileCommitUrls(repository, changeset);
    }

    @Override
    public List<Changeset> getChangesetsWithFileDetails(List<Changeset> changesets) {
        return this.changesetService.getChangesetsWithFileDetails(changesets);
    }
}

