/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.service;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.plugins.dvcs.analytics.AnalyticsService;
import com.atlassian.jira.plugins.dvcs.dao.OrganizationDao;
import com.atlassian.jira.plugins.dvcs.dao.RepositoryDao;
import com.atlassian.jira.plugins.dvcs.exception.SourceControlException;
import com.atlassian.jira.plugins.dvcs.model.Organization;
import com.atlassian.jira.plugins.dvcs.model.Progress;
import com.atlassian.jira.plugins.dvcs.model.Repository;
import com.atlassian.jira.plugins.dvcs.model.credential.Credential;
import com.atlassian.jira.plugins.dvcs.model.credential.PrincipalIDCredential;
import com.atlassian.jira.plugins.dvcs.service.ChangesetService;
import com.atlassian.jira.plugins.dvcs.service.InvalidOrganizationManager;
import com.atlassian.jira.plugins.dvcs.service.RepositoryService;
import com.atlassian.jira.plugins.dvcs.service.RepositorySyncService;
import com.atlassian.jira.plugins.dvcs.service.remote.DvcsCommunicator;
import com.atlassian.jira.plugins.dvcs.service.remote.DvcsCommunicatorProvider;
import com.atlassian.jira.plugins.dvcs.sync.SynchronizationFlag;
import com.atlassian.jira.plugins.dvcs.sync.Synchronizer;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RepositorySyncServiceImpl
implements RepositorySyncService {
    private static final Logger log = LoggerFactory.getLogger(RepositorySyncServiceImpl.class);
    @VisibleForTesting
    static final String SYNC_REPOSITORY_LIST_LOCK = RepositoryService.class.getName() + ".syncRepositoryList";
    private final ClusterLockService clusterLockService;
    private final InvalidOrganizationManager invalidOrganizationsManager;
    private final DvcsCommunicatorProvider communicatorProvider;
    private final RepositoryDao repositoryDao;
    private final RepositoryService repositoryService;
    private final AnalyticsService analyticsService;
    private final ApplicationProperties applicationProperties;
    private final Synchronizer synchronizer;
    private final ChangesetService changesetService;
    private final OrganizationDao organizationDao;

    @Autowired
    public RepositorySyncServiceImpl(@ComponentImport ClusterLockService clusterLockService, InvalidOrganizationManager invalidOrganizationsManager, DvcsCommunicatorProvider communicatorProvider, RepositoryDao repositoryDao, RepositoryService repositoryService, AnalyticsService analyticsService, @ComponentImport ApplicationProperties applicationProperties, Synchronizer synchronizer, ChangesetService changesetService, OrganizationDao organizationDao) {
        this.clusterLockService = clusterLockService;
        this.invalidOrganizationsManager = invalidOrganizationsManager;
        this.communicatorProvider = communicatorProvider;
        this.repositoryDao = repositoryDao;
        this.repositoryService = repositoryService;
        this.analyticsService = analyticsService;
        this.applicationProperties = applicationProperties;
        this.synchronizer = synchronizer;
        this.changesetService = changesetService;
        this.organizationDao = organizationDao;
    }

    public Set<String> reconcileRepoList(Organization organization) {
        List storedRepositories = this.repositoryDao.getAllByOrganization(organization.getId(), true);
        List<Repository> remoteRepositories = this.getRemoteRepositories(organization, storedRepositories, true);
        Set<String> deletedSlugs = this.removeDeletedRepositories(storedRepositories, remoteRepositories);
        Set<String> newRepoSlugs = this.reconcileRemoteAndStoredRepositories(organization, storedRepositories, remoteRepositories);
        if (!deletedSlugs.isEmpty() || !newRepoSlugs.isEmpty()) {
            log.warn("Repo list had updates when DB reconciled with bitbucket. {} repos deleted, {} new repos", deletedSlugs, newRepoSlugs);
        }
        return newRepoSlugs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncReposWithUpdates(Organization organization, Set<String> newSlugs) {
        if (!this.isOrganizationApproved(organization)) {
            this.logRepoListSyncAttemptedOnNonApprovedOrganization(organization.getId());
            return;
        }
        ClusterLock lock = this.clusterLockService.getLockForName(SYNC_REPOSITORY_LIST_LOCK);
        lock.lock();
        try {
            log.debug("Synchronizing list of repositories");
            this.invalidOrganizationsManager.setOrganizationValid(organization.getId(), true);
            List storedRepositories = this.repositoryDao.getAllByOrganization(organization.getId(), true);
            List<Repository> remoteRepositoriesWithUpdates = this.getRemoteRepositories(organization, storedRepositories, false);
            Set updateSlugs = remoteRepositoriesWithUpdates.stream().map(Repository::getSlug).collect(Collectors.toSet());
            List<Repository> reposToUpdate = this.repositoryService.getAllByOrganization(organization.getId()).stream().filter(r -> updateSlugs.contains(r.getSlug())).collect(Collectors.toList());
            this.syncRepos(reposToUpdate, SynchronizationFlag.getDefaultSoftSync(), newSlugs);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncReposWithUpdates(Organization organization) {
        if (!this.isOrganizationApproved(organization)) {
            this.logRepoListSyncAttemptedOnNonApprovedOrganization(organization.getId());
            return;
        }
        ClusterLock lock = this.clusterLockService.getLockForName(SYNC_REPOSITORY_LIST_LOCK);
        lock.lock();
        try {
            log.debug("Synchronizing list of repositories");
            this.invalidOrganizationsManager.setOrganizationValid(organization.getId(), true);
            List storedRepositories = this.repositoryDao.getAllByOrganization(organization.getId(), true);
            List<Repository> remoteRepositoriesWithUpdates = this.getRemoteRepositories(organization, storedRepositories, false);
            Set<String> newRepoSlugs = this.reconcileRemoteAndStoredRepositories(organization, storedRepositories, remoteRepositoriesWithUpdates);
            Set updateSlugs = (Set)remoteRepositoriesWithUpdates.stream().map(Repository::getSlug).collect(CollectorsUtil.toImmutableSet());
            List reposToUpdate = (List)this.repositoryService.getAllByOrganization(organization.getId()).stream().filter(r -> updateSlugs.contains(r.getSlug())).collect(CollectorsUtil.toImmutableList());
            this.syncRepos(reposToUpdate, SynchronizationFlag.getDefaultSoftSync(), newRepoSlugs);
        }
        finally {
            lock.unlock();
        }
    }

    public void syncRepositoryList(Organization organization) {
        this.syncRepositoryList(organization, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncRepositoryList(Organization organization, boolean soft) {
        if (!this.isOrganizationApproved(organization)) {
            this.logRepoListSyncAttemptedOnNonApprovedOrganization(organization.getId());
            return;
        }
        ClusterLock lock = this.clusterLockService.getLockForName(SYNC_REPOSITORY_LIST_LOCK);
        lock.lock();
        try {
            log.debug("Synchronizing list of repositories");
            this.invalidOrganizationsManager.setOrganizationValid(organization.getId(), true);
            Set<String> newRepoSlugs = this.reconcileRepoList(organization);
            this.syncAllInOrganization(organization, SynchronizationFlag.getDefaultSyncFlags((boolean)soft), newRepoSlugs);
        }
        finally {
            lock.unlock();
        }
    }

    public Optional<Progress> sync(int repositoryId, EnumSet<SynchronizationFlag> flags) {
        Repository repository = this.repositoryService.get(repositoryId);
        if (repository != null && !repository.isDeleted()) {
            if (!this.isOrganizationApproved(repository.getOrganizationId())) {
                this.logSyncAttemptedOnNonApprovedOrganization(repository.getOrganizationId());
                return Optional.empty();
            }
            return Optional.ofNullable(this.doSync(repository, flags));
        }
        log.warn("Sync requested but repository with id {} does not exist anymore.", (Object)repositoryId);
        return Optional.empty();
    }

    private List<Repository> getRemoteRepositories(Organization organization, List<Repository> storedRepos, boolean allRepos) {
        try {
            DvcsCommunicator communicator = this.communicatorProvider.getCommunicator(organization.getDvcsType());
            List remoteRepositories = allRepos ? communicator.getRepositories(organization, storedRepos) : communicator.getRepositoriesWithUpdates(organization);
            return this.logRemoteRepositoriesReceived(remoteRepositories);
        }
        catch (SourceControlException.UnauthorisedException e) {
            this.invalidOrganizationsManager.setOrganizationValid(organization.getId(), false);
            throw e;
        }
    }

    private void removeDuplicateRepositories(Organization organization, List<Repository> storedRepositories) {
        HashSet<String> existingRepositories = new HashSet<String>();
        for (Repository repository : storedRepositories) {
            String slug = repository.getSlug();
            if (existingRepositories.contains(slug)) {
                log.warn("Repository " + organization.getName() + "/" + slug + " is duplicated. Will be deleted.");
                this.repositoryService.remove(repository);
                continue;
            }
            existingRepositories.add(slug);
        }
    }

    private Set<String> reconcileRemoteAndStoredRepositories(Organization organization, List<Repository> storedRepositories, List<Repository> remoteRepositories) {
        this.removeDuplicateRepositories(organization, storedRepositories);
        this.updateExistingRepositories(storedRepositories, remoteRepositories);
        return this.addNewReposReturnNewSlugs(storedRepositories, remoteRepositories, organization);
    }

    private void updateExistingRepositories(List<Repository> storedRepositories, List<Repository> remoteRepositories) {
        Map<String, Repository> remoteRepos = this.makeRepositoryMap(remoteRepositories);
        for (Repository localRepo : storedRepositories) {
            Repository remoteRepo = remoteRepos.get(localRepo.getSlug());
            if (remoteRepo == null) continue;
            localRepo.setName(remoteRepo.getName());
            localRepo.setDeleted(false);
            localRepo.setLogo(remoteRepo.getLogo());
            localRepo.setFork(remoteRepo.isFork());
            localRepo.setForkOf(remoteRepo.getForkOf());
            log.debug("Updating repository [{}]", (Object)localRepo);
            this.repositoryDao.save(localRepo);
        }
    }

    private Set<String> removeDeletedRepositories(List<Repository> storedRepositories, List<Repository> remoteRepositories) {
        HashSet<String> deletedSlugs = new HashSet<String>();
        Map<String, Repository> remoteRepos = this.makeRepositoryMap(remoteRepositories);
        for (Repository localRepo : storedRepositories) {
            Repository remoteRepo = remoteRepos.get(localRepo.getSlug());
            if (remoteRepo != null) continue;
            log.debug("Deleting repository " + localRepo);
            localRepo.setDeleted(true);
            this.repositoryDao.save(localRepo);
            deletedSlugs.add(localRepo.getSlug());
        }
        return deletedSlugs;
    }

    private Set<String> addNewReposReturnNewSlugs(List<Repository> storedRepositories, List<Repository> remoteRepositories, Organization organization) {
        HashSet<String> newRepoSlugs = new HashSet<String>();
        Map<String, Repository> storedRepos = this.makeRepositoryMap(storedRepositories);
        remoteRepositories.stream().filter(repo -> !storedRepos.containsKey(repo.getSlug())).forEach(repository -> {
            Repository updatedRepo = this.addOrganizationInfoToRepo(organization, (Repository)repository);
            Repository savedRepository = this.repositoryDao.save(updatedRepo);
            newRepoSlugs.add(savedRepository.getSlug());
            log.debug("Adding new repository with name " + savedRepository.getName());
        });
        this.analyticsService.publishRepositoryListUpdated(organization, newRepoSlugs.size(), remoteRepositories.size());
        return newRepoSlugs;
    }

    private Repository addOrganizationInfoToRepo(Organization organization, Repository repository) {
        repository.setOrganizationId(organization.getId());
        repository.setDvcsType(organization.getDvcsType());
        repository.setLinked(organization.isAutolinkNewRepos());
        repository.setCredential(organization.getCredential());
        repository.setSmartcommitsEnabled(organization.isSmartcommitsOnNewRepos());
        repository.setOrgHostUrl(organization.getHostUrl());
        repository.setOrgName(organization.getName());
        repository.setUpdateLinkAuthorised(true);
        return repository;
    }

    private void syncAllInOrganization(Organization organization, EnumSet<SynchronizationFlag> flags, Set<String> newRepoSlugs) {
        if (!this.isOrganizationApproved(organization)) {
            this.logSyncAttemptedOnNonApprovedOrganization(organization.getId());
            return;
        }
        List repositories = this.repositoryService.getAllByOrganization(organization.getId());
        this.syncRepos(repositories, flags, newRepoSlugs);
    }

    private void syncRepos(List<Repository> repositories, EnumSet<SynchronizationFlag> flags, Set<String> newRepoSlugs) {
        for (Repository repository : repositories) {
            if (!newRepoSlugs.contains(repository.getSlug())) {
                try {
                    this.doSync(repository, flags);
                }
                catch (SourceControlException.SynchronizationDisabled e) {
                    log.debug("SynchronizationDisabled for repo " + repository, (Throwable)e);
                }
                continue;
            }
            this.syncNewRepo(repository, flags);
        }
    }

    private void syncNewRepo(Repository repository, EnumSet<SynchronizationFlag> flags) {
        EnumSet<SynchronizationFlag> newFlags = EnumSet.copyOf(flags);
        newFlags.remove(SynchronizationFlag.SOFT_SYNC);
        try {
            this.doSync(repository, newFlags);
        }
        catch (SourceControlException.SynchronizationDisabled synchronizationDisabled) {
            // empty catch block
        }
        if (repository.isLinked()) {
            try {
                this.addOrRemovePostcommitHook(repository, this.getPostCommitUrl(repository));
            }
            catch (SourceControlException.PostCommitHookRegistrationException e) {
                this.logFailedWebhook(repository, true, (Exception)((Object)e));
                this.updateAdminPermission(repository, false);
                this.repositoryDao.save(repository);
            }
            catch (Exception e) {
                this.logFailedWebhook(repository, true, e);
                this.repositoryDao.save(repository);
            }
        }
    }

    private void addOrRemovePostcommitHook(@Nonnull Repository repository, String postCommitCallbackUrl) {
        Objects.requireNonNull(repository, "A repository is required");
        if (!this.shouldRemovePostcommitHooks(repository.getCredential(), false)) {
            log.debug("Principal-based repository provided; Not modifying linkers or webhooks.");
            return;
        }
        DvcsCommunicator communicator = this.communicatorProvider.getCommunicator(repository.getDvcsType());
        if (repository.isLinked()) {
            communicator.ensureHookPresent(repository, postCommitCallbackUrl);
            communicator.linkRepository(repository, this.changesetService.findReferencedProjects(repository.getId()));
        } else {
            communicator.removePostcommitHook(repository, postCommitCallbackUrl);
        }
    }

    private Progress doSync(Repository repository, Set<SynchronizationFlag> flags) {
        this.synchronizer.doSync(repository, flags);
        return this.synchronizer.getProgress(repository.getId());
    }

    private String getPostCommitUrl(Repository repo) {
        return this.applicationProperties.getBaseUrl() + DvcsCommunicator.POST_HOOK_SUFFIX + repo.getId() + "/sync";
    }

    private Map<String, Repository> makeRepositoryMap(Collection<Repository> repositories) {
        return repositories.stream().collect(Collectors.toMap(Repository::getSlug, Function.identity()));
    }

    private List<Repository> logRemoteRepositoriesReceived(List<Repository> remoteRepositories) {
        if (log.isDebugEnabled()) {
            try {
                StringBuilder sb = new StringBuilder();
                sb.append("Received following repositories from server: [");
                remoteRepositories.forEach(r -> sb.append(r.getName()).append(", "));
                if (!remoteRepositories.isEmpty()) {
                    sb.delete(sb.length() - 2, sb.length());
                }
                sb.append("]");
                log.debug(sb.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return remoteRepositories;
    }

    private void logFailedWebhook(Repository repository, boolean adding, Exception e) {
        String msg = String.format("Error when %s webhooks for repository %s", adding ? "adding" : "removing", repository.getRepositoryUrl());
        log.info(msg, (Throwable)e);
    }

    private boolean shouldRemovePostcommitHooks(@Nullable Credential credential, boolean ignoreCredentialType) {
        return ignoreCredentialType || credential == null || !((Optional)credential.accept(PrincipalIDCredential.visitor())).isPresent();
    }

    private void logSyncAttemptedOnNonApprovedOrganization(int orgId) {
        log.debug("Attempted to trigger sync on Repository belonging to Organization that has not been approved. orgId: {}", (Object)orgId);
    }

    private void logRepoListSyncAttemptedOnNonApprovedOrganization(int orgId) {
        log.debug("Attempted to trigger Repository List sync on Organization that has not been approved. orgId: {}", (Object)orgId);
    }

    private boolean isOrganizationApproved(int orgId) {
        Organization org = this.organizationDao.get(orgId);
        if (org == null) {
            throw new IllegalArgumentException("Cannot find Organization with id: " + orgId);
        }
        return this.isOrganizationApproved(org);
    }

    private boolean isOrganizationApproved(Organization org) {
        return org.getApprovalState() == Organization.ApprovalState.APPROVED;
    }

    private void updateAdminPermission(Repository repository, boolean webhookInstallError) {
    }
}

