/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.service;

import com.atlassian.fusion.aci.api.model.Installation;
import com.atlassian.jira.plugins.dvcs.activity.RepositoryPullRequestDao;
import com.atlassian.jira.plugins.dvcs.analytics.smartcommits.SmartCommitsAnalyticsService;
import com.atlassian.jira.plugins.dvcs.dao.OrganizationDao;
import com.atlassian.jira.plugins.dvcs.dao.RepositoryDao;
import com.atlassian.jira.plugins.dvcs.dao.SyncAuditLogDao;
import com.atlassian.jira.plugins.dvcs.event.CarefulEventService;
import com.atlassian.jira.plugins.dvcs.exception.SourceControlException;
import com.atlassian.jira.plugins.dvcs.model.DvcsUser;
import com.atlassian.jira.plugins.dvcs.model.Organization;
import com.atlassian.jira.plugins.dvcs.model.Repository;
import com.atlassian.jira.plugins.dvcs.model.RepositoryRegistration;
import com.atlassian.jira.plugins.dvcs.model.credential.Credential;
import com.atlassian.jira.plugins.dvcs.model.credential.PrincipalIDCredential;
import com.atlassian.jira.plugins.dvcs.service.BranchService;
import com.atlassian.jira.plugins.dvcs.service.ChangesetService;
import com.atlassian.jira.plugins.dvcs.service.DvcsConnectorExecutorFactory;
import com.atlassian.jira.plugins.dvcs.service.LinkerService;
import com.atlassian.jira.plugins.dvcs.service.RepositoryService;
import com.atlassian.jira.plugins.dvcs.service.optional.aci.AciInstallationServiceAccessor;
import com.atlassian.jira.plugins.dvcs.service.remote.DvcsCommunicator;
import com.atlassian.jira.plugins.dvcs.service.remote.DvcsCommunicatorProvider;
import com.atlassian.jira.plugins.dvcs.spi.github.service.GitHubEventService;
import com.atlassian.jira.plugins.dvcs.sync.Synchronizer;
import com.atlassian.jira.plugins.dvcs.util.ExceptionLogger;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class RepositoryServiceImpl
implements RepositoryService {
    @VisibleForTesting
    static final String SYNC_REPOSITORY_LIST_LOCK = RepositoryService.class.getName() + ".syncRepositoryList";
    private static final Logger log = ExceptionLogger.getLogger(RepositoryServiceImpl.class);
    @Resource
    private DvcsCommunicatorProvider communicatorProvider;
    @Resource
    private OrganizationDao organizationDao;
    @Resource
    private RepositoryDao repositoryDao;
    @Resource
    private RepositoryPullRequestDao repositoryPullRequestDao;
    @Resource
    private Synchronizer synchronizer;
    @Resource
    private ChangesetService changesetService;
    @Resource
    private BranchService branchService;
    @Resource
    private LinkerService linkerService;
    @Resource
    @ComponentImport
    private ApplicationProperties applicationProperties;
    @Resource
    @ComponentImport
    private PluginSettingsFactory pluginSettingsFactory;
    @Resource
    private GitHubEventService gitHubEventService;
    @Resource
    private SyncAuditLogDao syncAuditDao;
    @Resource
    private CarefulEventService eventService;
    @Resource
    private SmartCommitsAnalyticsService smartCommitsAnalyticsService;
    @Resource
    private AciInstallationServiceAccessor aciInstallationServiceAccessor;
    @Resource
    private DvcsConnectorExecutorFactory executorFactory;
    private ThreadPoolExecutor repositoryDeletionExecutor;
    private ThreadPoolExecutor webhookRemovalExecutor;

    private static void logFailedWebhook(Repository repository, boolean adding, Exception e) {
        String msg = String.format("Error when %s webhooks for repository %s", adding ? "adding" : "removing", repository.getRepositoryUrl());
        log.info(msg, (Throwable)e);
    }

    @PostConstruct
    public void init() throws Exception {
        this.repositoryDeletionExecutor = this.executorFactory.createRepositoryDeletionThreadPoolExecutor();
        this.webhookRemovalExecutor = this.executorFactory.createWebhookCleanupThreadPoolExecutor();
    }

    @PreDestroy
    public void destroy() throws Exception {
        this.executorFactory.shutdownExecutor(this.getClass().getName(), this.repositoryDeletionExecutor);
        this.executorFactory.shutdownExecutor(this.getClass().getName(), this.webhookRemovalExecutor);
    }

    public List<Repository> getAllByOrganization(int organizationId) {
        return this.repositoryDao.getAllByOrganization(organizationId, false);
    }

    public List<Repository> getAllByOrganization(int organizationId, boolean includeDeleted) {
        return this.repositoryDao.getAllByOrganization(organizationId, includeDeleted);
    }

    public Repository getByNameForOrganization(int organizationId, String repositoryName) {
        return this.repositoryDao.getByNameForOrganization(organizationId, repositoryName);
    }

    public Repository get(int repositoryId) {
        return this.repositoryDao.get(repositoryId);
    }

    public Repository save(Repository repository) {
        return this.repositoryDao.save(repository);
    }

    public List<Repository> getAllRepositories() {
        return this.repositoryDao.getAll(false);
    }

    public List<Repository> getAllRepositories(boolean includeDeleted) {
        return this.repositoryDao.getAll(includeDeleted);
    }

    public List<Repository> getAllRepositories(String dvcsType, boolean includeDeleted) {
        return this.repositoryDao.getAllByType(dvcsType, includeDeleted);
    }

    public boolean existsLinkedRepositories() {
        return this.repositoryDao.existsLinkedRepositories(false);
    }

    public RepositoryRegistration enableRepository(int repoId, boolean linked) {
        RepositoryRegistration registration = new RepositoryRegistration();
        Repository repository = this.repositoryDao.get(repoId);
        if (repository != null) {
            registration.setRepository(repository);
            log.debug("Enable repository [{}]", (Object)repository);
            repository.setLinked(linked);
            this.setSmartCommitsToCurrentOrganizationState(repository);
            this.repositoryDao.save(repository);
            this.synchronizer.pauseSynchronization(repository, !linked);
            String postCommitUrl = this.getPostCommitUrl(repository);
            registration.setCallBackUrl(postCommitUrl);
            try {
                this.addOrRemovePostcommitHook(repository, postCommitUrl);
                registration.setCallBackUrlInstalled(linked);
            }
            catch (SourceControlException.PostCommitHookRegistrationException e) {
                RepositoryServiceImpl.logFailedWebhook(repository, linked, (Exception)((Object)e));
                registration.setCallBackUrlInstalled(!linked);
            }
            catch (Exception e) {
                RepositoryServiceImpl.logFailedWebhook(repository, linked, e);
                registration.setCallBackUrlInstalled(!linked);
            }
            try {
                this.linkerService.updateConnectLinkerValuesAsync(repository.getOrganizationId());
            }
            catch (RejectedExecutionException e) {
                log.warn("Failed to schedule task to cleanup old linker values for Organization {}, this will require manual cleanup", (Object)repository.getOrganizationId());
            }
        }
        return registration;
    }

    private void setSmartCommitsToCurrentOrganizationState(Repository repository) {
        repository.setSmartcommitsEnabled(this.organizationDao.get(repository.getOrganizationId()).isSmartcommitsOnNewRepos());
    }

    public void enableRepositorySmartcommits(int repoId, boolean enabled) {
        Repository repository = this.repositoryDao.get(repoId);
        if (repository != null) {
            repository.setSmartcommitsEnabled(enabled);
            this.smartCommitsAnalyticsService.fireSmartCommitPerRepoConfigChange(repoId, enabled);
            log.debug("Enable repository smartcommits [{}]", (Object)repository);
            this.repositoryDao.save(repository);
        }
    }

    private void addOrRemovePostcommitHook(@Nonnull Repository repository, String postCommitCallbackUrl) {
        Objects.requireNonNull(repository, "A repository is required");
        if (!this.shouldRemovePostcommitHooks(repository.getCredential(), false)) {
            log.debug("Principal-based repository provided; Not modifying linkers or webhooks.");
            return;
        }
        DvcsCommunicator communicator = this.communicatorProvider.getCommunicator(repository.getDvcsType());
        if (repository.isLinked()) {
            communicator.ensureHookPresent(repository, postCommitCallbackUrl);
            communicator.linkRepository(repository, this.changesetService.findReferencedProjects(repository.getId()));
        } else {
            communicator.removePostcommitHook(repository, postCommitCallbackUrl);
        }
    }

    public boolean removePostcommitHook(@Nonnull Repository repository, boolean ignoreCredentialType) {
        Objects.requireNonNull(repository, "A repository is required");
        if (!this.shouldRemovePostcommitHooks(repository.getCredential(), ignoreCredentialType)) {
            log.debug("Principal-based repository provided; Not modifying webhooks.");
            return false;
        }
        log.debug("Removing postcommit hooks for repository {} ({})", (Object)repository.getId(), (Object)repository.getRepositoryUrl());
        try {
            DvcsCommunicator communicator = this.communicatorProvider.getCommunicator(repository.getDvcsType());
            communicator.removePostcommitHook(repository, this.getPostCommitUrl(repository));
            return true;
        }
        catch (Exception e) {
            log.info(String.format("Failed to uninstall postcommit hook for repository id %d (%s)", repository.getId(), repository.getRepositoryUrl()), (Throwable)e);
            return false;
        }
    }

    public int removePostcommitHooks(@Nonnull Organization organization, boolean ignoreCredentialType) {
        Objects.requireNonNull(organization, "An organization is required");
        if (!this.shouldRemovePostcommitHooks(organization.getCredential(), ignoreCredentialType)) {
            log.debug("Principal-based organization provided; Not modifying webhooks.");
            return 0;
        }
        int removedCount = 0;
        for (Repository r : this.getAllByOrganization(organization.getId())) {
            if (!this.removePostcommitHook(r, ignoreCredentialType)) continue;
            ++removedCount;
        }
        return removedCount;
    }

    @Nonnull
    public Future<Integer> removePostcommitHooksAsync(@Nonnull Organization organization, boolean ignoreCredentialType) {
        Objects.requireNonNull(organization, "An organization is required");
        if (!this.shouldRemovePostcommitHooks(organization.getCredential(), ignoreCredentialType)) {
            log.debug("Principal-based organization provided; Not modifying webhooks.");
            return CompletableFuture.completedFuture(0);
        }
        return this.webhookRemovalExecutor.submit(() -> this.removePostcommitHooks(organization, ignoreCredentialType));
    }

    private boolean shouldRemovePostcommitHooks(@Nullable Credential credential, boolean ignoreCredentialType) {
        return ignoreCredentialType || credential == null || !((Optional)credential.accept(PrincipalIDCredential.visitor())).isPresent();
    }

    private String getPostCommitUrl(Repository repo) {
        return this.applicationProperties.getBaseUrl(UrlMode.CANONICAL) + DvcsCommunicator.POST_HOOK_SUFFIX + repo.getId() + "/sync";
    }

    public void removeRepositories(List<Repository> repositories) {
        log.debug("Removing {} repositories.", (Object)repositories.size());
        for (Repository repository : repositories) {
            log.debug("Removing repository {}.", (Object)repository.getId());
            if (!repository.isDeleted()) {
                log.trace("Marking repository {} as deleted.", (Object)repository.getId());
                repository.setDeleted(true);
                this.repositoryDao.save(repository);
                this.synchronizer.pauseSynchronization(repository, true);
                log.trace("Repository {} marked as deleted and synchronization stopped.", (Object)repository.getId());
            }
            if (!this.shouldRemoveLinkersAndCommitHooks(repository)) continue;
            log.trace("Removing linkers and webhooks for repository {}.", (Object)repository.getId());
            this.removePostcommitHook(repository, false);
            repository.setLinked(false);
            this.repositoryDao.save(repository);
            log.trace("Linkers and webhooks removed for repository {}.", (Object)repository.getId());
        }
    }

    @VisibleForTesting
    boolean shouldRemoveLinkersAndCommitHooks(@Nonnull Repository repository) {
        Option principalIDCredentialOption = Option.fromOptional((Optional)((Optional)repository.getCredential().accept(PrincipalIDCredential.visitor())));
        Option aciInstallationServiceOption = Option.fromOptional(this.aciInstallationServiceAccessor.get());
        if (principalIDCredentialOption.isDefined() && aciInstallationServiceOption.isDefined()) {
            Option installationOption = principalIDCredentialOption.flatMap(principalIdCredential -> aciInstallationServiceOption.flatMap(aciInstallationService -> {
                try {
                    Installation installation = aciInstallationService.get("jira-bitbucket-connector-plugin", principalIdCredential.getPrincipalId());
                    if (!installation.getLifeCycleStage().equals((Object)Installation.LifeCycleStage.UNINSTALLED)) {
                        return Option.some((Object)installation);
                    }
                    return Option.none();
                }
                catch (Exception e) {
                    log.debug("retrieving ACI installation failed, will return none", (Throwable)e);
                    return Option.none();
                }
            }));
            return repository.isLinked() && installationOption.isDefined();
        }
        return repository.isLinked();
    }

    public void remove(Repository repository, boolean deleteRemoteIntegrations) {
        long startTime = System.currentTimeMillis();
        this.synchronizer.stopSynchronization(repository);
        this.eventService.discardEvents(repository);
        if (deleteRemoteIntegrations) {
            this.removePostcommitHook(repository, false);
        }
        this.changesetService.removeAllInRepository(repository.getId());
        this.synchronizer.removeProgress(repository);
        this.branchService.removeAllBranchHeadsInRepository(repository.getId());
        this.branchService.removeAllBranchesInRepository(repository.getId());
        this.gitHubEventService.removeAll(repository);
        this.repositoryPullRequestDao.removeAll(repository);
        this.syncAuditDao.removeAllForRepo(repository.getId());
        this.repositoryDao.remove(repository.getId());
        log.debug("Repository {} was deleted in {} ms", (Object)repository.getId(), (Object)(System.currentTimeMillis() - startTime));
    }

    public void remove(Repository repository) {
        this.remove(repository, this.shouldRemoveLinkersAndCommitHooks(repository));
    }

    public void removeOrphanRepositories(List<Repository> orphanRepositories) {
        log.debug("Starting to remove {} orphan repositories", (Object)orphanRepositories.size());
        for (Repository orphanRepository : orphanRepositories) {
            this.repositoryDeletionExecutor.execute(() -> {
                try {
                    this.remove(orphanRepository, this.shouldRemoveLinkersAndCommitHooks(orphanRepository));
                    log.debug("Removed orphan repository {}", (Object)orphanRepository);
                }
                catch (Exception e) {
                    log.info("Unexpected exception when removing orphan repository " + orphanRepository, (Throwable)e);
                }
            });
        }
    }

    public void onOffLinkers(boolean enableLinkers) {
        log.debug("Enable linkers : " + BooleanUtils.toStringYesNo((boolean)enableLinkers));
        this.pluginSettingsFactory.createGlobalSettings().remove("dvcs.BITBUCKET_LINKERS_ENABLED");
        for (Repository repository : this.getAllRepositories()) {
            log.debug((enableLinkers ? "Adding" : "Removing") + " linkers for" + repository.getSlug());
            DvcsCommunicator communicator = this.communicatorProvider.getCommunicator(repository.getDvcsType());
            if (enableLinkers && repository.isLinked()) {
                communicator.linkRepository(repository, this.changesetService.findReferencedProjects(repository.getId()));
                continue;
            }
            communicator.linkRepository(repository, new HashSet());
        }
        if (!enableLinkers) {
            this.pluginSettingsFactory.createGlobalSettings().put("dvcs.BITBUCKET_LINKERS_ENABLED", (Object)Boolean.FALSE.toString());
        }
    }

    public DvcsUser getUser(Repository repository, String author, String rawAuthor) {
        log.debug("Get user information for: [ {}, {}]", (Object)author, (Object)rawAuthor);
        DvcsCommunicator communicator = this.communicatorProvider.getCommunicator(repository.getDvcsType());
        DvcsUser user = null;
        if (!Strings.isNullOrEmpty((String)author)) {
            try {
                user = communicator.getUser(repository, author);
            }
            catch (Exception e) {
                log.info(String.format("Could not load user [%s, %s]", author, rawAuthor), (Throwable)e);
                return this.getUnknownUser(repository, author, rawAuthor);
            }
        }
        return user != null ? user : this.getUnknownUser(repository, author, rawAuthor);
    }

    public void setPreviouslyLinkedProjects(Repository repository, Iterable<String> projectKeys) {
        this.repositoryDao.setPreviouslyLinkedProjects(repository.getId(), projectKeys);
    }

    public List<String> getPreviouslyLinkedProjects(Repository repository) {
        return this.repositoryDao.getPreviouslyLinkedProjects(repository.getId());
    }

    public Set<String> getEmails(Repository repository, DvcsUser user) {
        return this.changesetService.findEmails(repository.getId(), user.getUsername());
    }

    public int disableAllRepositories() {
        Collection enabledRepos = this.getAllRepositories().stream().filter(Repository::isLinked).collect(Collectors.toList());
        enabledRepos.forEach(this::disable);
        return enabledRepos.size();
    }

    private void disable(Repository repository) {
        this.enableRepository(repository.getId(), false);
    }

    private DvcsUser.UnknownUser getUnknownUser(Repository repository, String username, String rawUser) {
        return new DvcsUser.UnknownUser(username, rawUser != null ? rawUser : username, repository.getOrgHostUrl());
    }
}

