/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.service;

import com.atlassian.jira.plugins.dvcs.activity.PullRequestParticipantMapping;
import com.atlassian.jira.plugins.dvcs.activity.RepositoryPullRequestDao;
import com.atlassian.jira.plugins.dvcs.activity.RepositoryPullRequestMapping;
import com.atlassian.jira.plugins.dvcs.dao.impl.QueryDslFeatureHelper;
import com.atlassian.jira.plugins.dvcs.dao.impl.querydsl.PullRequestDaoQueryDsl;
import com.atlassian.jira.plugins.dvcs.dao.impl.transform.PullRequestTransformer;
import com.atlassian.jira.plugins.dvcs.event.PullRequestCreatedEvent;
import com.atlassian.jira.plugins.dvcs.event.PullRequestUpdatedEvent;
import com.atlassian.jira.plugins.dvcs.event.ThreadEvents;
import com.atlassian.jira.plugins.dvcs.model.Participant;
import com.atlassian.jira.plugins.dvcs.model.PullRequest;
import com.atlassian.jira.plugins.dvcs.model.PullRequestStatus;
import com.atlassian.jira.plugins.dvcs.model.Repository;
import com.atlassian.jira.plugins.dvcs.service.PullRequestService;
import com.atlassian.jira.plugins.dvcs.service.RepositoryService;
import com.atlassian.jira.plugins.dvcs.service.remote.DvcsCommunicator;
import com.atlassian.jira.plugins.dvcs.service.remote.DvcsCommunicatorProvider;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class PullRequestServiceImpl
implements PullRequestService {
    @Resource
    private RepositoryPullRequestDao pullRequestDao;
    @Resource
    private PullRequestDaoQueryDsl pullRequestDaoQueryDsl;
    private PullRequestTransformer transformer;
    @Resource
    private DvcsCommunicatorProvider dvcsCommunicatorProvider;
    @Resource
    private RepositoryService repositoryService;
    @Resource
    private ThreadEvents threadEvents;
    @Resource
    private QueryDslFeatureHelper queryDslFeatureHelper;

    @PostConstruct
    public void init() {
        this.transformer = new PullRequestTransformer(this.repositoryService);
    }

    public List<PullRequest> getByIssueKeys(Iterable<String> issueKeys) {
        return this.transform(this.pullRequestDao.getByIssueKeys(issueKeys), false);
    }

    public List<PullRequest> getByIssueKeys(Iterable<String> issueKeys, String dvcsType) {
        if (this.queryDslFeatureHelper.isRetrievalUsingQueryDslDisabled()) {
            return this.transform(this.pullRequestDao.getByIssueKeys(issueKeys, dvcsType), false);
        }
        return this.pullRequestDaoQueryDsl.getByIssueKeys(issueKeys, dvcsType);
    }

    public List<PullRequest> getByIssueKeys(Iterable<String> issueKeys, boolean withCommits) {
        return this.transform(this.pullRequestDao.getByIssueKeys(issueKeys), withCommits);
    }

    private List<PullRequest> transform(List<RepositoryPullRequestMapping> pullRequestsMappings, boolean withCommits) {
        return pullRequestsMappings.stream().map(mapping -> this.transformer.transform((RepositoryPullRequestMapping)mapping, withCommits)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public String getCreatePullRequestUrl(Repository repository, String sourceSlug, String sourceBranch, String destinationSlug, String destinationBranch, String eventSource) {
        DvcsCommunicator communicator = this.dvcsCommunicatorProvider.getCommunicator(repository.getDvcsType());
        return communicator.getCreatePullRequestUrl(repository, sourceSlug, sourceBranch, destinationSlug, destinationBranch, eventSource);
    }

    public String getCreatePullRequestUrl(@Nonnull Repository repository, @Nonnull String sourceBranch) {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)sourceBranch);
        DvcsCommunicator communicator = this.dvcsCommunicatorProvider.getCommunicator(repository.getDvcsType());
        return communicator.getCreatePullRequestUrl(repository, sourceBranch);
    }

    @Nonnull
    public Set<String> getIssueKeys(int repositoryId, int pullRequestId) {
        return this.pullRequestDao.getIssueKeys(repositoryId, pullRequestId);
    }

    public RepositoryPullRequestMapping createPullRequest(RepositoryPullRequestMapping repositoryPullRequestMapping) {
        RepositoryPullRequestMapping createdMapping = this.pullRequestDao.savePullRequest(repositoryPullRequestMapping);
        PullRequest pullRequest = this.transformer.transform(createdMapping, false);
        if (PullRequestStatus.OPEN != pullRequest.getStatus()) {
            PullRequest createdPullRequest = this.transformer.transform(createdMapping, false);
            createdPullRequest.setStatus(PullRequestStatus.OPEN);
            this.threadEvents.broadcast(new PullRequestCreatedEvent(createdPullRequest));
            this.threadEvents.broadcast(new PullRequestUpdatedEvent(pullRequest, createdPullRequest));
        } else {
            this.threadEvents.broadcast(new PullRequestCreatedEvent(pullRequest));
        }
        return createdMapping;
    }

    public RepositoryPullRequestMapping updatePullRequest(int pullRequestId, RepositoryPullRequestMapping updatedPrMapping) {
        RepositoryPullRequestMapping mappingBeforeUpdate = this.pullRequestDao.findRequestById(pullRequestId);
        if (mappingBeforeUpdate == null) {
            throw new IllegalArgumentException(String.format("RepositoryPullRequestMapping with id=%s does not exist", updatedPrMapping.getID()));
        }
        RepositoryPullRequestMapping mappingAfterUpdate = this.pullRequestDao.updatePullRequestInfo(pullRequestId, updatedPrMapping);
        PullRequest prAfter = this.transformer.transform(mappingAfterUpdate, false);
        PullRequest prBefore = this.transformer.transform(mappingBeforeUpdate, false);
        if (this.isPullRequestReopened(prBefore, prAfter)) {
            prAfter.setExecutedBy(null);
        }
        this.threadEvents.broadcast(new PullRequestUpdatedEvent(prAfter, prBefore));
        return mappingAfterUpdate;
    }

    private boolean isPullRequestReopened(PullRequest prBefore, PullRequest prAfter) {
        return prAfter.getStatus() == PullRequestStatus.OPEN && prBefore.getStatus() != PullRequestStatus.OPEN;
    }

    public void updatePullRequestParticipants(int pullRequestId, int repositoryId, Map<String, Participant> participantIndex) {
        PullRequestParticipantMapping[] oldParticipants = this.pullRequestDao.getParticipants(pullRequestId);
        for (PullRequestParticipantMapping participantMapping : oldParticipants) {
            Participant participant = participantIndex.remove(participantMapping.getUsername());
            if (participant == null) {
                this.pullRequestDao.removeParticipant(participantMapping);
                continue;
            }
            boolean markedForSave = false;
            if (participant.isApproved() != participantMapping.isApproved()) {
                participantMapping.setApproved(participant.isApproved());
                markedForSave = true;
            }
            if (StringUtils.equals((CharSequence)participant.getRole(), (CharSequence)participantMapping.getRole())) {
                participantMapping.setRole(participant.getRole());
                markedForSave = true;
            }
            if (!markedForSave) continue;
            this.pullRequestDao.saveParticipant(participantMapping);
        }
        for (String username : participantIndex.keySet()) {
            Participant participant = participantIndex.get(username);
            this.pullRequestDao.createParticipant(pullRequestId, repositoryId, participant);
        }
    }
}

