/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.service;

import com.atlassian.fusion.aci.api.model.Installation;
import com.atlassian.fusion.aci.api.service.ACIInstallationService;
import com.atlassian.fusion.aci.api.service.exception.ConnectApplicationNotFoundException;
import com.atlassian.fusion.aci.api.service.exception.InstallationNotFoundException;
import com.atlassian.fusion.aci.api.service.exception.RemoteApplicationClientException;
import com.atlassian.jira.exception.NotFoundException;
import com.atlassian.jira.plugins.dvcs.analytics.AnalyticsService;
import com.atlassian.jira.plugins.dvcs.analytics.event.DvcsType;
import com.atlassian.jira.plugins.dvcs.analytics.event.Source;
import com.atlassian.jira.plugins.dvcs.analytics.smartcommits.SmartCommitsAnalyticsService;
import com.atlassian.jira.plugins.dvcs.dao.OrganizationDao;
import com.atlassian.jira.plugins.dvcs.model.AccountInfo;
import com.atlassian.jira.plugins.dvcs.model.DvcsUser;
import com.atlassian.jira.plugins.dvcs.model.Group;
import com.atlassian.jira.plugins.dvcs.model.Organization;
import com.atlassian.jira.plugins.dvcs.model.credential.Credential;
import com.atlassian.jira.plugins.dvcs.model.credential.CredentialFactory;
import com.atlassian.jira.plugins.dvcs.model.credential.OAuthCredentialVisitor;
import com.atlassian.jira.plugins.dvcs.model.credential.PrincipalIDCredential;
import com.atlassian.jira.plugins.dvcs.service.LinkerService;
import com.atlassian.jira.plugins.dvcs.service.OrganizationService;
import com.atlassian.jira.plugins.dvcs.service.RepositoryService;
import com.atlassian.jira.plugins.dvcs.service.RepositorySyncService;
import com.atlassian.jira.plugins.dvcs.service.optional.aci.AciInstallationServiceAccessor;
import com.atlassian.jira.plugins.dvcs.service.remote.DvcsCommunicator;
import com.atlassian.jira.plugins.dvcs.service.remote.DvcsCommunicatorProvider;
import com.atlassian.jira.plugins.dvcs.util.ExceptionLogger;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.base.Preconditions;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.RejectedExecutionException;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class OrganizationServiceImpl
implements OrganizationService {
    private static final String WRONG_CREDENTIAL_TYPE_MESSAGE_KEY = "com.atlassian.jira.plugins.dvcs.service.oauth.wrong-credential-type";
    private static final Logger log = ExceptionLogger.getLogger(OrganizationServiceImpl.class);
    @Inject
    private AciInstallationServiceAccessor aciInstallationServiceAccessor;
    @Inject
    private AnalyticsService analyticsService;
    @Inject
    private DvcsCommunicatorProvider dvcsCommunicatorProvider;
    @Inject
    private I18nHelper i18nHelper;
    @Inject
    private OrganizationDao organizationDao;
    @Inject
    private RepositoryService repositoryService;
    @Inject
    private RepositorySyncService repositorySyncService;
    @Inject
    private SmartCommitsAnalyticsService smartCommitsAnalyticsService;
    @Inject
    private LinkerService linkerService;

    public AccountInfo getAccountInfo(String hostUrl, String accountName) {
        return this.getAccountInfo(hostUrl, accountName, null);
    }

    public AccountInfo getAccountInfo(String hostUrl, String accountName, String dvcsType) {
        return this.dvcsCommunicatorProvider.getAccountInfo(hostUrl, accountName, dvcsType);
    }

    public List<Organization> getAll(boolean loadRepositories) {
        List organizations = this.organizationDao.getAll();
        if (loadRepositories) {
            for (Organization organization : organizations) {
                this.retrieveRepositories(organization);
            }
        }
        return organizations;
    }

    public List<Integer> getAllOrganizationsWithEnabledRepos() {
        return this.organizationDao.getAllOrganizationsWithEnabledRepos();
    }

    public List<Organization> getAll(boolean loadRepositories, String type) {
        List organizations = this.organizationDao.getAllByType(type);
        if (loadRepositories) {
            for (Organization organization : organizations) {
                this.retrieveRepositories(organization);
            }
        }
        return organizations;
    }

    public int getAllCount() {
        return this.organizationDao.getAllCount();
    }

    public Organization get(int organizationId, boolean loadRepositories) {
        Organization organization = this.organizationDao.get(organizationId);
        if (loadRepositories && organization != null) {
            this.retrieveRepositories(organization);
        }
        return organization;
    }

    private Organization getOrganizationThatMustExist(int id) throws NotFoundException {
        Organization organization = this.get(id, false);
        if (organization == null) {
            throw new NotFoundException("Could not find Organization with id: " + id);
        }
        return organization;
    }

    public Organization getByPrincipalId(String principalId) {
        return this.organizationDao.getByPrincipalId(principalId);
    }

    public void setLastPolled(Organization org, long timestamp) {
        Preconditions.checkArgument((timestamp > 0L ? 1 : 0) != 0);
        this.organizationDao.setLastPolled(org, timestamp);
    }

    public Organization save(@Nonnull Organization organization) {
        Preconditions.checkNotNull((Object)organization, (Object)"An organization is required");
        Organization org = this.organizationDao.getByHostAndName(organization.getHostUrl(), organization.getName());
        if (org != null) {
            return org;
        }
        if (organization.getCredential() == null) {
            organization.setCredential(CredentialFactory.createUnauthenticatedCredential());
        }
        Organization orgSaveResult = this.organizationDao.save(organization);
        this.repositorySyncService.syncRepositoryList(orgSaveResult, false);
        return orgSaveResult;
    }

    public void remove(int organizationId) {
        Organization organization = this.get(organizationId, false);
        if (organization == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        log.debug("Deleting Organization {}...", (Object)organizationId);
        List repositoriesToDelete = this.repositoryService.getAllByOrganization(organizationId, true);
        this.repositoryService.removeRepositories(repositoriesToDelete);
        this.organizationDao.remove(organizationId);
        this.repositoryService.removeOrphanRepositories(repositoriesToDelete);
        log.debug("Organization {} was deleted in {} ms", (Object)organizationId, (Object)(System.currentTimeMillis() - startTime));
        this.triggerAciRemoteUninstallIfNecessary(organization);
    }

    private void triggerAciRemoteUninstallIfNecessary(Organization organization) {
        Option.fromOptional((Optional)((Optional)organization.getCredential().accept(PrincipalIDCredential.visitor()))).forEach(principalCredential -> {
            this.analyticsService.publishConnectOrganisationRemoved(organization);
            Option.fromOptional(this.aciInstallationServiceAccessor.get()).forEach(aciInstallationService -> this.tryAciUninstall((ACIInstallationService)aciInstallationService, (PrincipalIDCredential)principalCredential, organization));
        });
    }

    private void tryAciUninstall(@Nonnull ACIInstallationService aciInstallationService, @Nonnull PrincipalIDCredential principalCredential, @Nonnull Organization organization) {
        try {
            log.debug("Triggering uninstall for installation with principal ID {}.", (Object)principalCredential.getPrincipalId());
            aciInstallationService.uninstall("jira-bitbucket-connector-plugin", principalCredential.getPrincipalId(), Optional.empty());
            log.debug("Uninstall of installation with principal ID {} successful.", (Object)principalCredential.getPrincipalId());
        }
        catch (ConnectApplicationNotFoundException | InstallationNotFoundException e) {
            log.warn("Tried to tell ACI to uninstall the installation for org with id '{}', but the installation with application id '{}' and principalUuid '{}' doesn't exist", (Object)new Object[]{organization.getId(), "jira-bitbucket-connector-plugin", principalCredential.getPrincipalId()}, (Object)e);
        }
        catch (RemoteApplicationClientException e) {
            String errorMessage = String.format("ACI reports that remote uninstallation has failed for org with id '%s', and application id '%s' and principalUuid '%s'", organization.getId(), "jira-bitbucket-connector-plugin", principalCredential.getPrincipalId());
            log.warn(errorMessage, (Throwable)e);
        }
    }

    public Organization updateCredentials(int organizationId, Credential credential) {
        Organization organization = this.organizationDao.get(organizationId);
        if (organization == null) {
            return null;
        }
        organization.setCredential(credential);
        return this.organizationDao.save(organization);
    }

    public Organization updateOAuthCredentials(int organizationId, String key, String secret) {
        Organization organization = this.organizationDao.get(organizationId);
        if (organization == null) {
            return null;
        }
        if (!OAuthCredentialVisitor.isAOAuthCredential((Credential)organization.getCredential())) {
            throw new IllegalStateException(this.i18nHelper.getText(WRONG_CREDENTIAL_TYPE_MESSAGE_KEY, organization.getName()));
        }
        organization.setCredential(CredentialFactory.updateOAuthCredential((Credential)organization.getCredential(), (String)key, (String)secret));
        return this.organizationDao.save(organization);
    }

    public void updateCredentialsAccessToken(int organizationId, String accessToken) {
        Organization organization = this.organizationDao.get(organizationId);
        if (organization != null) {
            organization.setCredential(CredentialFactory.buildCredential().copyFrom(organization.getCredential()).setToken(accessToken).build());
            this.organizationDao.save(organization);
        }
    }

    public void enableAutolinkNewRepos(int orgId, boolean autolink) {
        Organization organization = this.organizationDao.get(orgId);
        if (organization != null) {
            organization.setAutolinkNewRepos(autolink);
            this.organizationDao.save(organization);
        }
    }

    public void enableSmartcommitsOnNewRepos(int id, boolean enabled) {
        Organization organization = this.organizationDao.get(id);
        if (organization != null) {
            organization.setSmartcommitsOnNewRepos(enabled);
            this.organizationDao.save(organization);
            this.smartCommitsAnalyticsService.fireSmartCommitAutoEnabledConfigChange(id, enabled);
        }
    }

    public void setAutolinkAndSmartcommits(int organizationId, boolean enableAutolink, boolean enableSmartCommits) {
        Organization organization = this.organizationDao.get(organizationId);
        if (organization != null) {
            organization.setAutolinkNewRepos(enableAutolink);
            organization.setSmartcommitsOnNewRepos(enableSmartCommits);
            this.organizationDao.save(organization);
            this.smartCommitsAnalyticsService.fireSmartCommitAutoEnabledConfigChange(organizationId, enableSmartCommits);
            this.setSmartCommitStatusOnAllNonLinkedRepos(organization.getId(), enableSmartCommits);
        }
    }

    private void setSmartCommitStatusOnAllNonLinkedRepos(int organizationId, boolean enableSmartCommits) {
        this.repositoryService.getAllByOrganization(organizationId).stream().filter(repo -> !repo.isLinked()).forEach(repo -> {
            log.debug("setting smart commits for repo " + repo.getId());
            repo.setSmartcommitsEnabled(enableSmartCommits);
            this.repositoryService.save(repo);
        });
    }

    public List<Organization> getAllByIds(Collection<Integer> ids) {
        if (CollectionUtils.isNotEmpty(ids)) {
            return this.organizationDao.getAllByIds(ids);
        }
        return Collections.emptyList();
    }

    public void setDefaultGroupsSlugs(int orgId, Collection<String> groupsSlugs) {
        this.organizationDao.setDefaultGroupsSlugs(orgId, groupsSlugs);
    }

    public Organization getByHostAndName(String hostUrl, String name) {
        return this.organizationDao.getByHostAndName(hostUrl, name);
    }

    public DvcsUser getTokenOwner(int organizationId) {
        Organization organization = this.get(organizationId, false);
        DvcsCommunicator communicator = this.dvcsCommunicatorProvider.getCommunicator(organization.getDvcsType());
        return communicator.getTokenOwner(organization);
    }

    public List<Group> getGroupsForOrganization(Organization organization) {
        return this.dvcsCommunicatorProvider.getCommunicator(organization.getDvcsType()).getGroupsForOrganization(organization);
    }

    public boolean existsOrganizationWithType(String ... types) {
        return this.organizationDao.existsOrganizationWithType(types);
    }

    public Organization changeOrganizationApprovalState(int id, Organization.ApprovalState approvalState) throws NotFoundException {
        Organization organization = this.getOrganizationThatMustExist(id);
        log.trace("Setting approval state of Organisation id: {} to {}", (Object)id, (Object)approvalState);
        organization.setApprovalState(approvalState);
        this.organizationDao.save(organization);
        return organization;
    }

    public void createNewOrgBasedOnAciInstallation(Installation installation) {
        log.debug("Creating new DVCS organisation for {}", (Object)installation.getPrincipalUuid());
        this.analyticsService.publishOrganisationAddStarted(Source.DEVTOOLS, DvcsType.BITBUCKET);
        Credential credential = CredentialFactory.createPrincipalCredential((String)installation.getPrincipalUuid());
        Organization org = new Organization();
        org.setHostUrl(installation.getBaseUrl());
        org.setName(installation.getPrincipalUsername());
        org.setDvcsType("bitbucket");
        org.setAutolinkNewRepos(false);
        org.setSmartcommitsOnNewRepos(false);
        org.setCredential(credential);
        org.setApprovalState(Organization.ApprovalState.PENDING_APPROVAL);
        this.save(org);
        log.debug("Created new DVCS organisation for {}", (Object)installation.getPrincipalUuid());
        this.analyticsService.publishConnectOrganisationAdded(org);
    }

    public void migrateExistingOrgToPrincipalCredentialOrg(Organization org, String principalUuid) {
        Preconditions.checkNotNull((Object)org);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)principalUuid), (Object)"principalUuid cannot be blank");
        log.debug("Organisation already exists for {}. Figuring out what to do....", (Object)principalUuid);
        Credential credential = CredentialFactory.createPrincipalCredential((String)principalUuid);
        Optional oldPrincipalIdCredential = (Optional)org.getCredential().accept(PrincipalIDCredential.visitor());
        Organization updatedOrg = this.updateCredentials(org.getId(), credential);
        if (oldPrincipalIdCredential.isPresent()) {
            log.debug("Organisation already exists for {}. Updated credentials.", (Object)principalUuid);
            this.analyticsService.publishConnectOrganisationUpdated(updatedOrg);
        } else {
            log.debug("Organisation already exists for {}. Migrated credentials and removing custom BB linkers and webhooks.", (Object)principalUuid);
            try {
                this.linkerService.removeLinkersAsync(org);
            }
            catch (RejectedExecutionException e) {
                log.debug("Failed to schedule task to update linker values for Organization {}", (Object)org.getId());
            }
            try {
                this.repositoryService.removePostcommitHooksAsync(org, true);
            }
            catch (RejectedExecutionException e) {
                log.debug("Failed to schedule task to remove webhooks for Organization {}", (Object)org.getId());
            }
            this.analyticsService.publishConnectOrganisationMigrated(updatedOrg);
        }
    }

    private void retrieveRepositories(Organization org) {
        List repositories = this.repositoryService.getAllByOrganization(org.getId());
        org.setRepositories(repositories);
    }

    public void removeAll() {
        this.getAll(false).stream().forEach(org -> this.remove(org.getId()));
    }
}

