/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.service;

import com.atlassian.jira.plugins.dvcs.dao.MessageDao;
import com.atlassian.jira.plugins.dvcs.dao.MessageQueueItemDao;
import com.atlassian.jira.plugins.dvcs.dao.SyncAuditLogDao;
import com.atlassian.jira.plugins.dvcs.event.CarefulEventService;
import com.atlassian.jira.plugins.dvcs.exception.SourceControlException;
import com.atlassian.jira.plugins.dvcs.model.DiscardReason;
import com.atlassian.jira.plugins.dvcs.model.Message;
import com.atlassian.jira.plugins.dvcs.model.MessageId;
import com.atlassian.jira.plugins.dvcs.model.MessageQueueItem;
import com.atlassian.jira.plugins.dvcs.model.MessageState;
import com.atlassian.jira.plugins.dvcs.model.Progress;
import com.atlassian.jira.plugins.dvcs.model.Repository;
import com.atlassian.jira.plugins.dvcs.service.ChangesetService;
import com.atlassian.jira.plugins.dvcs.service.LinkerService;
import com.atlassian.jira.plugins.dvcs.service.MessageExecutor;
import com.atlassian.jira.plugins.dvcs.service.RepositoryService;
import com.atlassian.jira.plugins.dvcs.service.message.HasProgress;
import com.atlassian.jira.plugins.dvcs.service.message.MessageAddress;
import com.atlassian.jira.plugins.dvcs.service.message.MessageAddressService;
import com.atlassian.jira.plugins.dvcs.service.message.MessageConsumer;
import com.atlassian.jira.plugins.dvcs.service.message.MessagePayloadSerializer;
import com.atlassian.jira.plugins.dvcs.service.message.MessagingService;
import com.atlassian.jira.plugins.dvcs.spi.bitbucket.clientlibrary.request.HttpClientProvider;
import com.atlassian.jira.plugins.dvcs.sync.SynchronizationFlag;
import com.atlassian.jira.plugins.dvcs.sync.Synchronizer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MessagingServiceImpl
implements MessagingService {
    @VisibleForTesting
    static final String SYNCHRONIZATION_REPO_TAG_PREFIX = "synchronization-repository-";
    private static final String SYNCHRONIZATION_AUDIT_TAG_PREFIX = "audit-id-";
    private static final Logger log = LoggerFactory.getLogger(MessagingServiceImpl.class);
    private final ConcurrentMap<String, List<MessageConsumer<?>>> addressToMessageConsumer = new ConcurrentHashMap();
    private final Map<Class<?>, MessagePayloadSerializer<?>> payloadTypeToPayloadSerializer = new ConcurrentHashMap();
    private final ConcurrentMap<String, MessageConsumer<?>> queueToMessageConsumer = new ConcurrentHashMap();
    @Resource
    protected ChangesetService changesetService;
    @Resource
    private MessageConsumer<?>[] consumers;
    @Resource
    private CarefulEventService eventService;
    @Resource
    private HttpClientProvider httpClientProvider;
    @Resource
    private LinkerService linkerService;
    @Resource
    private MessageAddressService messageAddressService;
    @Resource
    private MessageConsumer<?>[] messageConsumers;
    @Resource
    private MessageDao messageDao;
    @Resource
    private MessageExecutor messageExecutor;
    @Resource(name="MessageQueueItemDaoQueryDsl")
    private MessageQueueItemDao messageQueueItemDao;
    @Resource
    private MessagePayloadSerializer<?>[] payloadSerializers;
    @Resource
    private RepositoryService repositoryService;
    @Resource
    private SyncAuditLogDao syncAudit;
    @Resource
    private Synchronizer synchronizer;

    private static boolean hasErrors(@Nullable Progress progress) {
        return progress != null && progress.getError() != null;
    }

    @PostConstruct
    public void init() {
        for (MessageConsumer<?> messageConsumer : this.messageConsumers) {
            this.queueToMessageConsumer.putIfAbsent(messageConsumer.getQueue(), messageConsumer);
            CopyOnWriteArrayList byAddress = (CopyOnWriteArrayList)this.addressToMessageConsumer.get(messageConsumer.getAddress().getId());
            if (byAddress == null) {
                byAddress = new CopyOnWriteArrayList();
                this.addressToMessageConsumer.putIfAbsent(messageConsumer.getAddress().getId(), byAddress);
            }
            byAddress.add(messageConsumer);
        }
        for (MessageConsumer<?> messageConsumer : this.payloadSerializers) {
            this.payloadTypeToPayloadSerializer.put(messageConsumer.getPayloadType(), (MessagePayloadSerializer<?>)messageConsumer);
        }
    }

    private void initRunningToFail() {
        log.debug("Setting messages in running state to fail");
        this.messageQueueItemDao.getByState(MessageState.RUNNING, queueItemId -> {
            MessageQueueItem item = this.messageQueueItemDao.getQueueItemById((int)queueItemId).orElseThrow(IllegalStateException::new);
            MessageConsumer consumer = (MessageConsumer)this.queueToMessageConsumer.get(item.getQueue());
            this.fail(consumer, item.getMessage(), new RuntimeException("Synchronization has been interrupted (probably plugin un/re/install)."));
        });
    }

    private void restartConsumers() {
        log.debug("Restarting message consumers");
        HashSet<String> addresses = new HashSet<String>();
        for (MessageConsumer<?> consumer : this.consumers) {
            addresses.add(consumer.getAddress().getId());
        }
        addresses.forEach(this.messageExecutor::notify);
    }

    public <P extends HasProgress> void publish(Repository repository, MessageAddress<P> address, P payload, String ... tags) {
        this.publish(repository, address, payload, 0, tags);
    }

    public <P extends HasProgress> void publish(Repository repository, MessageAddress<P> address, P payload, int priority, String ... tags) {
        MessageState state;
        MessageState messageState = state = repository.isLinked() ? MessageState.PENDING : MessageState.SLEEPING;
        if (repository.isDeleted()) {
            return;
        }
        MessagePayloadSerializer<?> payloadSerializer = this.payloadTypeToPayloadSerializer.get(payload.getClass());
        Message message = new Message();
        message.setAddress(address);
        message.setPayload(payloadSerializer.serialize(payload));
        message.setPayloadType(address.getPayloadType());
        message.setTags(tags);
        message.setPriority(priority);
        this.createMessage(message, state, tags);
        this.messageExecutor.notify(address.getId());
    }

    protected <P extends HasProgress> void createMessage(Message<P> message, MessageState state, String ... tags) {
        Message createdMessage = this.messageDao.create(this.toMessageMap(message), tags);
        List byAddress = (List)this.addressToMessageConsumer.get(message.getAddress().getId());
        for (MessageConsumer consumer : byAddress) {
            this.messageQueueItemDao.create(this.messageQueueItemToMap(createdMessage.getId(), consumer.getQueue(), state, null));
        }
    }

    public void pause(Repository repository) {
        String tag = this.getTagForSynchronization(repository);
        LinkedHashSet syncAudits = new LinkedHashSet();
        this.messageDao.getByTag(tag, messageId -> {
            Stream.of(this.messageQueueItemDao.getByMessageId((MessageId)messageId)).filter(queueItem -> !MessageState.RUNNING.name().equals(queueItem.getState())).forEach(messageQueueItem -> {
                messageQueueItem.setState(MessageState.SLEEPING.name());
                this.messageQueueItemDao.save((MessageQueueItem)messageQueueItem);
            });
            int syncAuditId = this.getSynchronizationAuditIdFromTags(this.messageDao.getTags((MessageId)messageId));
            if (syncAuditId != 0) {
                syncAudits.add(syncAuditId);
            }
        });
        syncAudits.forEach(this.syncAudit::pause);
    }

    public <P extends HasProgress> P deserializePayload(Message<P> message) {
        MessagePayloadSerializer<?> payloadSerializer = this.payloadTypeToPayloadSerializer.get(message.getPayloadType());
        return (P)payloadSerializer.deserialize(message);
    }

    public void resume(Repository repository) {
        String tag = this.getTagForSynchronization(repository);
        HashSet addresses = new HashSet();
        HashSet syncAudits = new HashSet();
        this.messageQueueItemDao.getByTagAndState(tag, MessageState.SLEEPING, queueItemId -> {
            MessageQueueItem item = this.messageQueueItemDao.getQueueItemById((int)queueItemId).orElseThrow(IllegalStateException::new);
            item.setState(MessageState.PENDING.name());
            this.messageQueueItemDao.save(item);
            addresses.add(item.getMessage().getAddress().getId());
            int syncAuditId = this.getSynchronizationAuditIdFromTags(item.getMessage().getTags());
            if (syncAuditId != 0) {
                syncAudits.add(syncAuditId);
            }
        });
        addresses.forEach(this.messageExecutor::notify);
        syncAudits.forEach(this.syncAudit::resume);
    }

    public void retry(String tag, int auditId) {
        HashSet addresses = new HashSet();
        this.messageQueueItemDao.getByTagAndState(tag, MessageState.WAITING_FOR_RETRY, queueItemId -> {
            MessageQueueItem item = this.messageQueueItemDao.getQueueItemById((int)queueItemId).orElseThrow(IllegalStateException::new);
            this.updateSyncAuditId(auditId, item);
            addresses.add(item.getMessage().getAddress().getId());
            item.setState(MessageState.PENDING.name());
            this.messageQueueItemDao.save(item);
        });
        addresses.forEach(this.messageExecutor::notify);
    }

    private void updateSyncAuditId(int auditId, MessageQueueItem queueItem) {
        String newSyncAuditIdLog = this.getTagForAuditSynchronization(auditId);
        Stream.of(queueItem.getMessage().getTags()).filter(tag -> tag.startsWith(SYNCHRONIZATION_AUDIT_TAG_PREFIX)).forEach(tag -> this.messageDao.deleteTag(queueItem.getMessage(), (String)tag));
        this.messageDao.createTag(queueItem.getMessage(), newSyncAuditIdLog);
    }

    public void cancel(Repository repository) {
        String tag = this.getTagForSynchronization(repository);
        this.messageDao.getByTag(tag, messageId -> {
            MessageQueueItem[] queueItems = this.messageQueueItemDao.getByMessageId((MessageId)messageId);
            Arrays.stream(queueItems).forEach(this.messageQueueItemDao::delete);
            Message message = this.messageDao.getById(messageId.getId());
            this.messageDao.delete(message);
        });
    }

    public <P extends HasProgress> void running(MessageConsumer<P> consumer, Message<P> message) {
        this.messageQueueItemDao.getByQueueAndMessage(consumer.getQueue(), message.getId()).ifPresent(queueItem -> {
            queueItem.setState(MessageState.RUNNING.name());
            this.messageQueueItemDao.save((MessageQueueItem)queueItem);
        });
    }

    public <P extends HasProgress> void ok(MessageConsumer<P> consumer, Message<P> message) {
        this.messageQueueItemDao.getByQueueAndMessage(consumer.getQueue(), message.getId()).ifPresent(this.messageQueueItemDao::delete);
        if (this.messageQueueItemDao.getByMessageId(new MessageId(message)).length == 0) {
            this.messageDao.delete(message);
        }
    }

    public <P extends HasProgress> void fail(MessageConsumer<P> consumer, Message<P> message, Throwable t) {
        this.messageQueueItemDao.getByQueueAndMessage(consumer.getQueue(), message.getId()).ifPresent(queueItem -> {
            queueItem.setRetryCount(queueItem.getRetryCount() + 1);
            queueItem.setState(MessageState.WAITING_FOR_RETRY.name());
            this.messageQueueItemDao.save((MessageQueueItem)queueItem);
            this.syncAudit.setException(this.getSynchronizationAuditIdFromTags(message.getTags()), t, false);
        });
    }

    public <P extends HasProgress> void discard(MessageConsumer<P> consumer, Message<P> message, DiscardReason discardReason) {
        this.messageQueueItemDao.getByQueueAndMessage(consumer.getQueue(), message.getId()).ifPresent(queueItem -> {
            queueItem.setState(MessageState.DISCARDED.name());
            queueItem.setStateInfo(discardReason.name());
            this.messageQueueItemDao.save((MessageQueueItem)queueItem);
        });
    }

    public <P extends HasProgress> Message<P> getNextMessageForConsuming(MessageConsumer<P> consumer, String address) {
        return this.messageQueueItemDao.getNextItemForProcessing(consumer.getQueue(), address);
    }

    public int getQueuedCount(String tag) {
        return this.messageDao.getMessagesForConsumingCount(tag);
    }

    public <P extends HasProgress> MessageAddress<P> get(Class<P> payloadType, String id) {
        return this.messageAddressService.get(payloadType, id);
    }

    public String getTagForSynchronization(Repository repository) {
        return SYNCHRONIZATION_REPO_TAG_PREFIX + repository.getId();
    }

    public String getTagForAuditSynchronization(int syncAuditLogId) {
        return SYNCHRONIZATION_AUDIT_TAG_PREFIX + syncAuditLogId;
    }

    public int getSynchronizationAuditIdFromTags(String[] tags) {
        for (String tag : tags) {
            String syncIdString = StringUtils.substringAfter((String)tag, (String)SYNCHRONIZATION_AUDIT_TAG_PREFIX);
            if (!StringUtils.isNotBlank((CharSequence)syncIdString)) continue;
            try {
                return Integer.parseInt(syncIdString);
            }
            catch (NumberFormatException e) {
                log.error("Synchronization audit id tag has invalid format. Tag was: '{}'", (Object)tag);
            }
        }
        log.warn("No synchronization audit id tag found in {}; {}", (Object)Arrays.toString(tags), (Object)ExceptionUtils.getStackTrace((Throwable)new Exception("Dummy exception")));
        return 0;
    }

    public <P extends HasProgress> Repository getRepositoryFromMessage(Message<P> message) {
        for (String tag : message.getTags()) {
            if (!StringUtils.startsWith((CharSequence)tag, (CharSequence)SYNCHRONIZATION_REPO_TAG_PREFIX)) continue;
            try {
                int repositoryId = Integer.parseInt(tag.substring(SYNCHRONIZATION_REPO_TAG_PREFIX.length()));
                return this.repositoryService.get(repositoryId);
            }
            catch (NumberFormatException e) {
                log.warn("Get repo ID from message: " + e.getMessage());
            }
        }
        log.warn("Can't get repository ID from tags for message with ID {}", (Object)message.getId());
        return null;
    }

    private <P extends HasProgress> Map<String, Object> toMessageMap(Message<P> source) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("ADDRESS", source.getAddress().getId());
        result.put("PRIORITY", source.getPriority());
        result.put("PAYLOAD_TYPE", source.getPayloadType().getCanonicalName());
        result.put("PAYLOAD", source.getPayload());
        return result;
    }

    private Map<String, Object> messageQueueItemToMap(int messageId, String queue, MessageState state, String stateInfo) {
        Preconditions.checkNotNull((Object)messageId);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("MESSAGE_ID", messageId);
        result.put("QUEUE", queue);
        result.put("STATE", state.name());
        result.put("STATE_INFO", stateInfo);
        result.put("RETRIES_COUNT", 0);
        return result;
    }

    public <P extends HasProgress> void tryEndProgress(Repository repository, Progress progress, MessageConsumer<P> consumer, int auditId) {
        boolean finished = this.endProgress(repository, progress);
        if (finished && auditId > 0) {
            int flightTimeMs;
            int numRequests;
            Date firstRequestDate;
            Date finishDate;
            if (progress == null) {
                finishDate = new Date();
                firstRequestDate = null;
                numRequests = 0;
                flightTimeMs = 0;
            } else {
                finishDate = new Date(progress.getFinishTime());
                firstRequestDate = progress.getFirstMessageTime();
                numRequests = progress.getNumRequests();
                flightTimeMs = progress.getFlightTimeMs();
            }
            this.syncAudit.finish(auditId, firstRequestDate, numRequests, flightTimeMs, finishDate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean endProgress(Repository repository, Progress progress) {
        int queuedCount = this.getQueuedCount(this.getTagForSynchronization(repository));
        if (queuedCount == 0) {
            try {
                boolean hasErrors = MessagingServiceImpl.hasErrors(progress);
                if (progress != null && !progress.isFinished()) {
                    progress.finish();
                    EnumSet flags = progress.getRunAgainFlags();
                    if (flags != null) {
                        progress.setRunAgainFlags(null);
                        flags.add(SynchronizationFlag.SOFT_SYNC);
                        try {
                            this.synchronizer.doSync(repository, (Collection)flags);
                        }
                        catch (SourceControlException.SynchronizationDisabled synchronizationDisabled) {
                            // empty catch block
                        }
                    }
                }
                if (!hasErrors) {
                    this.eventService.dispatchEvents(repository);
                }
                this.linkerService.updateConnectLinkerValues(repository.getOrganizationId());
                boolean bl = true;
                return bl;
            }
            finally {
                this.httpClientProvider.closeIdleConnections();
            }
        }
        return false;
    }

    public void onStart() {
        this.initRunningToFail();
        this.restartConsumers();
    }
}

