/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.service;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.jira.plugins.dvcs.ProgressUtil;
import com.atlassian.jira.plugins.dvcs.event.RepositorySync;
import com.atlassian.jira.plugins.dvcs.event.RepositorySyncFactory;
import com.atlassian.jira.plugins.dvcs.model.DiscardReason;
import com.atlassian.jira.plugins.dvcs.model.Message;
import com.atlassian.jira.plugins.dvcs.model.Progress;
import com.atlassian.jira.plugins.dvcs.model.Repository;
import com.atlassian.jira.plugins.dvcs.service.message.AbstractMessagePayloadSerializer;
import com.atlassian.jira.plugins.dvcs.service.message.HasProgress;
import com.atlassian.jira.plugins.dvcs.service.message.MessageConsumer;
import com.atlassian.jira.plugins.dvcs.service.message.MessagingService;
import com.atlassian.jira.plugins.dvcs.spi.github.GithubRateLimitExceededException;
import com.atlassian.jira.plugins.dvcs.sync.SynchronizationFlag;
import com.atlassian.jira.plugins.dvcs.util.HelpLinkRenderer;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.util.concurrent.ThreadFactories;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MessageExecutor {
    public static final String PROCESS_MESSAGE_LOCK = MessageExecutor.class.getName() + ".processMessage";
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageConsumer.class);
    private final ThreadPoolExecutor executor;
    private final ConcurrentMap<String, List<MessageConsumer<?>>> messageAddressToConsumers = new ConcurrentHashMap();
    private final ConcurrentMap<MessageConsumer<?>, AtomicInteger> consumerToRemainingTokens = new ConcurrentHashMap();
    @Resource
    @ComponentImport
    private ClusterLockService clusterLockService;
    @Resource
    private HelpLinkRenderer helpLinkRenderer;
    @Resource
    @ComponentImport
    private I18nHelper i18nHelper;
    @Resource
    private MessagingService messagingService;
    @Resource
    private MessageConsumer<?>[] consumers;
    @Resource
    private RepositorySyncFactory repoSyncFactory;
    private volatile boolean stop;

    public MessageExecutor() {
        this(MessageExecutor.createThreadPoolExecutor());
    }

    @VisibleForTesting
    public MessageExecutor(@Nonnull ThreadPoolExecutor executor) {
        this.executor = (ThreadPoolExecutor)Preconditions.checkNotNull((Object)executor, (Object)"executor");
    }

    private static ThreadPoolExecutor createThreadPoolExecutor() {
        return new ThreadPoolExecutor(1, Integer.MAX_VALUE, 5L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), ThreadFactories.namedThreadFactory((String)"DVCSConnector.MessageExecutor"));
    }

    @PostConstruct
    public void init() {
        for (MessageConsumer<?> consumer : this.consumers) {
            CopyOnWriteArrayList byAddress = (CopyOnWriteArrayList)this.messageAddressToConsumers.get(consumer.getAddress().getId());
            if (byAddress == null) {
                byAddress = new CopyOnWriteArrayList();
                this.messageAddressToConsumers.putIfAbsent(consumer.getAddress().getId(), byAddress);
            }
            byAddress.add(consumer);
            this.consumerToRemainingTokens.put(consumer, new AtomicInteger(consumer.getParallelThreads()));
        }
    }

    @PreDestroy
    public void destroy() throws Exception {
        this.stop = true;
        this.executor.shutdown();
        this.executor.getQueue().clear();
        if (!this.executor.awaitTermination(1L, TimeUnit.MINUTES)) {
            LOGGER.error("Unable properly shutdown message queue.");
        }
    }

    public void notify(String address) {
        ((List)this.messageAddressToConsumers.get(address)).forEach(this::tryToProcessNextMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <P extends HasProgress> void tryToProcessNextMessage(MessageConsumer<P> consumer) {
        Message message;
        if (this.stop) {
            return;
        }
        ClusterLock lock = this.clusterLockService.getLockForName(PROCESS_MESSAGE_LOCK);
        lock.lock();
        try {
            message = this.messagingService.getNextMessageForConsuming(consumer, consumer.getAddress().getId());
            if (message == null) {
                return;
            }
            if (!this.acquireToken(consumer)) {
                return;
            }
            this.messagingService.running(consumer, message);
        }
        finally {
            lock.unlock();
        }
        this.executor.execute(new MessageRunnable<P>(message, consumer));
    }

    private <P extends HasProgress> boolean acquireToken(MessageConsumer<P> consumer) {
        int remainingTokensValue;
        AtomicInteger remainingTokens = (AtomicInteger)this.consumerToRemainingTokens.get(consumer);
        do {
            if ((remainingTokensValue = remainingTokens.get()) > 0) continue;
            return false;
        } while (!remainingTokens.compareAndSet(remainingTokensValue, remainingTokensValue - 1));
        return true;
    }

    private <P extends HasProgress> void releaseToken(MessageConsumer<P> consumer) {
        ((AtomicInteger)this.consumerToRemainingTokens.get(consumer)).incrementAndGet();
    }

    private final class MessageRunnable<P extends HasProgress>
    extends ReleaseTokenAndEnqueueNextMessage {
        private final Message<P> message;
        private final MessageConsumer<P> consumer;

        public MessageRunnable(Message<P> message, MessageConsumer<P> consumer) {
            this.message = message;
            this.consumer = consumer;
        }

        public MessageConsumer<P> getConsumer() {
            return this.consumer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doRun() {
            Progress progress;
            HasProgress payload;
            try {
                payload = MessageExecutor.this.messagingService.deserializePayload(this.message);
                progress = payload.getProgress();
            }
            catch (AbstractMessagePayloadSerializer.MessageDeserializationException e) {
                MessageExecutor.this.messagingService.discard(this.consumer, this.message, DiscardReason.FAILED_DESERIALIZATION);
                throw e;
            }
            boolean softSync = progress.isSoftsync() && payload.isSoftSync();
            boolean webHookSync = progress.isWebHookSync() && payload.isWebHookSync();
            Repository repository = MessageExecutor.this.messagingService.getRepositoryFromMessage(this.message);
            EnumSet<SynchronizationFlag> syncFlags = EnumSet.noneOf(SynchronizationFlag.class);
            if (softSync) {
                syncFlags.add(SynchronizationFlag.SOFT_SYNC);
            }
            if (webHookSync) {
                syncFlags.add(SynchronizationFlag.WEBHOOK_SYNC);
            }
            RepositorySync repoSync = MessageExecutor.this.repoSyncFactory.getInstance(repository, syncFlags);
            try {
                this.consumer.onReceive(this.message, payload);
                MessageExecutor.this.messagingService.ok(this.consumer, this.message);
            }
            catch (GithubRateLimitExceededException e) {
                MessageExecutor.this.messagingService.fail(this.consumer, this.message, (Throwable)e);
                if (this.message.getRetriesCount() >= 3) {
                    MessageExecutor.this.messagingService.discard(this.consumer, this.message, DiscardReason.RETRY_COUNT_EXCEEDED);
                }
                ProgressUtil.setErrorMessage(progress, MessageExecutor.this.i18nHelper.getText("com.atlassian.jira.plugins.dvcs.sync.paused"), MessageExecutor.this.i18nHelper.getText("com.atlassian.jira.plugins.dvcs.github.rate.limit.reached"), true);
                LOGGER.error(e.getMessage());
            }
            catch (Throwable t) {
                LOGGER.error("Synchronization failed: " + t.getMessage(), t);
                MessageExecutor.this.messagingService.fail(this.consumer, this.message, t);
                if (this.message.getRetriesCount() >= 3) {
                    MessageExecutor.this.messagingService.discard(this.consumer, this.message, DiscardReason.RETRY_COUNT_EXCEEDED);
                }
                progress.setError(MessageExecutor.this.helpLinkRenderer.render("link.dvcs.generic.sync.error"));
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
            }
            finally {
                repoSync.finish();
                this.tryEndProgress(repository, this.message, this.consumer, progress);
            }
        }

        protected void tryEndProgress(Repository repository, Message<P> message, MessageConsumer<P> consumer, Progress progress) {
            try {
                if (repository != null) {
                    MessageExecutor.this.messagingService.tryEndProgress(repository, progress, consumer, MessageExecutor.this.messagingService.getSynchronizationAuditIdFromTags(message.getTags()));
                }
            }
            catch (RuntimeException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private abstract class ReleaseTokenAndEnqueueNextMessage
    implements Runnable {
        private ReleaseTokenAndEnqueueNextMessage() {
        }

        @Override
        public final void run() {
            try {
                this.doRun();
            }
            finally {
                MessageConsumer<?> consumer = this.getConsumer();
                MessageExecutor.this.releaseToken(consumer);
                MessageExecutor.this.tryToProcessNextMessage(consumer);
            }
        }

        protected abstract void doRun();

        protected abstract MessageConsumer<?> getConsumer();
    }
}

