/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.service;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.jira.plugins.dvcs.service.message.HasProgress;
import com.atlassian.jira.plugins.dvcs.service.message.MessageAddress;
import com.atlassian.jira.plugins.dvcs.service.message.MessageAddressService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@ParametersAreNonnullByDefault
public class MessageAddressServiceImpl
implements MessageAddressService {
    private static final Logger log = LoggerFactory.getLogger(MessageAddressServiceImpl.class);
    private static final CacheSettings CACHE_SETTINGS = new CacheSettingsBuilder().local().build();
    private final Cache<IdKey<?>, MessageAddress<?>> idToMessageAddress;

    @Inject
    public MessageAddressServiceImpl(@ComponentImport CacheManager cacheManager) {
        this.idToMessageAddress = cacheManager.getCache(this.getClass().getName() + ".idToMessageAddress", new MessageAddressLoader(), CACHE_SETTINGS);
    }

    public <P extends HasProgress> MessageAddress<P> get(Class<P> payloadType, String id) {
        IdKey<P> key = new IdKey<P>(id, payloadType);
        return (MessageAddress)this.idToMessageAddress.get(key);
    }

    @VisibleForTesting
    public static class IdKey<P extends HasProgress>
    implements Serializable {
        private static final long serialVersionUID = 7389777255355593862L;
        private final String id;
        private final Class<P> payloadType;

        @VisibleForTesting
        public IdKey(String id, Class<P> payloadType) {
            this.id = id;
            this.payloadType = payloadType;
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            return this == obj || obj != null && obj instanceof IdKey && StringUtils.equals((CharSequence)this.id, (CharSequence)((IdKey)obj).id);
        }
    }

    @VisibleForTesting
    public static class MessageAddressLoader<P extends HasProgress>
    implements CacheLoader<IdKey<P>, MessageAddress<P>> {
        @Nonnull
        public MessageAddress<P> load(final @Nonnull IdKey<P> key) {
            log.debug("idToMessageAddress loading new item for key id: {} payloadType: {} ", (Object)((IdKey)key).id, (Object)((IdKey)key).payloadType);
            return new MessageAddress<P>(){

                public String getId() {
                    return key.id;
                }

                public Class<P> getPayloadType() {
                    return key.payloadType;
                }
            };
        }
    }
}

