/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.service;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.jira.plugins.dvcs.dao.OrganizationDao;
import com.atlassian.jira.plugins.dvcs.dao.RepositoryDao;
import com.atlassian.jira.plugins.dvcs.model.Organization;
import com.atlassian.jira.plugins.dvcs.model.credential.PrincipalIDCredential;
import com.atlassian.jira.plugins.dvcs.service.DvcsConnectorExecutorFactory;
import com.atlassian.jira.plugins.dvcs.service.LinkerService;
import com.atlassian.jira.plugins.dvcs.service.remote.DvcsCommunicator;
import com.atlassian.jira.plugins.dvcs.service.remote.DvcsCommunicatorProvider;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import io.atlassian.fugue.Unit;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
@Named
public class LinkerServiceImpl
implements LinkerService {
    @VisibleForTesting
    static final String ORG_LINKER_VALUE_CLUSTER_LOCK_BASE = "com.atlassian.jira.plugins.dvcs.service.organization.linkerValue.";
    private static final Logger LOG = LoggerFactory.getLogger(LinkerServiceImpl.class);
    private final ClusterLockService clusterLockService;
    private final ProjectManager projectManager;
    private final DvcsCommunicatorProvider dvcsCommunicatorProvider;
    private final OrganizationDao organizationDao;
    private final RepositoryDao repositoryDao;
    private final DvcsConnectorExecutorFactory executorFactory;
    private ThreadPoolExecutor executor;

    @Inject
    public LinkerServiceImpl(@ComponentImport ClusterLockService clusterLockService, @ComponentImport ProjectManager projectManager, DvcsCommunicatorProvider dvcsCommunicatorProvider, DvcsConnectorExecutorFactory executorFactory, OrganizationDao organizationDao, RepositoryDao repositoryDao) {
        this.clusterLockService = Objects.requireNonNull(clusterLockService);
        this.projectManager = Objects.requireNonNull(projectManager);
        this.dvcsCommunicatorProvider = Objects.requireNonNull(dvcsCommunicatorProvider);
        this.organizationDao = Objects.requireNonNull(organizationDao);
        this.repositoryDao = Objects.requireNonNull(repositoryDao);
        this.executorFactory = Objects.requireNonNull(executorFactory);
        this.executor = executorFactory.createLinkerServiceThreadPoolExecutor();
    }

    @PreDestroy
    public void destroy() {
        this.executorFactory.shutdownExecutor(LinkerServiceImpl.class.getName(), this.executor);
    }

    public Future<Unit> updateConnectLinkerValuesAsync(int organizationId) {
        LOG.debug("Triggering async processing of removeLinkers for organizationId: {}", (Object)organizationId);
        return this.executor.submit(() -> this.updateConnectLinkerValues(organizationId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Unit updateConnectLinkerValues(int organizationId) {
        Organization organization = this.organizationDao.get(organizationId);
        Optional maybePrincipal = (Optional)organization.getCredential().accept(PrincipalIDCredential.visitor());
        if (!maybePrincipal.isPresent()) {
            return Unit.Unit();
        }
        ClusterLock lock = this.clusterLockService.getLockForName(ORG_LINKER_VALUE_CLUSTER_LOCK_BASE + organizationId);
        boolean lockAcquired = false;
        try {
            lockAcquired = lock.tryLock(1L, TimeUnit.MINUTES);
            if (!lockAcquired) {
                Unit unit = Unit.Unit();
                return unit;
            }
            Collection projectKeysOnChangesets = this.organizationDao.getAllProjectKeysFromChangesetsInOrganization(organizationId);
            Iterable currentlyLinkedProjectsIterable = this.organizationDao.getCurrentlyLinkedProjects(organizationId);
            ImmutableSet currentlyLinkedProjects = ImmutableSet.builder().addAll(currentlyLinkedProjectsIterable).build();
            Set<String> projectKeysInJira = this.getProjectKeysInJira();
            projectKeysInJira.retainAll(projectKeysOnChangesets);
            if (!projectKeysInJira.equals(currentlyLinkedProjects)) {
                LOG.debug("project keys have changed, updating Bitbucket with {}", projectKeysInJira);
                DvcsCommunicator communicator = this.dvcsCommunicatorProvider.getCommunicator(organization.getDvcsType());
                communicator.setConnectLinkerValuesForOrganization(organization, projectKeysInJira);
                this.organizationDao.updateLinkedProjects(organizationId, projectKeysInJira);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (lock != null && lockAcquired) {
                lock.unlock();
            }
        }
        return Unit.Unit();
    }

    private Set<String> getProjectKeysInJira() {
        Stream projectObjects = this.projectManager.getProjectObjects().stream();
        return projectObjects.map(project -> project.getKey()).collect(Collectors.toSet());
    }

    public Unit removeLinkers(@Nonnull Organization organization) {
        LOG.debug("Removing linkers for Organization id: {}, name: {}", (Object)organization.getId(), (Object)organization.getName());
        DvcsCommunicator communicator = this.dvcsCommunicatorProvider.getCommunicator(organization.getDvcsType());
        List repositories = this.repositoryDao.getAllByOrganization(organization.getId(), false);
        repositories.forEach(repository -> communicator.removeLinkersForRepo(repository));
        LOG.debug("Finished removing linkers for Organization id: {}, name: {}", (Object)organization.getId(), (Object)organization.getName());
        return Unit.Unit();
    }

    public Future<Unit> removeLinkersAsync(@Nonnull Organization organization) {
        LOG.debug("Triggering async processing of removeLinkers for orgId: {}", (Object)organization.getId());
        return this.executor.submit(() -> this.removeLinkers(organization));
    }
}

