/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.service;

import com.atlassian.jira.plugins.dvcs.service.InvalidOrganizationManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InvalidOrganizationsManagerImpl
implements InvalidOrganizationManager {
    private static final String SETTINGS_KEY = "dvcs.connector.invalidOrganizations";
    private final PluginSettingsFactory pluginSettingsFactory;

    @Autowired
    public InvalidOrganizationsManagerImpl(@ComponentImport PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettingsFactory = (PluginSettingsFactory)Preconditions.checkNotNull((Object)pluginSettingsFactory);
    }

    @Override
    public void setOrganizationValid(int organizationId, boolean valid) {
        if (valid) {
            this.validateOrganization(organizationId);
        } else {
            this.invalidateOrganization(organizationId);
        }
    }

    private void validateOrganization(int organizationId) {
        List<String> invalidOrganizations = this.loadInvalidOrganizations();
        String organizationIdString = Integer.toString(organizationId);
        if (invalidOrganizations != null) {
            invalidOrganizations.remove(organizationIdString);
            this.pluginSettingsFactory.createGlobalSettings().put(SETTINGS_KEY, invalidOrganizations);
        }
    }

    private void invalidateOrganization(int organizationId) {
        String organizationIdString;
        List<String> invalidOrganizations = this.loadInvalidOrganizations();
        if (invalidOrganizations == null) {
            invalidOrganizations = new ArrayList<String>();
        }
        if (!invalidOrganizations.contains(organizationIdString = Integer.toString(organizationId))) {
            invalidOrganizations.add(organizationIdString);
            this.saveInvalidOrganizations(invalidOrganizations);
        }
    }

    @Override
    public boolean isOrganizationValid(int organizationId) {
        List<String> invalidOrganizations = this.loadInvalidOrganizations();
        if (invalidOrganizations == null) {
            return true;
        }
        return !invalidOrganizations.contains(Integer.toString(organizationId));
    }

    private List<String> loadInvalidOrganizations() {
        return (List)this.pluginSettingsFactory.createGlobalSettings().get(SETTINGS_KEY);
    }

    private void saveInvalidOrganizations(List<String> invalidOrganizations) {
        this.pluginSettingsFactory.createGlobalSettings().put(SETTINGS_KEY, invalidOrganizations);
    }
}

