/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.service;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.plugins.dvcs.activeobjects.v3.GitHubEventMapping;
import com.atlassian.jira.plugins.dvcs.dao.GitHubEventDAO;
import com.atlassian.jira.plugins.dvcs.model.Progress;
import com.atlassian.jira.plugins.dvcs.model.Repository;
import com.atlassian.jira.plugins.dvcs.service.GitHubEventContextImpl;
import com.atlassian.jira.plugins.dvcs.service.message.HasProgress;
import com.atlassian.jira.plugins.dvcs.service.message.MessageAddress;
import com.atlassian.jira.plugins.dvcs.service.message.MessagingService;
import com.atlassian.jira.plugins.dvcs.service.remote.SyncDisabledHelper;
import com.atlassian.jira.plugins.dvcs.spi.github.GithubClientProvider;
import com.atlassian.jira.plugins.dvcs.spi.github.message.GitHubPullRequestPageMessage;
import com.atlassian.jira.plugins.dvcs.spi.github.service.GitHubEventContext;
import com.atlassian.jira.plugins.dvcs.spi.github.service.GitHubEventProcessorAggregator;
import com.atlassian.jira.plugins.dvcs.spi.github.service.GitHubEventService;
import com.atlassian.jira.plugins.dvcs.sync.GitHubPullRequestPageMessageConsumer;
import com.atlassian.jira.plugins.dvcs.sync.GitHubPullRequestProcessor;
import com.atlassian.jira.plugins.dvcs.sync.Synchronizer;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Resource;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.RepositoryId;
import org.eclipse.egit.github.core.client.PageIterator;
import org.eclipse.egit.github.core.event.Event;
import org.eclipse.egit.github.core.event.EventPayload;
import org.eclipse.egit.github.core.service.EventService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GitHubEventServiceImpl
implements GitHubEventService {
    private static final Logger logger = LoggerFactory.getLogger(GitHubEventServiceImpl.class);
    @Resource
    private GitHubEventDAO gitHubEventDAO;
    @Resource
    private GitHubEventProcessorAggregator<EventPayload> gitHubEventProcessorAggregator;
    @Resource
    @ComponentImport
    private ActiveObjects activeObjects;
    @Resource(name="githubClientProvider")
    private GithubClientProvider githubClientProvider;
    @Resource
    private Synchronizer synchronizer;
    @Resource
    private MessagingService messagingService;
    @Resource
    private SyncDisabledHelper syncDisabledHelper;
    @Resource
    private GitHubPullRequestProcessor gitHubPullRequestProcessor;

    private static void saveEventCounterpart(Repository repository, Event event, boolean savePoint, GitHubEventDAO gitHubEventDAO) {
        HashMap<String, Object> gitHubEvent = new HashMap<String, Object>();
        gitHubEvent.put("GIT_HUB_ID", event.getId());
        gitHubEvent.put("CREATED_AT", event.getCreatedAt());
        gitHubEvent.put("REPOSITORY_ID", repository.getId());
        if (savePoint) {
            gitHubEvent.put("SAVE_POINT", savePoint);
        }
        gitHubEventDAO.create(gitHubEvent);
    }

    public void removeAll(Repository repository) {
        this.gitHubEventDAO.removeAll(repository);
    }

    public void synchronize(Repository repository, boolean isSoftSync, String[] synchronizationTags, boolean webHookSync) {
        EventService eventService = this.githubClientProvider.getEventService(repository);
        RepositoryId forRepositoryId = RepositoryId.createFromUrl((String)repository.getRepositoryUrl());
        GitHubEventMapping lastGitHubEventSavePoint = this.gitHubEventDAO.getLastSavePoint(repository);
        String latestEventGitHubId = null;
        GitHubEventContextImpl context = new GitHubEventContextImpl(this.synchronizer, this.messagingService, repository, isSoftSync, synchronizationTags, webHookSync);
        PageIterator events = eventService.pageEvents((IRepositoryIdProvider)forRepositoryId);
        boolean forcePRListSynchronization = true;
        HashSet<String> processedEventIds = new HashSet<String>();
        for (Event event : Iterables.concat((Iterable)events)) {
            boolean shouldStop = (Boolean)this.activeObjects.executeInTransaction((TransactionCallback)new SyncTransactionCallback(processedEventIds, lastGitHubEventSavePoint, event, context, this.gitHubEventDAO, this.gitHubEventProcessorAggregator));
            if (!processedEventIds.add(event.getId())) {
                logger.debug("Duplicate event id provided by Github, skipping this event");
                continue;
            }
            if (shouldStop) {
                forcePRListSynchronization = false;
                break;
            }
            if (latestEventGitHubId != null) continue;
            latestEventGitHubId = event.getId();
        }
        if (latestEventGitHubId != null) {
            this.gitHubEventDAO.markAsSavePoint(this.gitHubEventDAO.getByGitHubId(repository, latestEventGitHubId));
        }
        if (forcePRListSynchronization && latestEventGitHubId != null && !this.syncDisabledHelper.isGitHubUsePullRequestListDisabled()) {
            Progress progress = this.synchronizer.getProgress(repository.getId());
            GitHubPullRequestPageMessage message = new GitHubPullRequestPageMessage(null, progress.getAuditLogId(), progress.isSoftsync(), repository, 1, 30, context.getProcessedPullRequests(), webHookSync);
            MessageAddress key = this.messagingService.get(GitHubPullRequestPageMessage.class, GitHubPullRequestPageMessageConsumer.ADDRESS);
            this.messagingService.publish(repository, key, (HasProgress)message, synchronizationTags);
        }
    }

    public void saveEvent(Repository repository, Event event, boolean savePoint) {
        if (this.gitHubEventDAO.getByGitHubId(repository, event.getId()) == null) {
            GitHubEventServiceImpl.saveEventCounterpart(repository, event, savePoint, this.gitHubEventDAO);
        }
    }

    @VisibleForTesting
    static class SyncTransactionCallback
    implements TransactionCallback<Boolean> {
        private final GitHubEventMapping lastGitHubEventSavePoint;
        private final Event event;
        private final Repository repository;
        private final boolean isSoftSync;
        private final String[] synchronizationTags;
        private final GitHubEventContextImpl context;
        private final Set<String> processedEventIds;
        private final GitHubEventDAO gitHubEventDAO;
        private final GitHubEventProcessorAggregator<EventPayload> gitHubEventProcessorAggregator;

        SyncTransactionCallback(Set<String> processedEventIds, GitHubEventMapping lastGitHubEventSavePoint, Event event, GitHubEventContextImpl context, GitHubEventDAO gitHubEventDAO, GitHubEventProcessorAggregator<EventPayload> gitHubEventProcessorAggregator) {
            this.processedEventIds = processedEventIds;
            this.lastGitHubEventSavePoint = lastGitHubEventSavePoint;
            this.event = event;
            this.context = context;
            this.gitHubEventDAO = gitHubEventDAO;
            this.gitHubEventProcessorAggregator = gitHubEventProcessorAggregator;
            this.repository = context.getRepository();
            this.isSoftSync = context.isSoftSync();
            this.synchronizationTags = context.getSynchronizationTags();
        }

        public Boolean doInTransaction() {
            if (this.lastGitHubEventSavePoint != null && this.event.getCreatedAt().before(this.lastGitHubEventSavePoint.getCreatedAt())) {
                return Boolean.TRUE;
            }
            if (this.gitHubEventDAO.getByGitHubId(this.repository, this.event.getId()) != null) {
                return Boolean.FALSE;
            }
            if (this.processedEventIds.contains(this.event.getId())) {
                logger.info("Short circuiting attempt to process duplicate event id {}", (Object)this.event.getId());
                return Boolean.FALSE;
            }
            this.gitHubEventProcessorAggregator.process(this.repository, this.event, this.isSoftSync, this.synchronizationTags, (GitHubEventContext)this.context);
            GitHubEventServiceImpl.saveEventCounterpart(this.repository, this.event, false, this.gitHubEventDAO);
            return Boolean.FALSE;
        }
    }
}

