/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.service;

import com.atlassian.jira.plugins.dvcs.model.Progress;
import com.atlassian.jira.plugins.dvcs.model.Repository;
import com.atlassian.jira.plugins.dvcs.service.message.HasProgress;
import com.atlassian.jira.plugins.dvcs.service.message.MessagingService;
import com.atlassian.jira.plugins.dvcs.spi.github.message.GitHubPullRequestSynchronizeMessage;
import com.atlassian.jira.plugins.dvcs.spi.github.service.GitHubEventContext;
import com.atlassian.jira.plugins.dvcs.sync.GitHubPullRequestSynchronizeMessageConsumer;
import com.atlassian.jira.plugins.dvcs.sync.Synchronizer;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.egit.github.core.PullRequest;

public class GitHubEventContextImpl
implements GitHubEventContext {
    private final Synchronizer synchronizer;
    private final MessagingService messagingService;
    private final Repository repository;
    private final boolean isSoftSync;
    private final String[] synchronizationTags;
    private final boolean webHookSync;
    private final Set<Long> processedPullRequests = new HashSet<Long>();

    public GitHubEventContextImpl(Synchronizer synchronizer, MessagingService messagingService, Repository repository, boolean softSync, String[] synchronizationTags, boolean webHookSync) {
        this.synchronizer = synchronizer;
        this.messagingService = messagingService;
        this.repository = repository;
        this.isSoftSync = softSync;
        this.synchronizationTags = synchronizationTags;
        this.webHookSync = webHookSync;
    }

    public void savePullRequest(PullRequest pullRequest) {
        if (pullRequest == null || this.processedPullRequests.contains(pullRequest.getId())) {
            return;
        }
        this.processedPullRequests.add(pullRequest.getId());
        Progress progress = this.synchronizer.getProgress(this.repository.getId());
        GitHubPullRequestSynchronizeMessage message = new GitHubPullRequestSynchronizeMessage(progress, progress.getAuditLogId(), this.isSoftSync, this.repository, pullRequest.getNumber(), this.webHookSync);
        this.messagingService.publish(this.repository, this.messagingService.get(GitHubPullRequestSynchronizeMessage.class, GitHubPullRequestSynchronizeMessageConsumer.ADDRESS), (HasProgress)message, this.synchronizationTags);
    }

    public Set<Long> getProcessedPullRequests() {
        return this.processedPullRequests;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public boolean isSoftSync() {
        return this.isSoftSync;
    }

    public String[] getSynchronizationTags() {
        return this.synchronizationTags;
    }
}

