/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.service;

import com.atlassian.jira.plugins.dvcs.service.DvcsConnectorExecutorFactory;
import com.atlassian.util.concurrent.ThreadFactories;
import com.google.common.base.Preconditions;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@ParametersAreNonnullByDefault
public class DvcsConnectorExecutorFactoryImpl
implements DvcsConnectorExecutorFactory {
    private static final String LINKER_SERVICE_THREAD_PREFIX = "DVCSConnector.LinkerService";
    private static final String WEBHOOK_CLEANUP_THREAD_PREFIX = "DVCSConnector.WebhookCleanup";
    private static final String REPOSITORY_DELETION_THREAD_PREFIX = "DVCSConnector.RepositoryDeletion";
    private static final long DESTROY_TIMEOUT_SECS = 30L;
    private static final Logger LOG = LoggerFactory.getLogger(DvcsConnectorExecutorFactoryImpl.class);

    public ThreadPoolExecutor createLinkerServiceThreadPoolExecutor() {
        return this.createDefaultThreadpoolExecutor(LINKER_SERVICE_THREAD_PREFIX);
    }

    public ThreadPoolExecutor createWebhookCleanupThreadPoolExecutor() {
        return this.createDefaultThreadpoolExecutor(WEBHOOK_CLEANUP_THREAD_PREFIX);
    }

    public ThreadPoolExecutor createRepositoryDeletionThreadPoolExecutor() {
        return this.createSingleThreadExecutor(REPOSITORY_DELETION_THREAD_PREFIX);
    }

    private ThreadPoolExecutor createDefaultThreadpoolExecutor(String name) {
        return new ThreadPoolExecutor(1, 10, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(100), ThreadFactories.namedThreadFactory((String)name));
    }

    private ThreadPoolExecutor createSingleThreadExecutor(String name) {
        return new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), ThreadFactories.namedThreadFactory((String)name));
    }

    public void shutdownExecutor(String owningClassName, ThreadPoolExecutor executor) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)owningClassName), (Object)"The owning class name must be provided");
        Preconditions.checkNotNull((Object)executor, (Object)"An executor must be provided");
        executor.shutdown();
        executor.getQueue().clear();
        try {
            boolean destroyed = executor.awaitTermination(30L, TimeUnit.SECONDS);
            if (!destroyed) {
                LOG.error("ExecutorService for {} did not shut down within {}s", (Object)owningClassName, (Object)30L);
            }
        }
        catch (InterruptedException e) {
            LOG.error("Interrupted while waiting for ExecutorService to shut down.");
            Thread.currentThread().interrupt();
        }
    }
}

