/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.service;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.jira.plugins.dvcs.dao.ChangesetDao;
import com.atlassian.jira.plugins.dvcs.dao.RepositoryDao;
import com.atlassian.jira.plugins.dvcs.event.ChangesetCreatedEvent;
import com.atlassian.jira.plugins.dvcs.event.DevSummaryChangedEvent;
import com.atlassian.jira.plugins.dvcs.event.ThreadEvents;
import com.atlassian.jira.plugins.dvcs.exception.SourceControlException;
import com.atlassian.jira.plugins.dvcs.model.Changeset;
import com.atlassian.jira.plugins.dvcs.model.ChangesetFile;
import com.atlassian.jira.plugins.dvcs.model.ChangesetFileDetailsEnvelope;
import com.atlassian.jira.plugins.dvcs.model.Changesets;
import com.atlassian.jira.plugins.dvcs.model.GlobalFilter;
import com.atlassian.jira.plugins.dvcs.model.Repository;
import com.atlassian.jira.plugins.dvcs.service.ChangesetService;
import com.atlassian.jira.plugins.dvcs.service.remote.DvcsCommunicator;
import com.atlassian.jira.plugins.dvcs.service.remote.DvcsCommunicatorProvider;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ChangesetServiceImpl
implements ChangesetService {
    private static final Logger logger = LoggerFactory.getLogger(ChangesetServiceImpl.class);
    private final ChangesetDao changesetDao;
    private final ClusterLockService clusterLockService;
    @Resource
    private DvcsCommunicatorProvider dvcsCommunicatorProvider;
    @Resource
    private RepositoryDao repositoryDao;
    @Resource
    private ThreadEvents threadEvents;

    @Autowired
    public ChangesetServiceImpl(ChangesetDao changesetDao, @ComponentImport ClusterLockService clusterLockService) {
        this.changesetDao = (ChangesetDao)Preconditions.checkNotNull((Object)changesetDao);
        this.clusterLockService = (ClusterLockService)Preconditions.checkNotNull((Object)clusterLockService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Changeset create(Changeset changeset, Set<String> extractedIssues) {
        String lockName = Changeset.class.getName() + changeset.getRawNode();
        ClusterLock createLock = this.clusterLockService.getLockForName(lockName);
        createLock.lock();
        try {
            if (this.changesetDao.createOrAssociate(changeset, extractedIssues)) {
                this.broadcastChangesetCreatedEvent(changeset, extractedIssues);
                Repository repository = this.repositoryDao.get(changeset.getRepositoryId());
                this.threadEvents.broadcast(new DevSummaryChangedEvent(changeset.getRepositoryId(), repository.getDvcsType(), extractedIssues));
            }
            Changeset changeset2 = changeset;
            return changeset2;
        }
        finally {
            createLock.unlock();
        }
    }

    private void broadcastChangesetCreatedEvent(Changeset changeset, Set<String> issueKeys) {
        this.threadEvents.broadcast(new ChangesetCreatedEvent(changeset, issueKeys));
    }

    public Changeset update(Changeset changeset) {
        return this.changesetDao.update(changeset);
    }

    public void removeAllInRepository(int repositoryId) {
        this.changesetDao.removeAllInRepository(repositoryId);
    }

    public Changeset getByNode(int repositoryId, String changesetNode) {
        return this.changesetDao.getByNode(repositoryId, changesetNode);
    }

    public List<Changeset> getChangesets(Repository repository) {
        return this.changesetDao.getByRepository(repository.getId());
    }

    public List<Changeset> getChangesetsWithFileDetails(List<Changeset> changesets) {
        ImmutableList.Builder detailedChangesets = ImmutableList.builder();
        ImmutableListMultimap changesetsByRepo = Multimaps.index(changesets, (Function)Changesets.TO_REPOSITORY_ID);
        for (Map.Entry repoChangesets : changesetsByRepo.asMap().entrySet()) {
            Repository repository = this.repositoryDao.get(((Integer)repoChangesets.getKey()).intValue());
            DvcsCommunicator communicator = this.dvcsCommunicatorProvider.getCommunicator(repository.getDvcsType());
            this.processRepository(repository, (Collection)repoChangesets.getValue(), communicator, (ImmutableList.Builder<Changeset>)detailedChangesets);
        }
        return detailedChangesets.build();
    }

    @VisibleForTesting
    void processRepository(Repository repository, Collection<Changeset> changesets, DvcsCommunicator communicator, ImmutableList.Builder<Changeset> detailedChangesets) {
        for (Changeset changeset : changesets) {
            if (changeset.getFileDetails() == null && (changeset = this.changesetDao.migrateFilesData(changeset, repository.getDvcsType())).getFileDetails() == null) {
                try {
                    ChangesetFileDetailsEnvelope changesetFileDetailsEnvelope = communicator.getFileDetails(repository, changeset);
                    List fileDetails = changesetFileDetailsEnvelope.getFileDetails();
                    logger.debug("Loaded file details for {}: {}", (Object)changeset, (Object)fileDetails);
                    changeset.setAllFileCount(changesetFileDetailsEnvelope.getCount());
                    fileDetails = fileDetails.subList(0, Math.min(fileDetails.size(), 5));
                    changeset.setFiles((List)ImmutableList.copyOf(fileDetails));
                    changeset.setFileDetails(fileDetails);
                    changeset = this.changesetDao.update(changeset);
                }
                catch (SourceControlException e) {
                    logger.warn("Error getting file details for: " + changeset, (Throwable)e);
                }
            }
            detailedChangesets.add((Object)changeset);
        }
    }

    public List<Changeset> getByIssueKey(Iterable<String> issueKeys, boolean newestFirst) {
        List changesets = this.changesetDao.getByIssueKey(issueKeys, newestFirst);
        return this.checkChangesetVersion(changesets);
    }

    public List<Changeset> getByIssueKey(Iterable<String> issueKeys, String dvcsType, boolean newestFirst) {
        List changesets = this.changesetDao.getByIssueKey(issueKeys, dvcsType, newestFirst);
        return this.checkChangesetVersion(changesets);
    }

    public String getCommitUrl(Repository repository, Changeset changeset) {
        DvcsCommunicator communicator = this.dvcsCommunicatorProvider.getCommunicator(repository.getDvcsType());
        return communicator.getCommitUrl(repository, changeset);
    }

    public Map<ChangesetFile, String> getFileCommitUrls(Repository repository, Changeset changeset) {
        HashMap<ChangesetFile, String> fileCommitUrls = new HashMap<ChangesetFile, String>();
        if (changeset.getFiles() != null) {
            DvcsCommunicator communicator = this.dvcsCommunicatorProvider.getCommunicator(repository.getDvcsType());
            for (int i = 0; i < changeset.getFiles().size(); ++i) {
                ChangesetFile changesetFile = (ChangesetFile)changeset.getFiles().get(i);
                String fileCommitUrl = communicator.getFileCommitUrl(repository, changeset, changesetFile.getFile(), i);
                fileCommitUrls.put(changesetFile, fileCommitUrl);
            }
        }
        return fileCommitUrls;
    }

    public Iterable<Changeset> getLatestChangesets(int maxResults, GlobalFilter gf) {
        List changesets = this.changesetDao.getLatestChangesets(maxResults, gf);
        this.checkChangesetVersion(changesets);
        return Sets.newHashSet((Iterable)changesets);
    }

    private List<Changeset> checkChangesetVersion(List<Changeset> changesets) {
        return (List)CollectionUtils.collect(changesets, (Transformer)new Transformer(){

            public Object transform(Object input) {
                Changeset changeset = (Changeset)input;
                return ChangesetServiceImpl.this.checkChangesetVersion(changeset);
            }
        });
    }

    @VisibleForTesting
    Changeset checkChangesetVersion(Changeset changeset) {
        if (changeset != null) {
            boolean isLatestVersion;
            boolean bl = isLatestVersion = changeset.getVersion() != null && changeset.getVersion() >= 3;
            if (!isLatestVersion) {
                Repository repository = this.repositoryDao.get(changeset.getRepositoryId());
                DvcsCommunicator communicator = this.dvcsCommunicatorProvider.getCommunicator(repository.getDvcsType());
                Changeset updatedChangeset = communicator.getChangeset(repository, changeset.getNode());
                changeset.setRawAuthor(updatedChangeset.getRawAuthor());
                changeset.setAuthor(updatedChangeset.getAuthor());
                changeset.setDate(updatedChangeset.getDate());
                changeset.setRawNode(updatedChangeset.getRawNode());
                changeset.setParents(updatedChangeset.getParents());
                changeset.setFiles(updatedChangeset.getFiles());
                changeset.setAllFileCount(updatedChangeset.getAllFileCount());
                changeset.setAuthorEmail(updatedChangeset.getAuthorEmail());
                changeset.setFileDetails(updatedChangeset.getFileDetails());
                changeset = this.changesetDao.update(changeset);
            }
        }
        return changeset;
    }

    public Set<String> findReferencedProjects(int repositoryId) {
        return this.changesetDao.findReferencedProjects(repositoryId);
    }

    public Set<String> findEmails(int repositoryId, String author) {
        return this.changesetDao.findEmails(repositoryId, author);
    }
}

