/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.service;

import com.atlassian.jira.plugins.dvcs.dao.BranchDao;
import com.atlassian.jira.plugins.dvcs.event.BranchCreatedEvent;
import com.atlassian.jira.plugins.dvcs.event.DevSummaryChangedEvent;
import com.atlassian.jira.plugins.dvcs.event.ThreadEvents;
import com.atlassian.jira.plugins.dvcs.model.Branch;
import com.atlassian.jira.plugins.dvcs.model.BranchHead;
import com.atlassian.jira.plugins.dvcs.model.Repository;
import com.atlassian.jira.plugins.dvcs.service.BranchService;
import com.atlassian.jira.plugins.dvcs.service.remote.DvcsCommunicator;
import com.atlassian.jira.plugins.dvcs.service.remote.DvcsCommunicatorProvider;
import com.atlassian.jira.plugins.dvcs.sync.impl.IssueKeyExtractor;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BranchServiceImpl
implements BranchService {
    private static final Logger log = LoggerFactory.getLogger(BranchServiceImpl.class);
    @Resource
    private BranchDao branchDao;
    @Resource
    private DvcsCommunicatorProvider dvcsCommunicatorProvider;
    @Resource
    private ThreadEvents threadEvents;

    public void removeAllBranchesInRepository(int repositoryId) {
        this.branchDao.removeAllBranchesInRepository(repositoryId);
    }

    public void removeAllBranchHeadsInRepository(int repositoryId) {
        this.branchDao.removeAllBranchHeadsInRepository(repositoryId);
    }

    public void updateBranches(Repository repository, List<Branch> newBranches) {
        HashSet<Branch> newBranchSet = new HashSet<Branch>(newBranches);
        List oldBranches = this.branchDao.getBranches(repository.getId());
        Set<Branch> oldBranchesSet = this.removeDuplicatesIfNeeded(repository, oldBranches);
        newBranchSet.stream().filter(branch -> !oldBranchesSet.contains(branch)).forEach(branch -> {
            Set<String> issueKeys = IssueKeyExtractor.extractIssueKeys(branch.getName());
            this.branchDao.createBranch(repository.getId(), branch, issueKeys);
            this.broadcastBranchCreatedEvent((Branch)branch, issueKeys);
            this.threadEvents.broadcast(new DevSummaryChangedEvent(repository.getId(), repository.getDvcsType(), issueKeys));
        });
        oldBranchesSet.stream().filter(oldBranch -> !newBranchSet.contains(oldBranch)).forEach(oldBranch -> {
            this.branchDao.removeBranch(repository.getId(), oldBranch);
            Set<String> issueKeys = IssueKeyExtractor.extractIssueKeys(oldBranch.getName());
            this.threadEvents.broadcast(new DevSummaryChangedEvent(repository.getId(), repository.getDvcsType(), issueKeys));
        });
    }

    private Set<Branch> removeDuplicatesIfNeeded(Repository repository, List<Branch> oldBranches) {
        HashSet<Branch> oldBranchesSet = new HashSet<Branch>(oldBranches);
        if (oldBranches.size() != oldBranchesSet.size()) {
            log.info("Duplicate branches detected on repository '{}' [{}]", (Object)repository.getName(), (Object)repository.getId());
            Set<Branch> duplicates = this.findDuplicates(oldBranches);
            log.info("Removing duplicate branches ({}) on repository '{}'", (Object)duplicates.toString(), (Object)repository.getName());
            for (Branch branch : duplicates) {
                this.branchDao.removeBranch(repository.getId(), branch);
                log.info("Branch {} removed", (Object)branch);
            }
            oldBranchesSet.removeAll(duplicates);
        }
        return oldBranchesSet;
    }

    private Set<BranchHead> removeDuplicateBranchHeadIfNeeded(Repository repository, List<BranchHead> oldBranchHeads) {
        HashSet<BranchHead> oldBranchHeadsSet = new HashSet<BranchHead>(oldBranchHeads);
        if (oldBranchHeads.size() != oldBranchHeadsSet.size()) {
            log.info("Duplicate branch heads detected on repository '{}' [{}]", (Object)repository.getName(), (Object)repository.getId());
            Set<BranchHead> duplicates = this.findDuplicates(oldBranchHeads);
            log.info("Removing duplicate branch heads ({}) on repository '{}'", (Object)duplicates.toString(), (Object)repository.getName());
            for (BranchHead branchHead : duplicates) {
                this.branchDao.removeBranchHead(repository.getId(), branchHead);
                log.info("Branch head {} removed", (Object)branchHead);
            }
            oldBranchHeadsSet.removeAll(duplicates);
        }
        return oldBranchHeadsSet;
    }

    private <T> Set<T> findDuplicates(List<T> list) {
        HashMultiset ms = HashMultiset.create(list);
        return Sets.filter((Set)ms.elementSet(), arg_0 -> BranchServiceImpl.lambda$findDuplicates$4((Multiset)ms, arg_0));
    }

    public List<BranchHead> getListOfBranchHeads(Repository repository) {
        return this.branchDao.getBranchHeads(repository.getId());
    }

    public void updateBranchHeads(Repository repository, List<Branch> newBranches, List<BranchHead> oldBranchHeads) {
        if (newBranches != null) {
            Set<BranchHead> oldBranchHeadsSet = this.removeDuplicateBranchHeadIfNeeded(repository, oldBranchHeads);
            HashSet<BranchHead> headAlreadyThere = new HashSet<BranchHead>();
            for (Branch branch : new HashSet<Branch>(newBranches)) {
                for (BranchHead branchHead : branch.getHeads()) {
                    if (oldBranchHeads == null || !oldBranchHeadsSet.contains(branchHead)) {
                        this.branchDao.createBranchHead(repository.getId(), branchHead);
                        continue;
                    }
                    headAlreadyThere.add(branchHead);
                }
            }
            if (oldBranchHeads != null) {
                oldBranchHeadsSet.stream().filter(oldBranchHead -> !headAlreadyThere.contains(oldBranchHead)).forEach(oldBranchHead -> this.branchDao.removeBranchHead(repository.getId(), oldBranchHead));
            }
        }
    }

    public List<Branch> getByIssueKey(Iterable<String> issueKeys) {
        return this.branchDao.getBranchesForIssue(issueKeys);
    }

    public List<Branch> getByIssueKey(Iterable<String> issueKeys, String dvcsType) {
        return this.branchDao.getBranchesForIssue(issueKeys, dvcsType);
    }

    public List<Branch> getForRepository(Repository repository) {
        return this.branchDao.getBranchesForRepository(repository.getId());
    }

    public String getBranchUrl(Repository repository, Branch branch) {
        DvcsCommunicator communicator = this.dvcsCommunicatorProvider.getCommunicator(repository.getDvcsType());
        return communicator.getBranchUrl(repository, branch);
    }

    private void broadcastBranchCreatedEvent(Branch branch, Set<String> issueKeys) {
        this.threadEvents.broadcast(new BranchCreatedEvent(branch, issueKeys, new Date()));
    }

    private static /* synthetic */ boolean lambda$findDuplicates$4(Multiset ms, Object input) {
        return ms.count(input) > 1;
    }
}

