/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.scheduler;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.plugins.dvcs.exception.SourceControlException;
import com.atlassian.jira.plugins.dvcs.model.Repository;
import com.atlassian.jira.plugins.dvcs.service.OrganizationService;
import com.atlassian.jira.plugins.dvcs.service.RepositoryService;
import com.atlassian.jira.plugins.dvcs.service.RepositorySyncService;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DvcsSchedulerJobRunner
implements JobRunner {
    private static final Logger LOG = LoggerFactory.getLogger(DvcsSchedulerJobRunner.class);
    private final ActiveObjects activeObjects;
    private final OrganizationService organizationService;
    private final Predicate<Repository> isOrphan;
    private final RepositoryService repositoryService;
    private final RepositorySyncService repositorySyncService;

    @Autowired
    public DvcsSchedulerJobRunner(ActiveObjects activeObjects, OrganizationService organizationService, RepositoryService repositoryService, RepositorySyncService repositorySyncService) {
        this.repositorySyncService = Objects.requireNonNull(repositorySyncService);
        this.activeObjects = (ActiveObjects)Preconditions.checkNotNull((Object)activeObjects);
        this.isOrphan = repository -> organizationService.get(repository.getOrganizationId(), false) == null;
        this.organizationService = (OrganizationService)Preconditions.checkNotNull((Object)organizationService);
        this.repositoryService = (RepositoryService)Preconditions.checkNotNull((Object)repositoryService);
    }

    @Nullable
    public JobRunnerResponse runJob(@Nonnull JobRunnerRequest request) {
        if (this.activeObjects.moduleMetaData().isDataSourcePresent()) {
            LOG.debug("Running DvcsSchedulerJob");
            this.syncOrganizations();
            this.cleanOrphanRepositories();
        }
        return JobRunnerResponse.success();
    }

    private void syncOrganizations() {
        this.organizationService.getAll(false).stream().forEach(organization -> {
            try {
                long startTime = System.currentTimeMillis();
                Set newRepoSlugs = this.repositorySyncService.reconcileRepoList(organization);
                this.repositorySyncService.syncReposWithUpdates(organization, newRepoSlugs);
                this.organizationService.setLastPolled(organization, startTime);
                LOG.debug("Last update for org {} set to {}", (Object)organization.getName(), (Object)startTime);
            }
            catch (SourceControlException.UnauthorisedException e) {
                LOG.debug("Credential failure synching repository list for " + organization + ": " + e.getMessage(), (Throwable)e);
            }
        });
    }

    private void cleanOrphanRepositories() {
        List orphanRepositories = this.repositoryService.getAllRepositories(true).stream().filter(this.isOrphan).collect(Collectors.toList());
        this.repositoryService.removeOrphanRepositories(orphanRepositories);
    }
}

