/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.scheduler;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.plugins.dvcs.scheduler.DvcsSchedulerJobRunner;
import com.atlassian.jira.plugins.dvcs.service.message.MessagingService;
import com.atlassian.jira.plugins.dvcs.sync.SyncConfig;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={LifecycleAware.class})
public class DvcsScheduler
implements LifecycleAware {
    @VisibleForTesting
    static final JobId JOB_ID = JobId.of((String)(DvcsScheduler.class.getName() + ":job"));
    @VisibleForTesting
    static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)DvcsScheduler.class.getName());
    private static final Logger log = LoggerFactory.getLogger(DvcsScheduler.class);
    private final ActiveObjects activeObjects;
    private final DvcsSchedulerJobRunner dvcsSchedulerJobRunner;
    private final MessagingService messagingService;
    private final SchedulerService schedulerService;
    private final SyncConfig syncConfig;

    @Autowired
    public DvcsScheduler(@ComponentImport ActiveObjects activeObjects, @ComponentImport SchedulerService schedulerService, DvcsSchedulerJobRunner dvcsSchedulerJobRunner, MessagingService messagingService, SyncConfig syncConfig) {
        this.activeObjects = (ActiveObjects)Preconditions.checkNotNull((Object)activeObjects);
        this.dvcsSchedulerJobRunner = (DvcsSchedulerJobRunner)Preconditions.checkNotNull((Object)dvcsSchedulerJobRunner);
        this.messagingService = (MessagingService)Preconditions.checkNotNull((Object)messagingService);
        this.schedulerService = (SchedulerService)Preconditions.checkNotNull((Object)schedulerService);
        this.syncConfig = (SyncConfig)Preconditions.checkNotNull((Object)syncConfig);
    }

    public void onStart() {
        try {
            this.scheduleJob();
        }
        catch (SchedulerServiceException ex) {
            log.error("Unexpected error during launch", (Throwable)ex);
        }
        new Thread(() -> {
            try {
                this.activeObjects.moduleMetaData().awaitInitialization();
                this.messagingService.onStart();
            }
            catch (Exception e) {
                log.error("Exception waiting for AO to initialize", (Throwable)e);
            }
        }, "WaitForAO").start();
    }

    public void onStop() {
        this.schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
        log.debug("DvcsScheduler job handler unregistered");
    }

    @VisibleForTesting
    void scheduleJob() throws SchedulerServiceException {
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)this.dvcsSchedulerJobRunner);
        log.debug("DvcsScheduler job handler registered");
        if (this.schedulerService.getJobDetails(JOB_ID) == null) {
            this.schedulerService.scheduleJob(JOB_ID, this.getJobConfig());
        }
    }

    private JobConfig getJobConfig() {
        long interval = this.syncConfig.scheduledSyncIntervalMillis();
        long randomStartTimeWithinInterval = new Date().getTime() + (long)(new Random().nextDouble() * (double)interval);
        Date startTime = new Date(randomStartTimeWithinInterval);
        log.info("DvcsScheduler start planned at " + startTime + ", interval=" + interval);
        return JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forInterval((long)interval, (Date)startTime));
    }
}

