/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.scheduler;

import com.atlassian.fusion.aci.api.model.ConnectApplication;
import com.atlassian.fusion.aci.api.model.RemoteApplication;
import com.atlassian.fusion.aci.api.service.ACIRegistrationService;
import com.atlassian.jira.plugins.dvcs.service.optional.ServiceAccessor;
import com.atlassian.jira.plugins.dvcs.service.optional.aci.ACIRegistrationServiceAccessor;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@ExportAsService(value={LifecycleAware.class})
public class AciDescriptorRegistrationTask
implements LifecycleAware {
    @VisibleForTesting
    static final String DVCS_CONNECT_DESCRIPTOR_JSON_LOCATION = "/connect/dvcs-connect-descriptor.json";
    private static final Logger LOGGER = LoggerFactory.getLogger(AciDescriptorRegistrationTask.class);
    private final BundleContext bundleContext;

    @Inject
    public AciDescriptorRegistrationTask(BundleContext bundleContext) {
        this.bundleContext = (BundleContext)Preconditions.checkNotNull((Object)bundleContext);
    }

    public void onStart() {
        new ACIRegistrationThunk(this.bundleContext).apply();
    }

    public void onStop() {
    }

    @VisibleForTesting
    static class ACIRegistrationThunk {
        private final ServiceAccessor<ACIRegistrationService> serviceAccessor;

        ACIRegistrationThunk(@Nonnull BundleContext bundleContext) {
            this(new ACIRegistrationServiceAccessor((BundleContext)Preconditions.checkNotNull((Object)bundleContext)));
        }

        ACIRegistrationThunk(@Nonnull ServiceAccessor<ACIRegistrationService> serviceAccessor) {
            this.serviceAccessor = (ServiceAccessor)Preconditions.checkNotNull(serviceAccessor);
        }

        public Optional<ConnectApplication> apply() {
            return this.serviceAccessor.get().flatMap(service -> this.getDescriptorJson().map(descriptor -> service.register("jira-bitbucket-connector-plugin", descriptor, RemoteApplication.BITBUCKET)));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Optional<String> getDescriptorJson() {
            try (InputStream descriptorStream = this.getClass().getResourceAsStream(AciDescriptorRegistrationTask.DVCS_CONNECT_DESCRIPTOR_JSON_LOCATION);){
                Optional<String> optional = Optional.of(IOUtils.toString((InputStream)descriptorStream));
                return optional;
            }
            catch (IOException e) {
                LOGGER.error("DVCS Connector failed to retrieve connect descriptor from classpath", (Throwable)e);
                return Optional.empty();
            }
        }
    }
}

