/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.rest.internal.v1;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.plugins.dvcs.featurediscovery.FeatureDiscoveryService;
import com.atlassian.jira.plugins.dvcs.model.Flag;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@ParametersAreNonnullByDefault
@Path(value="/user")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Internal
public class UserResource {
    private final FeatureDiscoveryService featureDiscoveryService;

    @Inject
    public UserResource(FeatureDiscoveryService featureDiscoveryService) {
        this.featureDiscoveryService = Objects.requireNonNull(featureDiscoveryService);
    }

    @GET
    @Path(value="/flag/featureDiscoverySeen")
    public Response getHasUserSeenFeatureDiscovery() {
        return Response.ok((Object)Flag.of((boolean)this.featureDiscoveryService.hasUserSeenFeatureDiscovery())).build();
    }

    @PUT
    @Path(value="/flag/featureDiscoverySeen")
    public Response setHasUserSeenFeatureDiscovery(@Nonnull Flag flag) {
        Objects.requireNonNull(flag, "A flag value is required");
        this.featureDiscoveryService.markUserAsHavingSeenFeatureDiscovery(flag.getValue());
        return Response.noContent().build();
    }
}

