/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.rest.internal.v1;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.plugins.dvcs.model.Progress;
import com.atlassian.jira.plugins.dvcs.rest.security.AdminOnly;
import com.atlassian.jira.plugins.dvcs.service.RepositorySyncService;
import com.atlassian.jira.plugins.dvcs.sync.SynchronizationFlag;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;

@AdminOnly
@Path(value="/repository")
@Consumes(value={"application/json"})
@ParametersAreNonnullByDefault
@Internal
public class RepositoryResource {
    private final RepositorySyncService repositorySyncService;

    @Inject
    public RepositoryResource(RepositorySyncService repositorySyncService) {
        this.repositorySyncService = Objects.requireNonNull(repositorySyncService);
    }

    @POST
    @Path(value="/{id}/syncAndWait")
    public Response syncRepositorySynchronously(@PathParam(value="id") int repositoryId) {
        Optional progress = this.repositorySyncService.sync(repositoryId, EnumSet.of(SynchronizationFlag.SOFT_SYNC, SynchronizationFlag.SYNC_CHANGESETS, SynchronizationFlag.SYNC_PULL_REQUESTS));
        if (!progress.isPresent()) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        ((Progress)progress.get()).waitForFinish();
        return Response.noContent().build();
    }
}

