/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.rest.internal.v1;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.plugins.dvcs.rest.common.StringElement;
import com.atlassian.jira.plugins.dvcs.rest.security.AdminOnly;
import com.atlassian.jira.plugins.dvcs.spi.bitbucket.clientlibrary.BitbucketDetails;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@AdminOnly
@Path(value="/configuration")
@Consumes(value={"application/json"})
@ParametersAreNonnullByDefault
@Internal
public class ConfigurationResource {
    @GET
    @Produces(value={"application/json"})
    @Path(value="/bitbucket/hostUrl")
    public Response whereIsBitbucket() {
        Response response = Response.ok((Object)StringElement.of(BitbucketDetails.getHostUrl())).build();
        return response;
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/bitbucket/hostUrl")
    public Response hereIsBitbucket(StringElement hostUrl) {
        BitbucketDetails.setHostUrl((String)hostUrl.getValue());
        return Response.noContent().build();
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="/bitbucket/hostUrl")
    public Response clearBitbucketConfiguration() {
        BitbucketDetails.resetHostUrl();
        return Response.noContent().build();
    }
}

