/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.rest.filter;

import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.plugins.dvcs.rest.security.AdminOnly;
import com.atlassian.jira.plugins.dvcs.rest.security.AuthorizationException;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AuthenticationRequiredException;
import com.google.common.base.Preconditions;
import com.sun.jersey.api.model.AbstractMethod;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import com.sun.jersey.spi.container.ResourceFilter;
import javax.ws.rs.ext.Provider;

@Provider
public class AdminOnlyResourceFilter
implements ResourceFilter,
ContainerRequestFilter {
    private final AbstractMethod abstractMethod;
    private final GlobalPermissionManager globalPermissionManager;
    private final JiraAuthenticationContext authenticationContext;

    public AdminOnlyResourceFilter(AbstractMethod abstractMethod, @ComponentImport GlobalPermissionManager globalPermissionManager, @ComponentImport JiraAuthenticationContext authenticationContext) {
        this.abstractMethod = (AbstractMethod)Preconditions.checkNotNull((Object)abstractMethod);
        this.authenticationContext = (JiraAuthenticationContext)Preconditions.checkNotNull((Object)authenticationContext);
        this.globalPermissionManager = (GlobalPermissionManager)Preconditions.checkNotNull((Object)globalPermissionManager);
    }

    public ContainerRequestFilter getRequestFilter() {
        return this;
    }

    public ContainerResponseFilter getResponseFilter() {
        return null;
    }

    public ContainerRequest filter(ContainerRequest request) {
        if (this.isAdminNeeded()) {
            ApplicationUser user = this.authenticationContext.getLoggedInUser();
            if (user == null) {
                throw new AuthenticationRequiredException();
            }
            if (!this.isAdmin(user)) {
                throw new AuthorizationException();
            }
        }
        return request;
    }

    private boolean isAdminNeeded() {
        return this.abstractMethod.getMethod() != null && this.abstractMethod.getMethod().getAnnotation(AdminOnly.class) != null || this.abstractMethod.getResource().getAnnotation(AdminOnly.class) != null;
    }

    private boolean isAdmin(ApplicationUser user) {
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user);
    }
}

