/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.rest.external.v1;

import com.atlassian.jira.plugins.dvcs.model.AccountInfo;
import com.atlassian.jira.plugins.dvcs.model.Group;
import com.atlassian.jira.plugins.dvcs.model.Organization;
import com.atlassian.jira.plugins.dvcs.model.RepositoryList;
import com.atlassian.jira.plugins.dvcs.model.RepositoryRegistration;
import com.atlassian.jira.plugins.dvcs.model.SentData;
import com.atlassian.jira.plugins.dvcs.rest.security.AdminOnly;
import com.atlassian.jira.plugins.dvcs.service.OrganizationService;
import com.atlassian.jira.plugins.dvcs.service.RepositoryService;
import com.atlassian.jira.plugins.dvcs.util.ExceptionLogger;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@Path(value="/")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class RootResource {
    private static final Logger log = ExceptionLogger.getLogger(RootResource.class);
    private final OrganizationService organizationService;
    private final RepositoryService repositoryService;
    private final I18nHelper i18nHelper;

    public RootResource(@Nonnull OrganizationService organizationService, @Nonnull RepositoryService repositoryService, @Nonnull I18nHelper i18nHelper) {
        this.i18nHelper = (I18nHelper)Preconditions.checkNotNull((Object)i18nHelper);
        this.organizationService = (OrganizationService)Preconditions.checkNotNull((Object)organizationService);
        this.repositoryService = (RepositoryService)Preconditions.checkNotNull((Object)repositoryService);
    }

    @GET
    @Path(value="/healthcheck")
    @Produces(value={"text/plain"})
    @AnonymousAllowed
    public Response healthCheck() {
        return Response.ok((Object)"OK").build();
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    @Path(value="/repositories/")
    @AdminOnly
    @Deprecated
    public Response getAllRepositories() {
        List activeRepositories = this.repositoryService.getAllRepositories();
        return Response.ok((Object)new RepositoryList(activeRepositories)).build();
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    @Path(value="/accountInfo")
    @AdminOnly
    public Response accountInfo(@QueryParam(value="server") String server, @QueryParam(value="account") String account) {
        if (StringUtils.isEmpty((CharSequence)server) || StringUtils.isEmpty((CharSequence)account)) {
            log.debug("REST call /accountInfo contained empty server '{}' or account '{}' param", new Object[]{server, account});
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        AccountInfo accountInfo = this.organizationService.getAccountInfo(server, account);
        if (accountInfo != null) {
            return Response.ok((Object)accountInfo).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @POST
    @Produces(value={"application/json", "application/xml"})
    @Path(value="/org/{id}/autolink")
    @Consumes(value={"application/json"})
    @AdminOnly
    public Response enableOrganizationAutolinkNewRepos(@PathParam(value="id") int id, SentData autolink) {
        this.organizationService.enableAutolinkNewRepos(id, Boolean.parseBoolean(autolink.getPayload()));
        return Response.noContent().build();
    }

    @POST
    @Produces(value={"application/json", "application/xml"})
    @Path(value="/org/{id}/globalsmarts")
    @Consumes(value={"application/json"})
    @AdminOnly
    public Response enableSmartcommitsOnNewRepos(@PathParam(value="id") int id, SentData autoinvite) {
        this.organizationService.enableSmartcommitsOnNewRepos(id, Boolean.parseBoolean(autoinvite.getPayload()));
        return Response.noContent().build();
    }

    @POST
    @Produces(value={"application/xml"})
    @Path(value="/org/{id}/oauth")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @AdminOnly
    public Response setOrganizationOAuth(@PathParam(value="id") int id, @FormParam(value="key") String key, @FormParam(value="secret") String secret) {
        Organization organization = this.organizationService.updateOAuthCredentials(id, key, secret);
        if (organization == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.i18nHelper.getText("com.atlassian.jira.plugins.dvcs.service.no-such-organization", (Object)id)).build();
        }
        return Response.ok((Object)organization).build();
    }

    @POST
    @Produces(value={"application/json", "application/xml"})
    @Path(value="/repo/{id}/autolink")
    @Consumes(value={"application/json"})
    @AdminOnly
    public Response enableRepositoryAutolink(@PathParam(value="id") int id, SentData autolink) {
        RepositoryRegistration registration = this.repositoryService.enableRepository(id, Boolean.parseBoolean(autolink.getPayload()));
        return Response.ok((Object)registration).build();
    }

    @POST
    @Produces(value={"application/json", "application/xml"})
    @Path(value="/repo/{id}/smart")
    @Consumes(value={"application/json"})
    @AdminOnly
    public Response enableSmartcommits(@PathParam(value="id") int id, SentData enabled) {
        this.repositoryService.enableRepositorySmartcommits(id, Boolean.parseBoolean(enabled.getPayload()));
        return Response.noContent().build();
    }

    @GET
    @Path(value="/defaultgroups")
    @AdminOnly
    public Response getDefaultGroups() {
        LinkedList organizations = new LinkedList();
        int groupsCount = 0;
        LinkedList errors = new LinkedList();
        for (Organization organization : this.organizationService.getAll(false, "bitbucket")) {
            try {
                HashMap<String, Object> organizationView = new HashMap<String, Object>();
                organizationView.put("id", organization.getId());
                organizationView.put("name", organization.getName());
                organizationView.put("organizationUrl", organization.getOrganizationUrl());
                LinkedList groups = new LinkedList();
                for (Group group : this.organizationService.getGroupsForOrganization(organization)) {
                    ++groupsCount;
                    HashMap<String, Object> groupView = new HashMap<String, Object>();
                    groupView.put("slug", group.getSlug());
                    groupView.put("niceName", group.getNiceName());
                    groupView.put("selected", organization.getDefaultGroups().contains(group));
                    groups.add(groupView);
                }
                organizationView.put("groups", groups);
                organizations.add(organizationView);
            }
            catch (Exception e) {
                log.info(String.format("Failed to get groups for organization %s", organization.getName()), (Throwable)e);
                HashMap<String, String> groupView = new HashMap<String, String>();
                groupView.put("organizationUrl", organization.getOrganizationUrl());
                groupView.put("name", organization.getName());
                errors.add(groupView);
            }
        }
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        result.put("organizations", organizations);
        result.put("groupsCount", Integer.valueOf(groupsCount));
        result.put("errors", errors);
        return Response.ok(result).build();
    }

    @POST
    @Path(value="/linkers/{onoff}")
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    @AdminOnly
    public Response onOffLinkers(@PathParam(value="onoff") String onOff) {
        try {
            boolean onOffBoolean = BooleanUtils.toBoolean((String)onOff);
            this.repositoryService.onOffLinkers(onOffBoolean);
            return Response.ok((Object)"OK").build();
        }
        catch (Exception e) {
            log.info("Failed to reload linkers config.", (Throwable)e);
            return Response.serverError().build();
        }
    }
}

