/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.rest.external.v1;

import com.atlassian.fusion.aci.api.model.Installation;
import com.atlassian.fusion.aci.api.service.ACIJwtService;
import com.atlassian.jira.plugins.dvcs.exception.SourceControlException;
import com.atlassian.jira.plugins.dvcs.model.Organization;
import com.atlassian.jira.plugins.dvcs.model.Repository;
import com.atlassian.jira.plugins.dvcs.model.RepositoryList;
import com.atlassian.jira.plugins.dvcs.rest.ResourceHelper;
import com.atlassian.jira.plugins.dvcs.rest.security.AdminOnly;
import com.atlassian.jira.plugins.dvcs.service.OrganizationService;
import com.atlassian.jira.plugins.dvcs.service.RepositoryService;
import com.atlassian.jira.plugins.dvcs.service.RepositorySyncService;
import com.atlassian.jira.plugins.dvcs.service.optional.aci.ACIJwtServiceAccessor;
import com.atlassian.jira.plugins.dvcs.sync.SynchronizationFlag;
import com.atlassian.jira.plugins.dvcs.util.ExceptionLogger;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.net.URL;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@Path(value="/repository")
@Consumes(value={"application/json"})
public class RepositoryResource {
    private static final Logger log = ExceptionLogger.getLogger(RepositoryResource.class);
    private static final Map<String, SynchronizationFlag> WEBHOOK_EVENT_MAP = ImmutableMap.of((Object)"repo:push", (Object)SynchronizationFlag.SYNC_CHANGESETS, (Object)"pullrequest:created", (Object)SynchronizationFlag.SYNC_PULL_REQUESTS);
    private final OrganizationService organizationService;
    private final RepositoryService repositoryService;
    private final RepositorySyncService repositorySyncService;
    private final ACIJwtServiceAccessor jwtServiceAccessor;

    public RepositoryResource(@Nonnull ACIJwtServiceAccessor jwtServiceAccessor, @Nonnull OrganizationService organizationService, @Nonnull RepositoryService repositoryService, @Nonnull RepositorySyncService repositorySyncService) {
        this.repositorySyncService = (RepositorySyncService)Preconditions.checkNotNull((Object)repositorySyncService);
        this.organizationService = (OrganizationService)Preconditions.checkNotNull((Object)organizationService);
        this.repositoryService = (RepositoryService)Preconditions.checkNotNull((Object)repositoryService);
        this.jwtServiceAccessor = (ACIJwtServiceAccessor)((Object)Preconditions.checkNotNull((Object)((Object)jwtServiceAccessor)));
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    @Path(value="/")
    @AdminOnly
    public Response getAllRepositories() {
        List activeRepositories = this.repositoryService.getAllRepositories();
        return Response.ok((Object)new RepositoryList(activeRepositories)).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    @AdminOnly
    public Response getRepository(@PathParam(value="id") int id) {
        Repository repository = this.repositoryService.get(id);
        if (repository != null) {
            return Response.ok((Object)repository).build();
        }
        return Response.noContent().build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/find")
    @AdminOnly
    public Response getRepositoriesByOrganization(@QueryParam(value="orgId") int orgId) {
        List repositories = this.repositoryService.getAllByOrganization(orgId);
        return Response.ok((Object)repositories).build();
    }

    @POST
    @Produces(value={"text/plain"})
    @Path(value="/disable")
    @AdminOnly
    public Response disableAllRepositories() {
        int reposDisabled = this.repositoryService.disableAllRepositories();
        return Response.ok((Object)String.valueOf(reposDisabled)).build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/{id}/disable")
    @AdminOnly
    public Response disableRepository(@PathParam(value="id") Integer repoId) {
        if (repoId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        this.repositoryService.enableRepository(repoId.intValue(), false);
        return Response.noContent().build();
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/{id}/enable")
    @AdminOnly
    public Response enableRepository(@PathParam(value="id") Integer repoId) {
        this.repositoryService.enableRepository(repoId.intValue(), true);
        return Response.noContent().build();
    }

    @POST
    @Produces(value={"application/json", "application/xml"})
    @Path(value="/{id}/fullSyncPullRequests")
    @AdminOnly
    public Response startRepositoryPullRequestsSynchronization(@PathParam(value="id") int id, @Context UriInfo uriInfo) {
        log.debug("Rest request to pull request fullsync repository [{}] ", (Object)id);
        try {
            this.repositorySyncService.sync(id, EnumSet.of(SynchronizationFlag.SYNC_PULL_REQUESTS));
            UriBuilder ub = uriInfo.getBaseUriBuilder();
            URI uri = ub.path("/repository/{id}").build(new Object[]{id});
            return Response.seeOther((URI)uri).build();
        }
        catch (SourceControlException.SynchronizationDisabled e) {
            return ResourceHelper.buildErrorResponse(Response.Status.SERVICE_UNAVAILABLE, e.getMessage());
        }
    }

    @POST
    @Produces(value={"application/json", "application/xml"})
    @Path(value="/{id}/fullSyncChangesets")
    @AdminOnly
    public Response startRepositoryChangesetsSynchronization(@PathParam(value="id") int id, @Context UriInfo uriInfo) {
        log.debug("Rest request to changesets fullsync repository [{}] ", (Object)id);
        try {
            this.repositorySyncService.sync(id, EnumSet.of(SynchronizationFlag.SYNC_CHANGESETS));
            UriBuilder ub = uriInfo.getBaseUriBuilder();
            URI uri = ub.path("/repository/{id}").build(new Object[]{id});
            return Response.seeOther((URI)uri).build();
        }
        catch (SourceControlException.SynchronizationDisabled e) {
            return ResourceHelper.buildErrorResponse(Response.Status.SERVICE_UNAVAILABLE, e.getMessage());
        }
    }

    @POST
    @Produces(value={"application/json", "application/xml"})
    @Path(value="/{id}/fullsync")
    @AdminOnly
    public Response startRepositoryFullSync(@PathParam(value="id") int id, @Context UriInfo uriInfo) {
        log.debug("Rest request to fullsync repository [{}] ", (Object)id);
        try {
            this.repositorySyncService.sync(id, EnumSet.of(SynchronizationFlag.SYNC_CHANGESETS, SynchronizationFlag.SYNC_PULL_REQUESTS));
            UriBuilder ub = uriInfo.getBaseUriBuilder();
            URI uri = ub.path("/repository/{id}").build(new Object[]{id});
            return Response.seeOther((URI)uri).build();
        }
        catch (SourceControlException.SynchronizationDisabled e) {
            return ResourceHelper.buildErrorResponse(Response.Status.SERVICE_UNAVAILABLE, e.getMessage());
        }
    }

    @POST
    @Produces(value={"application/json", "application/xml"})
    @Path(value="/{id}/softsync")
    @AdminOnly
    public Response startRepositorySoftSync(@PathParam(value="id") int id, @Context UriInfo uriInfo) {
        log.debug("Rest request to softsync repository [{}] ", (Object)id);
        try {
            this.repositorySyncService.sync(id, EnumSet.of(SynchronizationFlag.SOFT_SYNC, SynchronizationFlag.SYNC_CHANGESETS, SynchronizationFlag.SYNC_PULL_REQUESTS));
            UriBuilder ub = uriInfo.getBaseUriBuilder();
            URI uri = ub.path("/repository/{id}").build(new Object[]{id});
            return Response.seeOther((URI)uri).build();
        }
        catch (SourceControlException.SynchronizationDisabled e) {
            return ResourceHelper.buildErrorResponse(Response.Status.SERVICE_UNAVAILABLE, e.getMessage());
        }
    }

    @AnonymousAllowed
    @POST
    @Produces(value={"application/json", "application/xml"})
    @Path(value="/{id}/sync")
    public Response startRepositoryPRSync(@PathParam(value="id") int id, String source) {
        log.info("Pull Request Postcommit hook started synchronization for repository [{}].", (Object)id);
        String key = null;
        try {
            JSONObject jsoned = new JSONObject(source);
            Iterator keys = jsoned.keys();
            if (keys.hasNext()) {
                key = (String)keys.next();
            }
        }
        catch (JSONException e) {
            log.info("Could not parse json request.", (Throwable)e);
        }
        log.debug("Rest request to soft sync pull requests for repository [{}] with type [{}]", (Object)id, key);
        try {
            this.repositorySyncService.sync(id, EnumSet.of(SynchronizationFlag.SOFT_SYNC, SynchronizationFlag.SYNC_PULL_REQUESTS, SynchronizationFlag.WEBHOOK_SYNC));
            return Response.ok().build();
        }
        catch (SourceControlException.SynchronizationDisabled e) {
            return ResourceHelper.buildErrorResponse(Response.Status.SERVICE_UNAVAILABLE, e.getMessage());
        }
    }

    @AnonymousAllowed
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json", "application/xml"})
    @Path(value="/{id}/sync")
    public Response startRepositorySync(@PathParam(value="id") int id, @FormParam(value="payload") String payload) {
        log.info("Postcommit hook started synchronization for repository [{}].", (Object)id);
        log.debug("Rest request to soft sync repository [{}] with payload [{}]", (Object)id, (Object)payload);
        try {
            this.repositorySyncService.sync(id, EnumSet.of(SynchronizationFlag.SOFT_SYNC, SynchronizationFlag.SYNC_CHANGESETS, SynchronizationFlag.WEBHOOK_SYNC));
            return Response.ok().build();
        }
        catch (SourceControlException.SynchronizationDisabled e) {
            return ResourceHelper.buildErrorResponse(Response.Status.SERVICE_UNAVAILABLE, e.getMessage());
        }
    }

    @AnonymousAllowed
    @POST
    @Path(value="/webhook")
    public void receiveWebhook(String payloadString, @Context HttpServletRequest request) {
        log.trace("Received webhook payload: {}", (Object)payloadString);
        log.debug("Received webhook. Processing...");
        try {
            JSONObject payloadJson = new JSONObject(payloadString);
            String eventName = payloadJson.getString("event");
            if (!WEBHOOK_EVENT_MAP.containsKey(eventName)) {
                log.debug("Webhook event '{}' is unsupported. Ignoring webhook.", (Object)eventName);
                return;
            }
            JSONObject repositoryJson = payloadJson.getJSONObject("data").getJSONObject("repository");
            String repoName = repositoryJson.getString("name");
            String principalUuid = repositoryJson.getJSONObject("owner").getString("uuid");
            log.debug("Webhook has event '{}' for repo '{}' owned by '{}'.", new Object[]{eventName, repoName, principalUuid});
            if (!this.verifyJwtHeader(principalUuid, request)) {
                log.debug("Webhook failed JWT authentication. Ignoring webhook.");
                return;
            }
            Organization organization = this.organizationService.getByPrincipalId(principalUuid);
            if (organization == null) {
                log.debug("No organization found for principal UUID '{}'. Ignoring webhook.", (Object)principalUuid);
                return;
            }
            Repository repository = this.repositoryService.getByNameForOrganization(organization.getId(), repoName);
            if (repository == null) {
                log.debug("No repository found with name '{}' for organization '{}'. Ignoring webhook.", (Object)repoName, (Object)organization.getName());
                return;
            }
            if (!repository.isLinked()) {
                log.debug("Repository '{}' is not linked. Ignoring webhook.", (Object)repoName);
                return;
            }
            log.info("Valid webhook received for '{}'. Triggering sync.", (Object)repositoryJson.getString("full_name"));
            EnumSet<Enum> flags = EnumSet.of(SynchronizationFlag.SOFT_SYNC, SynchronizationFlag.WEBHOOK_SYNC, (Enum)WEBHOOK_EVENT_MAP.get(eventName));
            this.repositorySyncService.sync(repository.getId(), flags);
        }
        catch (JSONException e) {
            log.debug("Received a malformed JSON payload. Ignoring webhook.", (Throwable)e);
        }
        catch (Exception e) {
            log.debug("Exception occurred while processing webhook.", (Throwable)e);
        }
    }

    private boolean verifyJwtHeader(String principalId, HttpServletRequest request) {
        String authorizationHeader = request.getHeader("Authorization");
        Optional<ACIJwtService> maybeJwtService = this.jwtServiceAccessor.get();
        if (!maybeJwtService.isPresent()) {
            log.trace("JWT service is not available. Failing verification.");
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)authorizationHeader) || !authorizationHeader.startsWith("JWT")) {
            log.trace("Authentication header is not a JWT token. Failing verification");
            return false;
        }
        log.trace("Verifying '{}' with header '{}'.", (Object)request.getRequestURL(), (Object)authorizationHeader);
        try {
            Installation installation = maybeJwtService.get().verifyJwtToken("jira-bitbucket-connector-plugin", principalId, request.getMethod(), new URL(request.getRequestURL().toString()), authorizationHeader.replace("JWT", "").trim());
            return installation != null;
        }
        catch (Exception e) {
            log.trace("Exception while verifying JWT. Failing verification.", (Throwable)e);
            return false;
        }
    }
}

