/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.rest.external.v1;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.exception.NotFoundException;
import com.atlassian.jira.plugins.dvcs.analytics.AnalyticsService;
import com.atlassian.jira.plugins.dvcs.exception.SourceControlException;
import com.atlassian.jira.plugins.dvcs.model.DvcsUser;
import com.atlassian.jira.plugins.dvcs.model.Group;
import com.atlassian.jira.plugins.dvcs.model.Organization;
import com.atlassian.jira.plugins.dvcs.model.credential.Credential;
import com.atlassian.jira.plugins.dvcs.model.credential.CredentialFactory;
import com.atlassian.jira.plugins.dvcs.rest.ResourceHelper;
import com.atlassian.jira.plugins.dvcs.rest.json.CredentialJson;
import com.atlassian.jira.plugins.dvcs.rest.json.OrganizationAutoSettingsJson;
import com.atlassian.jira.plugins.dvcs.rest.security.AdminOnly;
import com.atlassian.jira.plugins.dvcs.service.OrganizationService;
import com.atlassian.jira.plugins.dvcs.service.RepositorySyncService;
import com.atlassian.jira.plugins.dvcs.util.ExceptionLogger;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
@ExperimentalApi
@Path(value="/organization")
public class OrganizationResource {
    static final String NO_SUCH_ORG_MESSAGE_KEY = "com.atlassian.jira.plugins.dvcs.service.no-such-organization";
    private static final Logger log = ExceptionLogger.getLogger(OrganizationResource.class);
    private final AnalyticsService analyticsService;
    private final OrganizationService organizationService;
    private final RepositorySyncService repositorySyncService;
    private final I18nHelper i18nHelper;

    public OrganizationResource(@ComponentImport I18nHelper i18nHelper, AnalyticsService analyticsService, OrganizationService organizationService, RepositorySyncService repositorySyncService) {
        this.repositorySyncService = repositorySyncService;
        this.analyticsService = (AnalyticsService)Preconditions.checkNotNull((Object)analyticsService);
        this.organizationService = (OrganizationService)Preconditions.checkNotNull((Object)organizationService);
        this.i18nHelper = (I18nHelper)Preconditions.checkNotNull((Object)i18nHelper);
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    @Path(value="/{id}/tokenOwner")
    @AdminOnly
    public Response getTokenOwner(@PathParam(value="id") String organizationId) {
        if (organizationId == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            DvcsUser currentUser = this.organizationService.getTokenOwner(Integer.parseInt(organizationId));
            return Response.ok((Object)currentUser).build();
        }
        catch (Exception e) {
            log.info("Error retrieving token owner", (Throwable)e);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    @GET
    @Produces(value={"application/json", "application/xml"})
    @Path(value="/{id}/syncRepoList")
    @AdminOnly
    public Response syncRepoList(@PathParam(value="id") int id) {
        Organization organization = this.organizationService.get(id, false);
        try {
            this.repositorySyncService.syncRepositoryList(organization);
        }
        catch (SourceControlException e) {
            log.info("Could not refresh repository list", (Throwable)e);
        }
        return Response.noContent().build();
    }

    @GET
    @Path(value="/{id}/defaultgroups")
    @AdminOnly
    @Produces(value={"application/json"})
    public Response getDefaultGroups(@PathParam(value="id") int orgId) {
        HashMap<String, Cloneable> result = new HashMap<String, Cloneable>();
        Organization organization = this.organizationService.get(orgId, false);
        try {
            HashMap<String, Object> organizationResult = new HashMap<String, Object>();
            result.put("organization", organizationResult);
            organizationResult.put("id", organization.getId());
            organizationResult.put("name", organization.getName());
            LinkedList groupsResult = new LinkedList();
            result.put("groups", groupsResult);
            for (Group group : this.organizationService.getGroupsForOrganization(organization)) {
                HashMap<String, Object> groupView = new HashMap<String, Object>();
                groupView.put("slug", group.getSlug());
                groupView.put("niceName", group.getNiceName());
                groupView.put("selected", organization.getDefaultGroups().contains(group));
                groupsResult.add(groupView);
            }
            return Response.ok(result).build();
        }
        catch (SourceControlException.Forbidden_403 e) {
            return ResourceHelper.buildErrorResponse(Response.Status.FORBIDDEN, "Unable to access Bitbucket");
        }
        catch (SourceControlException e) {
            return ResourceHelper.buildErrorResponse(Response.Status.INTERNAL_SERVER_ERROR, "Error retrieving list of groups for " + organization.getOrganizationUrl() + ". Please check JIRA logs for details.");
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @AdminOnly
    public Organization createOrganization(Organization org) {
        return this.organizationService.save(org);
    }

    @GET
    @Produces(value={"application/json"})
    @AdminOnly
    public List<Organization> getOrganizations() {
        return this.organizationService.getAll(true);
    }

    @GET
    @Path(value="/find")
    @Produces(value={"application/json"})
    @AdminOnly
    public Response findOrganization(@QueryParam(value="name") String name, @QueryParam(value="type") String type) {
        return this.organizationService.getAll(false, type).stream().filter(org -> org.getName().equals(name)).findFirst().map(org -> Response.ok((Object)org).build()).orElseGet(() -> Response.status((Response.Status)Response.Status.NOT_FOUND).build());
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    @AdminOnly
    public Organization getOrganization(@PathParam(value="id") int id) {
        return this.organizationService.get(id, true);
    }

    @POST
    @Path(value="/{id}/credential")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @AdminOnly
    public Response setOrganizationCredential(@PathParam(value="id") int id, CredentialJson newCredentialRaw) {
        Credential newCredential = CredentialFactory.buildCredential().setKey(newCredentialRaw.getKey()).setPassword(newCredentialRaw.getPassword()).setPrincipalId(newCredentialRaw.getPrincipalId()).setSecret(newCredentialRaw.getSecret()).setToken(newCredentialRaw.getToken()).setUsername(newCredentialRaw.getUsername()).build();
        Organization organization = this.organizationService.updateCredentials(id, newCredential);
        if (organization == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.i18nHelper.getText(NO_SUCH_ORG_MESSAGE_KEY, (Object)id)).build();
        }
        return Response.ok().build();
    }

    @POST
    @Path(value="/{id}/autosettings")
    @Consumes(value={"application/json"})
    @AdminOnly
    public Response updateAutolinkAndSmartCommits(@PathParam(value="id") int id, OrganizationAutoSettingsJson settings) {
        this.organizationService.setAutolinkAndSmartcommits(id, settings.isEnableAutolink(), settings.isEnableSmartCommits());
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="/{id}")
    @AdminOnly
    public Response deleteOrganization(@PathParam(value="id") int id) {
        if (this.organizationService.get(id, false) == null) {
            log.debug("No Organization found with ID {}.", (Object)id);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        try {
            this.organizationService.remove(id);
        }
        catch (Exception e) {
            log.error("Failed to remove account with id " + id, (Throwable)e);
            return ResourceHelper.buildErrorResponse(Response.Status.INTERNAL_SERVER_ERROR, "Failed to delete account.");
        }
        log.debug("Successfully removed Organization {}.", (Object)id);
        return Response.noContent().build();
    }

    @DELETE
    @AdminOnly
    public Response deleteAllOrganisations() {
        this.organizationService.removeAll();
        return Response.noContent().build();
    }

    @POST
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    @Path(value="/{id}/approve")
    @AdminOnly
    public Response approveOrganization(@PathParam(value="id") int id, @QueryParam(value="approvalLocation") String approvalLocationText) {
        AnalyticsService.OrganizationApprovalLocation approvalLocation = this.parseApprovalLocation(approvalLocationText);
        try {
            Organization organization = this.organizationService.changeOrganizationApprovalState(id, Organization.ApprovalState.APPROVED);
            this.analyticsService.publishOrganizationApproved(organization, approvalLocation);
        }
        catch (NotFoundException e) {
            this.analyticsService.publishOrganizationApprovalFailed(id, approvalLocation, AnalyticsService.OrganizationApprovalFailedReason.ORGANIZATION_ALREADY_REMOVED);
            throw e;
        }
        catch (RuntimeException e) {
            this.analyticsService.publishOrganizationApprovalFailed(id, approvalLocation, AnalyticsService.OrganizationApprovalFailedReason.UNKNOWN_ERROR);
            throw e;
        }
        return Response.noContent().build();
    }

    private AnalyticsService.OrganizationApprovalLocation parseApprovalLocation(String approvalLocationText) {
        if (StringUtils.isBlank((CharSequence)approvalLocationText)) {
            return AnalyticsService.OrganizationApprovalLocation.UNKNOWN;
        }
        try {
            return AnalyticsService.OrganizationApprovalLocation.valueOf((String)approvalLocationText);
        }
        catch (IllegalArgumentException e) {
            return AnalyticsService.OrganizationApprovalLocation.UNKNOWN;
        }
    }

    @POST
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    @Path(value="/{id}/pending")
    @AdminOnly
    public Response pendOrganization(@PathParam(value="id") int id) {
        this.organizationService.changeOrganizationApprovalState(id, Organization.ApprovalState.PENDING_APPROVAL);
        return Response.noContent().build();
    }

    @POST
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    @Path(value="/pending")
    @AdminOnly
    public Response pendAllOrganization() {
        List orgs = this.organizationService.getAll(false);
        for (Organization org : orgs) {
            this.organizationService.changeOrganizationApprovalState(org.getId(), Organization.ApprovalState.PENDING_APPROVAL);
        }
        return Response.noContent().build();
    }
}

