/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.rest.external.v1;

import com.atlassian.adapter.jackson.ObjectMapper;
import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.plugins.dvcs.model.Changeset;
import com.atlassian.jira.plugins.dvcs.model.DvcsUser;
import com.atlassian.jira.plugins.dvcs.model.Participant;
import com.atlassian.jira.plugins.dvcs.model.PullRequest;
import com.atlassian.jira.plugins.dvcs.model.PullRequestRef;
import com.atlassian.jira.plugins.dvcs.model.Repository;
import com.atlassian.jira.plugins.dvcs.model.dev.RestChangeset;
import com.atlassian.jira.plugins.dvcs.model.dev.RestChangesetRepository;
import com.atlassian.jira.plugins.dvcs.model.dev.RestDevResponse;
import com.atlassian.jira.plugins.dvcs.model.dev.RestParticipant;
import com.atlassian.jira.plugins.dvcs.model.dev.RestPrCommit;
import com.atlassian.jira.plugins.dvcs.model.dev.RestPrRepository;
import com.atlassian.jira.plugins.dvcs.model.dev.RestPullRequest;
import com.atlassian.jira.plugins.dvcs.model.dev.RestRef;
import com.atlassian.jira.plugins.dvcs.model.dev.RestRepository;
import com.atlassian.jira.plugins.dvcs.model.dev.RestUser;
import com.atlassian.jira.plugins.dvcs.rest.security.AdminOnly;
import com.atlassian.jira.plugins.dvcs.rest.security.AuthorizationException;
import com.atlassian.jira.plugins.dvcs.service.BranchService;
import com.atlassian.jira.plugins.dvcs.service.ChangesetService;
import com.atlassian.jira.plugins.dvcs.service.PullRequestService;
import com.atlassian.jira.plugins.dvcs.service.RepositoryService;
import com.atlassian.jira.plugins.dvcs.webwork.IssueAndProjectKeyManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.software.api.permissions.SoftwareProjectPermissions;
import com.atlassian.plugins.rest.common.Status;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

@Path(value="/jira-dev")
public class DevToolsResource {
    private final BranchService branchService;
    private final ChangesetService changesetService;
    private final IssueAndProjectKeyManager issueAndProjectKeyManager;
    private final PullRequestService pullRequestService;
    private final RepositoryService repositoryService;

    public DevToolsResource(BranchService branchService, ChangesetService changesetService, IssueAndProjectKeyManager issueAndProjectKeyManager, PullRequestService pullRequestService, RepositoryService repositoryService) {
        this.branchService = (BranchService)Preconditions.checkNotNull((Object)branchService);
        this.changesetService = (ChangesetService)Preconditions.checkNotNull((Object)changesetService);
        this.issueAndProjectKeyManager = (IssueAndProjectKeyManager)Preconditions.checkNotNull((Object)issueAndProjectKeyManager);
        this.pullRequestService = (PullRequestService)Preconditions.checkNotNull((Object)pullRequestService);
        this.repositoryService = (RepositoryService)Preconditions.checkNotNull((Object)repositoryService);
    }

    @GET
    @Path(value="/commits")
    @Produces(value={"application/json"})
    @AdminOnly
    @ExperimentalApi
    public Response getCommitDetails(@QueryParam(value="issue") String issueKey) {
        List changesets = this.changesetService.getByIssueKey(Collections.singleton(issueKey), true);
        List changesetsWithFileDetails = this.changesetService.getChangesetsWithFileDetails(changesets);
        String json = new ObjectMapper().writeValueAsString((Object)changesetsWithFileDetails);
        return Response.ok((Object)json, (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
    }

    @GET
    @Path(value="/detail")
    @Produces(value={"application/json"})
    public Response getCommits(@QueryParam(value="issue") String issueKey) {
        return new RestTransformer<RestChangesetRepository>(){
            private ListMultimap<Integer, Changeset> changesetToRepositoryMapping;

            @Override
            protected Set<Integer> getRepositories(Iterable<String> issueKeys) {
                List changesets = DevToolsResource.this.changesetService.getByIssueKey(issueKeys, true);
                this.changesetToRepositoryMapping = ArrayListMultimap.create();
                for (Changeset changeset : changesets) {
                    Iterator iterator = changeset.getRepositoryIds().iterator();
                    while (iterator.hasNext()) {
                        int repositoryId = (Integer)iterator.next();
                        this.changesetToRepositoryMapping.put((Object)repositoryId, (Object)changeset);
                    }
                }
                return this.changesetToRepositoryMapping.keySet();
            }

            @Override
            protected RestChangesetRepository createRepository() {
                return new RestChangesetRepository();
            }

            @Override
            protected void setData(RestChangesetRepository restRepository, Repository repository) {
                restRepository.setCommits(DevToolsResource.this.createCommits(repository, this.changesetToRepositoryMapping.get((Object)repository.getId())));
            }
        }.getResponse(issueKey);
    }

    private List<RestChangeset> createCommits(Repository repository, List<Changeset> changesets) {
        return changesets.stream().map(changeset -> {
            DvcsUser user = this.repositoryService.getUser(repository, changeset.getAuthor(), changeset.getRawAuthor());
            RestChangeset restChangeset = new RestChangeset();
            restChangeset.setAuthor(new RestUser(user.getUsername(), user.getFullName(), changeset.getAuthorEmail(), user.getAvatar()));
            restChangeset.setAuthorTimestamp(changeset.getDate().getTime());
            restChangeset.setDisplayId(changeset.getNode().substring(0, 7));
            restChangeset.setId(changeset.getRawNode());
            restChangeset.setMessage(changeset.getMessage());
            restChangeset.setFileCount(changeset.getAllFileCount());
            restChangeset.setUrl(this.changesetService.getCommitUrl(repository, changeset));
            if (changeset.getParents() == null) {
                restChangeset.setMerge(true);
            } else {
                restChangeset.setMerge(changeset.getParents().size() > 1);
            }
            return restChangeset;
        }).collect(Collectors.toList());
    }

    @GET
    @Path(value="/pr-detail")
    @Produces(value={"application/json"})
    public Response getPullRequests(@QueryParam(value="issue") String issueKey) {
        return new RestTransformer<RestPrRepository>(){
            private ListMultimap<Integer, PullRequest> prTorepositoryMapping;

            @Override
            protected Set<Integer> getRepositories(Iterable<String> issueKeys) {
                List pullRequests = DevToolsResource.this.pullRequestService.getByIssueKeys(issueKeys, true);
                this.prTorepositoryMapping = Multimaps.index((Iterable)pullRequests, PullRequest::getRepositoryId);
                return this.prTorepositoryMapping.keySet();
            }

            @Override
            protected RestPrRepository createRepository() {
                return new RestPrRepository();
            }

            @Override
            protected void setData(RestPrRepository restRepository, Repository repository) {
                restRepository.setPullRequests(DevToolsResource.this.createPullRequests(repository, this.prTorepositoryMapping.get((Object)repository.getId())));
            }
        }.getResponse(issueKey);
    }

    private List<RestPullRequest> createPullRequests(Repository repository, List<PullRequest> pullRequests) {
        ArrayList<RestPullRequest> restPullRequests = new ArrayList<RestPullRequest>();
        for (PullRequest pullRequest : pullRequests) {
            DvcsUser user = this.repositoryService.getUser(repository, pullRequest.getAuthor(), pullRequest.getAuthor());
            RestPullRequest restPullRequest = new RestPullRequest();
            restPullRequest.setAuthor(new RestUser(user.getUsername(), user.getFullName(), null, user.getAvatar()));
            restPullRequest.setCreatedOn(pullRequest.getCreatedOn().getTime());
            restPullRequest.setTitle(pullRequest.getName());
            restPullRequest.setId(pullRequest.getRemoteId());
            restPullRequest.setUrl(pullRequest.getUrl());
            restPullRequest.setUpdatedOn(pullRequest.getUpdatedOn().getTime());
            restPullRequest.setStatus(pullRequest.getStatus().name());
            restPullRequest.setSource(this.createRef(pullRequest.getSource()));
            restPullRequest.setDestination(this.createRef(pullRequest.getDestination()));
            restPullRequests.add(restPullRequest);
            restPullRequest.setParticipants(this.createParticipants(repository, pullRequest.getParticipants()));
            restPullRequest.setCommentCount(pullRequest.getCommentCount());
            restPullRequest.setCommits(this.createPrCommits(pullRequest.getCommits()));
        }
        return restPullRequests;
    }

    private List<RestParticipant> createParticipants(Repository repository, List<Participant> participants) {
        return participants.stream().map(participant -> {
            DvcsUser user = this.repositoryService.getUser(repository, participant.getUsername(), participant.getUsername());
            RestUser restUser = new RestUser(user.getUsername(), user.getFullName(), null, user.getAvatar());
            return new RestParticipant(restUser, participant.isApproved(), participant.getRole());
        }).collect(Collectors.toList());
    }

    private RestRef createRef(PullRequestRef ref) {
        if (ref == null) {
            return null;
        }
        RestRef restRef = new RestRef();
        restRef.setBranch(ref.getBranch());
        restRef.setRepository(ref.getRepository());
        restRef.setUrl(ref.getRepositoryUrl());
        return restRef;
    }

    private List<RestPrCommit> createPrCommits(List<Changeset> prCommits) {
        if (prCommits == null) {
            return null;
        }
        return prCommits.stream().map(prCommit -> {
            RestPrCommit restPrCommit = new RestPrCommit();
            restPrCommit.setRawAuthor(prCommit.getRawAuthor());
            restPrCommit.setAuthor(prCommit.getAuthor());
            restPrCommit.setDate(prCommit.getDate());
            restPrCommit.setMessage(prCommit.getMessage());
            restPrCommit.setNode(prCommit.getNode());
            return restPrCommit;
        }).collect(Collectors.toList());
    }

    @GET
    @Path(value="/branch")
    @Produces(value={"application/json"})
    public Response getBranches(@QueryParam(value="issue") String issueKey) {
        Issue issue = this.issueAndProjectKeyManager.getIssue(issueKey);
        if (issue == null) {
            return Status.notFound().message("Issue not found").response();
        }
        if (!this.issueAndProjectKeyManager.hasIssuePermission(ProjectPermissions.BROWSE_PROJECTS, issue)) {
            throw new AuthorizationException();
        }
        Project project = issue.getProjectObject();
        if (project == null) {
            return Status.notFound().message("Project was not found").response();
        }
        if (!this.issueAndProjectKeyManager.hasProjectPermission(SoftwareProjectPermissions.VIEW_DEV_TOOLS, project)) {
            throw new AuthorizationException();
        }
        Set<String> issueKeys = this.issueAndProjectKeyManager.getAllIssueKeys(issue);
        Map<String, List> result = Collections.singletonMap("branches", this.branchService.getByIssueKey(issueKeys));
        return Response.ok(result).build();
    }

    private abstract class RestTransformer<T extends RestRepository> {
        private RestTransformer() {
        }

        Response getResponse(String issueKey) {
            Issue issue = DevToolsResource.this.issueAndProjectKeyManager.getIssue(issueKey);
            if (issue == null) {
                return Status.notFound().message("Issue not found").response();
            }
            if (!DevToolsResource.this.issueAndProjectKeyManager.hasIssuePermission(ProjectPermissions.BROWSE_PROJECTS, issue)) {
                throw new AuthorizationException();
            }
            Project project = issue.getProjectObject();
            if (project == null) {
                return Status.notFound().message("Project was not found").response();
            }
            if (!DevToolsResource.this.issueAndProjectKeyManager.hasProjectPermission(SoftwareProjectPermissions.VIEW_DEV_TOOLS, project)) {
                throw new AuthorizationException();
            }
            Set<String> issueKeys = DevToolsResource.this.issueAndProjectKeyManager.getAllIssueKeys(issue);
            Set<Integer> repositoryIds = this.getRepositories(issueKeys);
            HashMap<Integer, Repository> repositories = new HashMap<Integer, Repository>();
            ArrayList<T> restRepositories = new ArrayList<T>();
            Iterator iterator = repositoryIds.iterator();
            while (iterator.hasNext()) {
                int repositoryId = (Integer)iterator.next();
                Repository repository = (Repository)repositories.get(repositoryId);
                if (repository == null) {
                    repository = DevToolsResource.this.repositoryService.get(repositoryId);
                    repositories.put(repositoryId, repository);
                }
                T restRepository = this.createRepository();
                restRepository.setName(repository.getName());
                restRepository.setSlug(repository.getSlug());
                restRepository.setUrl(repository.getRepositoryUrl());
                restRepository.setAvatar(repository.getLogo());
                this.setData(restRepository, repository);
                restRepository.setFork(repository.isFork());
                if (repository.isFork() && repository.getForkOf() != null) {
                    RestChangesetRepository forkOfRepository = new RestChangesetRepository();
                    forkOfRepository.setName(repository.getForkOf().getName());
                    forkOfRepository.setSlug(repository.getForkOf().getSlug());
                    forkOfRepository.setUrl(repository.getForkOf().getRepositoryUrl());
                    restRepository.setForkOf((RestRepository)forkOfRepository);
                }
                restRepositories.add(restRepository);
            }
            RestDevResponse result = new RestDevResponse();
            result.setRepositories(restRepositories);
            return Response.ok((Object)result).build();
        }

        protected abstract Set<Integer> getRepositories(Iterable<String> var1);

        protected abstract T createRepository();

        protected abstract void setData(T var1, Repository var2);
    }
}

