/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.rest.external.v1;

import com.atlassian.jira.plugins.dvcs.dao.SyncAuditLogDao;
import com.atlassian.jira.plugins.dvcs.rest.security.AdminOnly;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.annotation.Resource;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/audit")
public class AuditRootResource {
    private static final Logger log = LoggerFactory.getLogger(AuditRootResource.class);
    @Resource
    private SyncAuditLogDao syncAuditDao;
    @Resource
    @ComponentImport
    private TemplateRenderer templateRender;

    @AdminOnly
    @Produces(value={"text/html"})
    @Path(value="/repository/all/")
    @GET
    public Response showSyncAll(@QueryParam(value="page") Integer page) {
        try {
            StringWriter writer = new StringWriter();
            Map data = MapBuilder.build((Object)"logs", (Object)this.syncAuditDao.getAll(page));
            this.templateRender.render("/templates/dvcs/audit/sync.vm", data, (Writer)writer);
            return Response.ok((Object)writer.toString()).build();
        }
        catch (Exception e) {
            log.warn("", (Throwable)e);
            return Response.serverError().entity((Object)"Failed to render.").build();
        }
    }

    @AdminOnly
    @Produces(value={"text/html"})
    @Path(value="/repository/{id}/")
    @GET
    public Response showSyncByRepo(@PathParam(value="id") int repoId, @QueryParam(value="page") Integer page) {
        try {
            StringWriter writer = new StringWriter();
            Map data = MapBuilder.build((Object)"logs", (Object)this.syncAuditDao.getAllForRepo(repoId, page));
            this.templateRender.render("/templates/dvcs/audit/sync.vm", data, (Writer)writer);
            return Response.ok((Object)writer.toString()).build();
        }
        catch (Exception e) {
            log.warn("", (Throwable)e);
            return Response.serverError().entity((Object)"Failed to render.").build();
        }
    }
}

