/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.rest;

import com.atlassian.jira.exception.NotFoundException;
import com.atlassian.jira.plugins.dvcs.util.ExceptionLogger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;

@Provider
public class ExceptionHandler
implements ExceptionMapper<Exception> {
    private static final Logger log = ExceptionLogger.getLogger(ExceptionHandler.class);

    public Response toResponse(Exception e) {
        if (e instanceof NotFoundException) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).type("text/plain").build();
        }
        if (e instanceof IllegalArgumentException) {
            log.debug("Responding to request with 400", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).type("text/plain").build();
        }
        if (e instanceof WebApplicationException) {
            log.debug("Responding to request with WebApplicationException", (Throwable)e);
            return ((WebApplicationException)e).getResponse();
        }
        log.warn("Uncaught exception in REST layer: " + e, (Throwable)e);
        return Response.serverError().build();
    }
}

