/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.navlinks;

import com.atlassian.jira.plugins.dvcs.model.Organization;
import com.atlassian.jira.plugins.dvcs.service.OrganizationService;
import com.atlassian.plugins.navlink.consumer.menu.services.NavigationLinkComparator;
import com.atlassian.plugins.navlink.producer.navigation.links.LinkSource;
import com.atlassian.plugins.navlink.producer.navigation.services.NavigationLinkRepository;
import com.atlassian.plugins.navlink.producer.navigation.services.RawNavigationLink;
import com.atlassian.plugins.navlink.producer.navigation.services.RawNavigationLinkBuilder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class BitbucketCloudAccountNavLinkRepository
implements NavigationLinkRepository {
    @VisibleForTesting
    static final String BITBUCKET_ORG_TYPE = "bitbucket";
    private static final int WEIGHT = NavigationLinkComparator.Weights.MAX.value();
    private static final String APPLICATION_TYPE = "jira";
    private final OrganizationService organizationService;

    @Nonnull
    private static RawNavigationLink toNavLink(@Nonnull Organization organization) {
        return ((RawNavigationLinkBuilder)((RawNavigationLinkBuilder)((RawNavigationLinkBuilder)((RawNavigationLinkBuilder)((RawNavigationLinkBuilder)((RawNavigationLinkBuilder)new RawNavigationLinkBuilder().applicationType(APPLICATION_TYPE)).href(organization.getOrganizationUrl())).key("home")).labelKey(BitbucketCloudAccountNavLinkRepository.getLinkLabel(organization)).self(false)).source(LinkSource.remoteDefault())).weight(WEIGHT)).build();
    }

    @Nonnull
    @VisibleForTesting
    static String getLinkLabel(@Nonnull Organization organization) {
        return "Bitbucket - " + organization.getName();
    }

    public BitbucketCloudAccountNavLinkRepository(@Nonnull OrganizationService organizationService) {
        this.organizationService = Objects.requireNonNull(organizationService);
    }

    public Iterable<RawNavigationLink> all() {
        return this.matching((Predicate<RawNavigationLink>)Predicates.alwaysTrue());
    }

    public Iterable<RawNavigationLink> matching(Predicate<RawNavigationLink> nullablePredicate) {
        Predicate navLinkPredicate = (Predicate)MoreObjects.firstNonNull(nullablePredicate, (Object)Predicates.alwaysTrue());
        List bitbucketAccounts = this.organizationService.getAll(false, BITBUCKET_ORG_TYPE);
        return bitbucketAccounts.stream().filter(account -> Organization.ApprovalState.APPROVED.equals((Object)account.getApprovalState())).map(BitbucketCloudAccountNavLinkRepository::toNavLink).filter(arg_0 -> ((Predicate)navLinkPredicate).apply(arg_0)).collect(Collectors.toList());
    }
}

