/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.model;

import com.atlassian.jira.plugins.dvcs.activeobjects.v3.ChangesetMapping;
import com.atlassian.jira.plugins.dvcs.model.Changeset;
import com.atlassian.jira.plugins.dvcs.model.ChangesetFile;
import com.atlassian.jira.plugins.dvcs.model.ChangesetFileDetail;
import com.atlassian.jira.plugins.dvcs.model.ChangesetFileDetails;
import com.atlassian.jira.plugins.dvcs.util.CustomStringUtils;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileData {
    private static final Logger logger = LoggerFactory.getLogger(FileData.class);
    private final List<ChangesetFile> files;
    private final int fileCount;
    private final boolean hasDetails;

    FileData(List<ChangesetFile> files, int fileCount, boolean hasDetails) {
        this.files = files;
        this.fileCount = fileCount;
        this.hasDetails = hasDetails;
    }

    @Deprecated
    public static String toJSON(Changeset changeset) {
        JSONObject filesDataJson = new JSONObject();
        try {
            int count = changeset.getAllFileCount();
            filesDataJson.put("count", count);
            if (changeset.getFileDetails() == null) {
                JSONArray filesJson = new JSONArray();
                List files = changeset.getFiles();
                for (int i = 0; i < Math.min(count, 5); ++i) {
                    ChangesetFile changesetFile = (ChangesetFile)files.get(i);
                    JSONObject fileJson = new JSONObject();
                    fileJson.put("filename", (Object)changesetFile.getFile());
                    fileJson.put("status", (Object)changesetFile.getFileAction().getAction());
                    filesJson.put((Object)fileJson);
                }
                filesDataJson.put("files", (Object)filesJson);
            }
            return filesDataJson.toString();
        }
        catch (JSONException e) {
            logger.error("Creating files JSON failed!", (Throwable)e);
            return null;
        }
    }

    @Deprecated
    public static FileData from(ChangesetMapping changesetMapping) {
        return FileData.from(changesetMapping.getFilesData(), changesetMapping.getFileDetailsJson());
    }

    @Deprecated
    public static FileData from(String filesData, String fileDetailsJson) {
        ArrayList<ChangesetFile> files = new ArrayList<ChangesetFile>();
        int fileCount = 0;
        boolean hasFileDetails = true;
        if (StringUtils.isNotBlank((CharSequence)filesData)) {
            try {
                JSONObject filesDataJson = new JSONObject(filesData);
                fileCount = filesDataJson.getInt("count");
                if (fileDetailsJson != null) {
                    files.addAll(ChangesetFileDetails.fromJSON(fileDetailsJson));
                } else {
                    JSONArray filesJson = filesDataJson.optJSONArray("files");
                    if (filesJson.length() == 0) {
                        hasFileDetails = false;
                    } else {
                        for (int i = 0; i < filesJson.length(); ++i) {
                            JSONObject file = filesJson.getJSONObject(i);
                            String filename = file.getString("filename");
                            String status = file.getString("status");
                            if (file.isNull("additions") && file.isNull("deletions")) {
                                files.add(new ChangesetFile(CustomStringUtils.getChangesetFileAction((String)status), filename));
                                hasFileDetails = false;
                                continue;
                            }
                            int additions = file.getInt("additions");
                            int deletions = file.getInt("deletions");
                            files.add((ChangesetFile)new ChangesetFileDetail(CustomStringUtils.getChangesetFileAction((String)status), filename, additions, deletions));
                        }
                    }
                }
            }
            catch (JSONException e) {
                logger.error("Failed parsing files from FileJson data.", (Throwable)e);
            }
        }
        return new FileData(files, fileCount, hasFileDetails);
    }

    public List<ChangesetFile> getFiles() {
        return this.files;
    }

    public int getFileCount() {
        return this.fileCount;
    }

    public boolean hasDetails() {
        return this.hasDetails;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

