/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.listener;

import com.atlassian.crowd.event.user.UserAttributeStoredEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.plugins.dvcs.listener.FirstLoginHandler;
import com.atlassian.jira.software.api.roles.LicenseService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import io.atlassian.fugue.Option;
import java.util.Collections;
import java.util.Set;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserAttributeStoredEventListener
implements InitializingBean,
DisposableBean {
    @VisibleForTesting
    static final String USER_ATTRIBUTE_KEY_LOGIN_COUNT = "login.count";
    private final EventPublisher eventPublisher;
    private final FirstLoginHandler firstLoginHandler;
    private final LicenseService licenseService;

    @Autowired
    public UserAttributeStoredEventListener(@ComponentImport EventPublisher eventPublisher, FirstLoginHandler firstLoginHandler, @ComponentImport LicenseService licenseService) {
        this.eventPublisher = (EventPublisher)Preconditions.checkNotNull((Object)eventPublisher);
        this.firstLoginHandler = (FirstLoginHandler)Preconditions.checkNotNull((Object)firstLoginHandler);
        this.licenseService = (LicenseService)Preconditions.checkNotNull((Object)licenseService);
    }

    @EventListener
    public void onUserAttributeStore(UserAttributeStoredEvent event) {
        Preconditions.checkArgument((event != null ? 1 : 0) != 0, (Object)"Expecting event to be non-null");
        Preconditions.checkArgument((event.getUser() != null ? 1 : 0) != 0, (Object)"Expecting event to contain a non-null user");
        if (this.isFirstLogin(event) && this.licenseService.hasActiveSoftwareLicense()) {
            this.firstLoginHandler.onFirstLogin(event.getUser().getName());
        }
    }

    private boolean isFirstLogin(UserAttributeStoredEvent event) {
        Option<Integer> optionalLoginCount = this.getLoginCount(event);
        return optionalLoginCount.isDefined() && ((Integer)optionalLoginCount.get()).equals(1);
    }

    private Option<Integer> getLoginCount(UserAttributeStoredEvent event) {
        Set<String> attributeValues = this.getAttributeValues(event, USER_ATTRIBUTE_KEY_LOGIN_COUNT);
        if (attributeValues == null || attributeValues.size() != 1) {
            return Option.none();
        }
        String attributeValue = (String)Iterables.getOnlyElement(attributeValues);
        try {
            return Option.some((Object)Integer.parseInt(attributeValue));
        }
        catch (NumberFormatException ex) {
            return Option.none();
        }
    }

    private Set<String> getAttributeValues(UserAttributeStoredEvent event, String attributeKey) {
        Set attributeKeys = event.getAttributeNames();
        return attributeKeys.contains(attributeKey) ? event.getAttributeValues(attributeKey) : Collections.emptySet();
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }
}

