/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.listener;

import com.atlassian.jira.plugins.dvcs.model.Organization;
import com.atlassian.jira.plugins.dvcs.service.OrganizationService;
import com.atlassian.jira.plugins.dvcs.service.remote.DvcsCommunicator;
import com.atlassian.jira.plugins.dvcs.service.remote.DvcsCommunicatorProvider;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserAddedViaInterfaceEventProcessor {
    @VisibleForTesting
    static final String DVCS_TYPE_BITBUCKET = "bitbucket";
    private static final Logger LOGGER = LoggerFactory.getLogger(UserAddedViaInterfaceEventProcessor.class);
    private static final String ORG_ID_GROUP_DELIMITER = ":";
    private final DvcsCommunicatorProvider dvcsCommunicatorProvider;
    private final OrganizationService organizationService;

    @Autowired
    public UserAddedViaInterfaceEventProcessor(DvcsCommunicatorProvider dvcsCommunicatorProvider, OrganizationService organizationService) {
        this.dvcsCommunicatorProvider = (DvcsCommunicatorProvider)Preconditions.checkNotNull((Object)dvcsCommunicatorProvider);
        this.organizationService = (OrganizationService)Preconditions.checkNotNull((Object)organizationService);
    }

    public void process(ApplicationUser user, String serializedUISelection) {
        Preconditions.checkNotNull((Object)(user != null ? 1 : 0), (Object)"Expecting a non-null user");
        Preconditions.checkNotNull((Object)(user.getEmailAddress() != null ? 1 : 0), (Object)"Expecting a non-null email address for the user");
        Preconditions.checkNotNull((Object)(serializedUISelection != null ? 1 : 0), (Object)"Expecting a non-null serialized UI selection");
        if (serializedUISelection.trim().isEmpty()) {
            return;
        }
        Map<Integer, List<String>> groupsByOrganizationId = this.parseSerializedUISelection(serializedUISelection);
        this.inviteUserToOrganizations(user, groupsByOrganizationId);
    }

    private Map<Integer, List<String>> parseSerializedUISelection(String serializedUISelection) {
        HashMap groupsByOrganizationId = Maps.newHashMap();
        for (String orgIdGroupPairStr : serializedUISelection.split(";")) {
            String[] orgIdGroupPair = orgIdGroupPairStr.split(ORG_ID_GROUP_DELIMITER);
            int orgId = Integer.parseInt(orgIdGroupPair[0]);
            String group = orgIdGroupPair[1];
            List groupsForOrgId = (List)groupsByOrganizationId.get(orgId);
            if (groupsForOrgId == null) {
                groupsForOrgId = Lists.newArrayList();
                groupsByOrganizationId.put(orgId, groupsForOrgId);
            }
            groupsForOrgId.add(group);
        }
        return groupsByOrganizationId;
    }

    private void inviteUserToOrganizations(ApplicationUser user, Map<Integer, List<String>> groupsByOrganizationId) {
        DvcsCommunicator dvcsCommunicator = this.dvcsCommunicatorProvider.getCommunicator(DVCS_TYPE_BITBUCKET);
        for (Map.Entry<Integer, List<String>> entry : groupsByOrganizationId.entrySet()) {
            Integer orgId = entry.getKey();
            List<String> groups = entry.getValue();
            Organization organization = this.organizationService.get(orgId.intValue(), false);
            if (organization == null) {
                LOGGER.warn("Skipped inviting user {} to groups {} in organization with id {} because such organization does not exist", new Object[]{user.getUsername(), groups, orgId});
                continue;
            }
            Preconditions.checkState((boolean)DVCS_TYPE_BITBUCKET.equals(organization.getDvcsType()), (Object)"Expecting Bitbucket organizations only");
            LOGGER.debug("Inviting user {} to groups {} in organization {}", new Object[]{user.getUsername(), groups, organization.getName()});
            dvcsCommunicator.inviteUser(organization, groups, user.getEmailAddress());
        }
    }
}

