/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.listener;

import com.atlassian.jira.plugins.dvcs.bitbucket.access.BitbucketTeamService;
import com.atlassian.jira.plugins.dvcs.model.Group;
import com.atlassian.jira.plugins.dvcs.model.Organization;
import com.atlassian.jira.plugins.dvcs.service.remote.DvcsCommunicator;
import com.atlassian.jira.plugins.dvcs.service.remote.DvcsCommunicatorProvider;
import com.atlassian.jira.software.api.roles.LicenseService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserAddedExternallyEventProcessor {
    @VisibleForTesting
    static final String DVCS_TYPE_BITBUCKET = "bitbucket";
    @VisibleForTesting
    static final String SERVICE_DESK_CUSTOMERS_ATTRIBUTE_KEY = "synch.servicedesk.requestor";
    private static final Logger LOGGER = LoggerFactory.getLogger(UserAddedExternallyEventProcessor.class);
    private final BitbucketTeamService bitbucketTeamService;
    private final DvcsCommunicatorProvider dvcsCommunicatorProvider;
    private final LicenseService licenseService;

    @Autowired
    public UserAddedExternallyEventProcessor(@ComponentImport LicenseService licenseService, BitbucketTeamService bitbucketTeamService, DvcsCommunicatorProvider dvcsCommunicatorProvider) {
        this.bitbucketTeamService = (BitbucketTeamService)Preconditions.checkNotNull((Object)bitbucketTeamService);
        this.dvcsCommunicatorProvider = (DvcsCommunicatorProvider)Preconditions.checkNotNull((Object)dvcsCommunicatorProvider);
        this.licenseService = (LicenseService)Preconditions.checkNotNull((Object)licenseService);
    }

    public void process(ApplicationUser user) {
        Preconditions.checkArgument((user != null ? 1 : 0) != 0, (Object)"Expecting user to be non-null");
        if (this.shouldInvite(user)) {
            this.invite(user);
        }
    }

    private boolean shouldInvite(ApplicationUser user) {
        return this.licenseService.isSoftwareUser(user);
    }

    private void invite(ApplicationUser user) {
        DvcsCommunicator dvcsCommunicator = this.dvcsCommunicatorProvider.getCommunicator(DVCS_TYPE_BITBUCKET);
        for (Organization bitbucketTeam : this.bitbucketTeamService.getTeamsWithDefaultGroups()) {
            Collection<String> groups = this.groupNames(bitbucketTeam.getDefaultGroups());
            LOGGER.debug("Inviting user {} to groups {} in organization {}", new Object[]{user.getUsername(), groups, bitbucketTeam.getName()});
            dvcsCommunicator.inviteUser(bitbucketTeam, groups, user.getEmailAddress());
        }
    }

    private Collection<String> groupNames(Collection<Group> groups) {
        return groups.stream().map(Group::getSlug).collect(Collectors.toList());
    }
}

