/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.listener;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.web.action.admin.UserAddedEvent;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserAddedEventListener
implements InitializingBean,
DisposableBean {
    static final String ORG_ID_GROUP_PAIR_SEPARATOR = ";";
    @VisibleForTesting
    static final String REQUEST_KEY_USERNAME = "username";
    @VisibleForTesting
    static final String REQUEST_KEY_DVCS_ORG_SELECTOR = "dvcs_org_selector";
    @VisibleForTesting
    static final String UI_USER_INVITATIONS_PARAM_NAME = "com.atlassian.jira.dvcs.invite.groups";
    private static final Logger LOGGER = LoggerFactory.getLogger(UserAddedEventListener.class);
    private final CrowdService crowdService;
    private final EventPublisher eventPublisher;
    private final UserManager userManager;

    @Autowired
    public UserAddedEventListener(@ComponentImport CrowdService crowdService, @ComponentImport EventPublisher eventPublisher, @ComponentImport UserManager userManager) {
        this.crowdService = (CrowdService)Preconditions.checkNotNull((Object)crowdService);
        this.eventPublisher = (EventPublisher)Preconditions.checkNotNull((Object)eventPublisher);
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager);
    }

    @EventListener
    public void onUserAddedViaCreateUserScreen(UserAddedEvent event) {
        Preconditions.checkNotNull((Object)event, (Object)"Expecting UserAddedEvent to be non-null");
        LOGGER.debug("onUserAddViaInterface - processing event with payload {}", (Object)event.getRequestParameters());
        ApplicationUser user = this.getApplicationUser(event);
        String userInvitationAttribute = this.getUserInvitationAttribute(event);
        try {
            this.crowdService.setUserAttribute(user.getDirectoryUser(), UI_USER_INVITATIONS_PARAM_NAME, Collections.singleton(userInvitationAttribute));
        }
        catch (OperationNotPermittedException ex) {
            throw new RuntimeException("Failed to add Bitbucket teams attribute for user " + user.getName() + ". Bitbucket teams attribute: '" + userInvitationAttribute + "'", ex);
        }
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    private ApplicationUser getApplicationUser(UserAddedEvent event) {
        String username = ((String[])event.getRequestParameters().get(REQUEST_KEY_USERNAME))[0];
        return this.userManager.getUserByName(username);
    }

    private String getUserInvitationAttribute(UserAddedEvent event) {
        String userInvitationAttribute = " ";
        Object[] organizationIdsAndGroupSlugs = (String[])event.getRequestParameters().get(REQUEST_KEY_DVCS_ORG_SELECTOR);
        if (organizationIdsAndGroupSlugs != null) {
            userInvitationAttribute = Joiner.on((String)ORG_ID_GROUP_PAIR_SEPARATOR).join(organizationIdsAndGroupSlugs);
        }
        return userInvitationAttribute;
    }
}

