/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.dvcs.listener;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.UserWithAttributes;
import com.atlassian.jira.plugins.dvcs.listener.UserAddedExternallyEventProcessor;
import com.atlassian.jira.plugins.dvcs.listener.UserAddedViaInterfaceEventProcessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FirstLoginHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(FirstLoginHandler.class);
    private final CrowdService crowdService;
    private final UserAddedExternallyEventProcessor userAddedExternallyEventProcessor;
    private final UserAddedViaInterfaceEventProcessor userAddedViaInterfaceEventProcessor;
    private final UserManager userManager;

    @Autowired
    public FirstLoginHandler(@ComponentImport CrowdService crowdService, @ComponentImport UserManager userManager, UserAddedExternallyEventProcessor userAddedExternallyEventProcessor, UserAddedViaInterfaceEventProcessor userAddedViaInterfaceEventProcessor) {
        this.crowdService = (CrowdService)Preconditions.checkNotNull((Object)crowdService);
        this.userAddedExternallyEventProcessor = (UserAddedExternallyEventProcessor)Preconditions.checkNotNull((Object)userAddedExternallyEventProcessor);
        this.userAddedViaInterfaceEventProcessor = (UserAddedViaInterfaceEventProcessor)Preconditions.checkNotNull((Object)userAddedViaInterfaceEventProcessor);
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager);
    }

    void onFirstLogin(String username) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)username), (Object)("Expecting username to be non-null and non-blank but received '" + username + "'"));
        UserWithAttributes userWithAttributes = this.crowdService.getUserWithAttributes(username);
        String uiSelection = userWithAttributes.getValue("com.atlassian.jira.dvcs.invite.groups");
        LOGGER.debug("User {} logged in for the first time and has Bitbucket teams UI selection value of '{}'", (Object)username, (Object)uiSelection);
        ApplicationUser applicationUser = this.userManager.getUserByName(username);
        if (uiSelection == null) {
            this.userAddedExternallyEventProcessor.process(applicationUser);
        } else {
            this.userAddedViaInterfaceEventProcessor.process(applicationUser, uiSelection);
        }
    }
}

